/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.field_editors;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.python.pydev.shared_ui.tooltips.presenter.ToolTipPresenterHandler;

public class ButtonFieldEditor
extends FieldEditor {
    private Button button;
    private final SelectionListener selectionListener;
    private final String tooltip;
    private final ToolTipPresenterHandler tooltipPresenter;

    public ButtonFieldEditor(String name, String buttonText, Composite parent, SelectionListener selectionListener) {
        this(name, buttonText, parent, selectionListener, null, null);
    }

    public ButtonFieldEditor(String name, String buttonText, Composite parent, SelectionListener selectionListener, String tooltip, ToolTipPresenterHandler tooltipPresenter) {
        this.tooltip = tooltip;
        this.init(name, buttonText);
        this.selectionListener = selectionListener;
        this.tooltipPresenter = tooltipPresenter;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getButtonControl(parent);
    }

    public Button getButtonControl(Composite parent) {
        if (this.button == null) {
            this.button = new Button(parent, 8);
            this.button.setFont(parent.getFont());
            String text = this.getLabelText();
            if (text != null) {
                this.button.setText(text);
            }
            if (this.tooltip != null) {
                if (this.tooltipPresenter != null) {
                    this.button.setData("TIP_DATA", (Object)this.tooltip);
                    this.tooltipPresenter.install((Control)this.button);
                } else {
                    this.button.setToolTipText(this.tooltip);
                }
            }
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ButtonFieldEditor.this.button = null;
                }
            });
            this.button.addSelectionListener(this.getSelectionListener());
        } else {
            this.checkParent((Control)this.button, parent);
        }
        return this.button;
    }

    private SelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 1;
    }
}

