/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor_input;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevFileEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevZipFileEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevZipFileStorage;

public class PyEditorInputFactory
implements IElementFactory {
    public static final String FACTORY_ID = "org.python.pydev.editorinput.pyEditorInputFactory";
    private static final String TAG_FILE = "file";
    private static final String TAG_ZIP_PATH = "zip_path";

    public IAdaptable createElement(IMemento memento) {
        String fileStr = memento.getString(TAG_FILE);
        if (fileStr == null || fileStr.length() == 0) {
            return null;
        }
        String zipPath = memento.getString(TAG_ZIP_PATH);
        File file = new File(fileStr);
        if (zipPath == null || zipPath.length() == 0) {
            URI uri = file.toURI();
            IFile[] ret = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri, 11);
            if (ret != null && ret.length > 0) {
                return new FileEditorInput(ret[0]);
            }
            try {
                return new FileStoreEditorInput(EFS.getStore((URI)uri));
            }
            catch (CoreException coreException) {
                return new PydevFileEditorInput(file);
            }
        }
        return new PydevZipFileEditorInput(new PydevZipFileStorage(file, zipPath));
    }

    public static void saveState(IMemento memento, PydevZipFileEditorInput pydevZipFileEditorInput) {
        memento.putString(TAG_FILE, pydevZipFileEditorInput.getFile().toString());
        memento.putString(TAG_ZIP_PATH, pydevZipFileEditorInput.getZipPath());
    }

    public static void saveState(IMemento memento, PydevFileEditorInput pydevFileEditorInput) {
        memento.putString(TAG_FILE, pydevFileEditorInput.getFile().toString());
    }
}

