/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;

public class BaseAction
extends Action
implements IEditorActionDelegate {
    protected volatile IEditorPart targetEditor;

    public BaseAction() {
    }

    public BaseAction(String text, int style) {
        super(text, style);
    }

    public static boolean canModifyEditor(ITextEditor editor) {
        if (editor instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)editor).isEditorInputModifiable();
        }
        if (editor instanceof ITextEditorExtension) {
            return !((ITextEditorExtension)editor).isEditorInputReadOnly();
        }
        if (editor != null) {
            return editor.isEditable();
        }
        return true;
    }

    public void setEditor(IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setEditor(targetEditor);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    protected ITextEditor getTextEditor() {
        if (this.targetEditor instanceof ITextEditor) {
            return (ITextEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    protected void setCaretPosition(int pos) throws BadLocationException {
        this.getTextEditor().selectAndReveal(pos, 0);
    }

    public void run(IAction action) {
    }
}

