/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.utils.internal.win32;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.python.pydev.shared_core.bundle.BundleUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.utils.IProcessInfo;
import org.python.pydev.shared_core.utils.IProcessList;
import org.python.pydev.shared_core.utils.internal.ProcessInfo;

public class ProcessListWin32Internal
implements IProcessList {
    private IProcessInfo[] NOPROCESS = new IProcessInfo[0];

    @Override
    public IProcessInfo[] getProcessList() {
        IProcessInfo[] procInfos;
        block7: {
            Process p = null;
            String command = null;
            InputStream in = null;
            Bundle bundle = Platform.getBundle((String)"org.python.pydev.shared_core");
            procInfos = this.NOPROCESS;
            try {
                IPath relative = new Path("win32").addTrailingSeparator().append("listtasks.exe");
                File file = BundleUtils.getRelative(relative, bundle);
                if (file == null || !file.exists() || (command = file.getCanonicalPath()) == null) break block7;
                try {
                    p = ProcessUtils.createProcess(new String[]{command}, null, null);
                    in = p.getInputStream();
                    InputStreamReader reader = new InputStreamReader(in);
                    procInfos = this.parseListTasks(reader);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (IOException iOException) {}
        }
        return procInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProcessInfo[] parseListTasks(InputStreamReader reader) {
        BufferedReader br = new BufferedReader(reader);
        ArrayList<ProcessInfo> processList = new ArrayList<ProcessInfo>();
        try {
            while (true) {
                String line;
                if ((line = br.readLine()) == null) {
                    return processList.toArray(new IProcessInfo[processList.size()]);
                }
                int tab = line.indexOf(9);
                if (tab == -1) continue;
                String proc = line.substring(0, tab).trim();
                String name = line.substring(tab).trim();
                if (proc.length() <= 0 || name.length() <= 0) continue;
                try {
                    int pid = Integer.parseInt(proc);
                    processList.add(new ProcessInfo(pid, name));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (IOException iOException) {}
        return processList.toArray(new IProcessInfo[processList.size()]);
    }

    public static void main(String[] args) {
        IProcessInfo[] processList;
        IProcessInfo[] iProcessInfoArray = processList = new ProcessListWin32Internal().getProcessList();
        int n = processList.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessInfo iProcessInfo = iProcessInfoArray[n2];
            System.out.println(iProcessInfo);
            ++n2;
        }
    }
}

