/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.utils;

import org.eclipse.core.runtime.Platform;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.utils.IProcessInfo;
import org.python.pydev.shared_core.utils.IProcessList;
import org.python.pydev.shared_core.utils.internal.linux.ProcessListLinux;
import org.python.pydev.shared_core.utils.internal.macos.ProcessListMac;
import org.python.pydev.shared_core.utils.internal.win32.ProcessListWin32;

public class PlatformUtils {
    public static Integer platform;
    public static int WINDOWS;
    public static int MACOS;
    public static int LINUX;

    static {
        WINDOWS = 1;
        MACOS = 2;
        LINUX = 3;
        try {
            String os = Platform.getOS();
            platform = os.equals("win32") ? Integer.valueOf(WINDOWS) : (os.equals("macosx") ? Integer.valueOf(MACOS) : Integer.valueOf(LINUX));
        }
        catch (NullPointerException nullPointerException) {
            String env = System.getProperty("os.name").toLowerCase();
            platform = env.indexOf("win") != -1 ? Integer.valueOf(WINDOWS) : (env.startsWith("mac os") ? Integer.valueOf(MACOS) : Integer.valueOf(LINUX));
        }
    }

    public static boolean isWindowsPlatform() {
        return platform == WINDOWS;
    }

    public static boolean isMacOsPlatform() {
        return platform == MACOS;
    }

    public static boolean isLinuxPlatform() {
        return platform == LINUX;
    }

    public static IProcessList getProcessList() {
        if (PlatformUtils.isWindowsPlatform()) {
            return new ProcessListWin32();
        }
        if (PlatformUtils.isLinuxPlatform()) {
            return new ProcessListLinux();
        }
        if (PlatformUtils.isMacOsPlatform()) {
            return new ProcessListMac();
        }
        Log.log("Unexpected platform. Unable to list processes.");
        return new IProcessList(){

            @Override
            public IProcessInfo[] getProcessList() {
                return new IProcessInfo[0];
            }
        };
    }
}

