/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariableCollection;
import org.python.pydev.debug.model.PyVariablesPreferences;
import org.python.pydev.debug.ui.variables.AbstractShowReferencesActionDelegate;

public class ShowPrivateReferencesActionDelegate
extends AbstractShowReferencesActionDelegate {
    @Override
    protected boolean isShowReference() {
        return PyVariablesPreferences.isShowPrivateReferences();
    }

    @Override
    protected void setShowReferences(boolean checked) {
        PyVariablesPreferences.setShowPrivateReferences(checked);
    }

    @Override
    protected boolean isShowReferenceProperty(String property) {
        return "DEBUG_UI_VARIABLES_SHOW_PRIVATE_REFERENCES".equals(property);
    }

    @Override
    protected boolean select(Viewer viewer, Object parentElement, PyVariable variable, String variableName) {
        if (variableName != null && variableName.startsWith("_")) {
            Object segment;
            TreePath path;
            if (parentElement instanceof TreePath && (path = (TreePath)parentElement).getSegmentCount() == 1 && (segment = path.getFirstSegment()) instanceof PyVariableCollection) {
                PyVariableCollection varCol = (PyVariableCollection)segment;
                try {
                    String varColName = varCol.getName();
                    if ("self".equals(varColName) || "cls".equals(varColName)) {
                        return true;
                    }
                }
                catch (DebugException debugException) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

