/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.referrers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.debug.model.remote.RunCustomOperationCommand;
import org.python.pydev.debug.referrers.ClearCurrentReferrers;
import org.python.pydev.debug.referrers.ReferrersViewContentProvider;
import org.python.pydev.debug.views.BaseDebugView;
import org.python.pydev.debug.views.ILaunchAndDebugListener;
import org.python.pydev.shared_ui.utils.UIUtils;

public class ReferrersView
extends BaseDebugView {
    private static final String REFERRERS_VIEW_ID = "org.python.pydev.views.ReferrersView";
    private final Set<ReferrerCommandResponseListener> listeners = new HashSet<ReferrerCommandResponseListener>();
    protected final Object listenersLock = new Object();
    protected final List<XMLUtils.XMLToReferrersInfo> xmlToReferrers = new ArrayList<XMLUtils.XMLToReferrersInfo>();
    protected final Object xmlToReferrersLock = new Object();

    public static ReferrersView getView(boolean forceVisible) {
        return (ReferrersView)UIUtils.getView((String)REFERRERS_VIEW_ID, (boolean)forceVisible);
    }

    @Override
    protected ITreeContentProvider createContentProvider() {
        return new ReferrersViewContentProvider();
    }

    @Override
    protected ILaunchAndDebugListener createListener() {
        return new ILaunchAndDebugListener(){

            public void launchRemoved(ILaunch launch) {
                IDebugTarget debugTarget = launch.getDebugTarget();
                if (debugTarget instanceof AbstractDebugTarget) {
                    this.remove((AbstractDebugTarget)debugTarget);
                }
            }

            public void launchChanged(ILaunch launch) {
                if (launch.isTerminated()) {
                    this.launchRemoved(launch);
                }
            }

            public void launchAdded(ILaunch launch) {
            }

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent debugEvent = debugEventArray[n2];
                    if (debugEvent.getSource() instanceof AbstractDebugTarget && debugEvent.getKind() == 8) {
                        AbstractDebugTarget debugTarget = (AbstractDebugTarget)debugEvent.getSource();
                        this.remove(debugTarget);
                    }
                    ++n2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void remove(AbstractDebugTarget debugTarget) {
                if (debugTarget.isTerminated()) {
                    Object object = ReferrersView.this.xmlToReferrersLock;
                    synchronized (object) {
                        Iterator<XMLUtils.XMLToReferrersInfo> iterator = ReferrersView.this.xmlToReferrers.iterator();
                        while (iterator.hasNext()) {
                            XMLUtils.XMLToReferrersInfo next = iterator.next();
                            if (next.target != debugTarget) continue;
                            iterator.remove();
                        }
                    }
                    ReferrersView.this.updateTreeJob.schedule();
                }
            }
        };
    }

    @Override
    protected void configureToolBar(IViewSite viewSite) {
        IActionBars actionBars = viewSite.getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)new ClearCurrentReferrers(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        Object object = this.listenersLock;
        synchronized (object) {
            for (ReferrerCommandResponseListener referrerCommandResponseListener : this.listeners) {
                referrerCommandResponseListener.finish();
            }
            this.listeners.clear();
            Object object2 = this.xmlToReferrersLock;
            synchronized (object2) {
                this.xmlToReferrers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showReferrersFor(AbstractDebugTarget debugTarget, IVariableLocator locator) {
        RunCustomOperationCommand cmd = new RunCustomOperationCommand(debugTarget, locator, "from _pydevd_bundle.pydevd_referrers import get_referrer_info", "get_referrer_info");
        ReferrerCommandResponseListener listener = new ReferrerCommandResponseListener(this, locator, debugTarget);
        Object object = this.listenersLock;
        synchronized (object) {
            this.startProgress();
            this.listeners.add(listener);
        }
        cmd.setCompletionListener(listener);
        debugTarget.postCommand(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSetTreeInput() {
        XMLUtils.XMLToReferrersInfo[] array;
        int size = this.xmlToReferrers.size();
        Object object = this.xmlToReferrersLock;
        synchronized (object) {
            array = this.xmlToReferrers.toArray(new XMLUtils.XMLToReferrersInfo[size]);
        }
        this.viewer.setInput((Object)array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferrersInfo(XMLUtils.XMLToReferrersInfo xmlToReferrers) {
        Object object = this.xmlToReferrersLock;
        synchronized (object) {
            this.xmlToReferrers.add(xmlToReferrers);
        }
        this.updateTreeJob.schedule();
    }

    @Override
    protected void makeLastVisibleInTree(Object input) {
        XMLUtils.XMLToReferrersInfo[] xmlToReferrersInfos;
        if (input instanceof XMLUtils.XMLToReferrersInfo[] && (xmlToReferrersInfos = (XMLUtils.XMLToReferrersInfo[])input).length > 0) {
            XMLUtils.XMLToReferrersInfo element = xmlToReferrersInfos[xmlToReferrersInfos.length - 1];
            if (element.forVar != null) {
                this.viewer.reveal((Object)element.forVar);
            }
        }
    }

    private static final class ReferrerCommandResponseListener
    implements ICommandResponseListener {
        private final IVariableLocator locator;
        private final AbstractDebugTarget debugTarget;
        private ReferrersView referrersView;

        private ReferrerCommandResponseListener(ReferrersView referrersView, IVariableLocator locator, AbstractDebugTarget debugTarget) {
            this.locator = locator;
            this.debugTarget = debugTarget;
            this.referrersView = referrersView;
        }

        @Override
        public void commandComplete(AbstractDebuggerCommand cmd) {
            try {
                if (cmd instanceof RunCustomOperationCommand) {
                    RunCustomOperationCommand c = (RunCustomOperationCommand)cmd;
                    String responsePayload = c.getResponsePayload();
                    if (responsePayload != null) {
                        XMLUtils.XMLToReferrersInfo xmlToReferrers = XMLUtils.XMLToReferrers(this.debugTarget, this.locator, responsePayload);
                        if (xmlToReferrers != null) {
                            this.referrersView.addReferrersInfo(xmlToReferrers);
                        }
                    } else {
                        Log.log((String)"Command to get referrers did not return proper value.");
                    }
                }
            }
            finally {
                this.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish() {
            boolean removedNow;
            Object object = this.referrersView.listenersLock;
            synchronized (object) {
                removedNow = this.referrersView.listeners.remove(this);
            }
            if (removedNow) {
                this.referrersView.endProgress();
            }
        }
    }
}

