/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.prefs;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsoleCommand;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.editor.IPyEditListener4;

public class InteractiveConsoleCommandsSyncListener
implements IPyEditListener,
IPyEditListener4 {
    private ListResourceBundle resources;
    private WeakReference<BaseEditor> weakEditor;
    private Map<String, InteractiveConsoleUserCommandAction> idToAction = new HashMap<String, InteractiveConsoleUserCommandAction>();
    private final ICallbackListener<Object> onCommandIdToHandlerChangedCallback = new ICallbackListener<Object>(){

        public Object call(Object obj) {
            BaseEditor baseEditor = (BaseEditor)InteractiveConsoleCommandsSyncListener.this.weakEditor.get();
            if (baseEditor == null) {
                InteractiveConsoleCommand.onCommandIdToHandlerChanged.unregisterListener((ICallbackListener)this);
            }
            InteractiveConsoleCommandsSyncListener.this.onCreateActions(InteractiveConsoleCommandsSyncListener.this.resources, baseEditor, null);
            return null;
        }
    };

    public void onSave(BaseEditor edit, IProgressMonitor monitor) {
    }

    public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
        Map<String, InteractiveConsoleCommand.InteractiveCommandCustomHandler> commandIdToHandler = InteractiveConsoleCommand.getCommandIdToHandler();
        Set<Map.Entry<String, InteractiveConsoleCommand.InteractiveCommandCustomHandler>> entrySet = commandIdToHandler.entrySet();
        for (Map.Entry<String, InteractiveConsoleCommand.InteractiveCommandCustomHandler> entry : entrySet) {
            if (this.idToAction.containsKey(entry.getKey())) continue;
            InteractiveConsoleUserCommandAction action = new InteractiveConsoleUserCommandAction(resources, "Pyedit.InteractiveConsoleUserCommand", (ITextEditor)baseEditor, entry.getKey());
            action.setActionDefinitionId(entry.getKey());
            action.setId(entry.getKey());
            baseEditor.setAction(FullRepIterable.getLastPart((String)entry.getKey()), (IAction)action);
            this.idToAction.put(entry.getKey(), action);
        }
        this.resources = resources;
        this.weakEditor = new WeakReference<BaseEditor>(baseEditor);
        InteractiveConsoleCommand.onCommandIdToHandlerChanged.registerListener(this.onCommandIdToHandlerChangedCallback);
    }

    public void onDispose(BaseEditor edit, IProgressMonitor monitor) {
        InteractiveConsoleCommand.onCommandIdToHandlerChanged.unregisterListener(this.onCommandIdToHandlerChangedCallback);
    }

    public void onSetDocument(IDocument document, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onEditorCreated(BaseEditor baseEditor) {
        InteractiveConsoleCommand.keepBindingsUpdated();
    }

    private static final class InteractiveConsoleUserCommandAction
    extends TextEditorAction {
        private String commandId;

        private InteractiveConsoleUserCommandAction(ResourceBundle bundle, String prefix, ITextEditor editor, String commandId) {
            super(bundle, prefix, editor);
            this.commandId = commandId;
        }

        public void run() {
            ITextEditor textEditor = this.getTextEditor();
            if (textEditor instanceof PyEdit) {
                PyEdit pyEdit = (PyEdit)textEditor;
                Map<String, InteractiveConsoleCommand.InteractiveCommandCustomHandler> commandIdToHandler = InteractiveConsoleCommand.getCommandIdToHandler();
                InteractiveConsoleCommand.InteractiveCommandCustomHandler iHandler = commandIdToHandler.get(this.commandId);
                if (iHandler != null) {
                    iHandler.execute(pyEdit);
                }
            }
        }
    }
}

