/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.newconsole.EvaluateDebugConsoleExpression;
import org.python.pydev.debug.newconsole.IPyStackFrameProvider;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;

public class PydevDebugConsoleCommunication
implements IScriptConsoleCommunication {
    private int TIMEOUT = 500;
    String EMPTY = "";
    private volatile boolean waitingForInput;
    private volatile String inputReceived;
    private volatile Object lock = new Object();
    private volatile InterpreterResponse nextResponse;
    private final IPyStackFrameProvider consoleFrameProvider;
    private ICallback<Object, Tuple<String, String>> onContentsReceived;
    private boolean bufferedOutput;

    public void setBufferedOutput(boolean bufferedOutput) {
        this.bufferedOutput = bufferedOutput;
    }

    public boolean getBufferedOutput() {
        return this.bufferedOutput;
    }

    public PydevDebugConsoleCommunication(boolean bufferedOutput, IPyStackFrameProvider consoleFrameProvider) {
        this.consoleFrameProvider = consoleFrameProvider;
        this.bufferedOutput = bufferedOutput;
    }

    public boolean isConnected() {
        return this.consoleFrameProvider.getLastSelectedFrame() != null;
    }

    public void setOnContentsReceivedCallback(ICallback<Object, Tuple<String, String>> onContentsReceived) {
        this.onContentsReceived = onContentsReceived;
    }

    public void interrupt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execInterpreter(final String command, ICallback<Object, InterpreterResponse> onResponseReceived) {
        this.nextResponse = null;
        if (this.waitingForInput) {
            this.inputReceived = command;
            this.waitingForInput = false;
        } else {
            Job job = new Job("PyDev Debug Console Communication"){

                protected IStatus run(IProgressMonitor monitor) {
                    PyStackFrame frame = PydevDebugConsoleCommunication.this.consoleFrameProvider.getLastSelectedFrame();
                    if (frame == null) {
                        if (PydevDebugConsoleCommunication.this.onContentsReceived != null) {
                            PydevDebugConsoleCommunication.this.onContentsReceived.call((Object)new Tuple((Object)PydevDebugConsoleCommunication.this.EMPTY, (Object)"[Invalid Frame]: Please select frame to connect the console.\n"));
                        }
                        PydevDebugConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        return Status.CANCEL_STATUS;
                    }
                    EvaluateDebugConsoleExpression evaluateDebugConsoleExpression = new EvaluateDebugConsoleExpression(frame);
                    evaluateDebugConsoleExpression.executeCommand(command, PydevDebugConsoleCommunication.this.bufferedOutput);
                    String result = evaluateDebugConsoleExpression.waitForCommand();
                    try {
                        if (result.length() == 0) {
                            if (PydevDebugConsoleCommunication.this.onContentsReceived != null) {
                                PydevDebugConsoleCommunication.this.onContentsReceived.call((Object)new Tuple((Object)result, (Object)PydevDebugConsoleCommunication.this.EMPTY));
                            }
                            PydevDebugConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                            return Status.CANCEL_STATUS;
                        }
                        EvaluateDebugConsoleExpression.PydevDebugConsoleMessage consoleMessage = XMLUtils.getConsoleMessage(result);
                        if (PydevDebugConsoleCommunication.this.onContentsReceived != null) {
                            PydevDebugConsoleCommunication.this.onContentsReceived.call((Object)new Tuple((Object)consoleMessage.getOutputMessage().toString(), (Object)consoleMessage.getErrorMessage().toString()));
                        }
                        PydevDebugConsoleCommunication.this.nextResponse = new InterpreterResponse(consoleMessage.isMore(), false);
                    }
                    catch (CoreException e) {
                        Log.log((Throwable)e);
                        if (PydevDebugConsoleCommunication.this.onContentsReceived != null) {
                            PydevDebugConsoleCommunication.this.onContentsReceived.call((Object)new Tuple((Object)result, (Object)PydevDebugConsoleCommunication.this.EMPTY));
                        }
                        PydevDebugConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        int timeOut = this.TIMEOUT;
        while (this.nextResponse == null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if ((timeOut -= 20) > 0 || this.nextResponse != null) continue;
            timeOut = this.TIMEOUT / 2;
        }
        onResponseReceived.call((Object)this.nextResponse);
    }

    public ICompletionProposal[] getCompletions(String text, String actTok, int offset, boolean showForTabCompletion) throws Exception {
        ICompletionProposal[] receivedCompletions = new ICompletionProposal[]{};
        if (this.waitingForInput) {
            return new ICompletionProposal[0];
        }
        PyStackFrame frame = this.consoleFrameProvider.getLastSelectedFrame();
        if (frame == null) {
            return new ICompletionProposal[0];
        }
        EvaluateDebugConsoleExpression evaluateDebugConsoleExpression = new EvaluateDebugConsoleExpression(frame);
        String result = evaluateDebugConsoleExpression.getCompletions(actTok, offset);
        if (result.length() > 0) {
            List<Object[]> fromServer = XMLUtils.convertXMLcompletionsFromConsole(result);
            ArrayList<ICompletionProposal> ret = new ArrayList<ICompletionProposal>();
            PydevConsoleCommunication.convertConsoleCompletionsToICompletions(text, actTok, offset, fromServer, ret, false);
            receivedCompletions = ret.toArray(new ICompletionProposal[ret.size()]);
        }
        return receivedCompletions;
    }

    public String getDescription(String text) throws Exception {
        return null;
    }

    public void linkWithDebugSelection(boolean isLinkedWithDebug) {
        this.consoleFrameProvider.linkWithDebugSelection(isLinkedWithDebug);
    }

    public void close() throws Exception {
    }
}

