/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.ui.console.IConsoleFactory;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyDebugTargetConsole;
import org.python.pydev.debug.model.PySourceLocator;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.remote.ListenConnector;
import org.python.pydev.debug.model.remote.RemoteDebuggerConsole;
import org.python.pydev.debug.newconsole.AnyPyStackFrameSelected;
import org.python.pydev.debug.newconsole.IPyStackFrameProvider;
import org.python.pydev.debug.newconsole.PydevConsole;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.PydevDebugConsole;
import org.python.pydev.debug.newconsole.PydevDebugConsoleCommunication;
import org.python.pydev.debug.newconsole.env.JythonEclipseProcess;
import org.python.pydev.debug.newconsole.env.PydevIProcessFactory;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_interactive_console.InteractiveConsolePlugin;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsoleManager;

public class PydevConsoleFactory
implements IConsoleFactory {
    public void openConsole() {
        this.createConsole(null);
    }

    public void createConsole(String additionalInitialComands) {
        try {
            PydevConsoleInterpreter interpreter = PydevConsoleFactory.createDefaultPydevInterpreter();
            if (interpreter == null) {
                return;
            }
            if (interpreter.getFrame() == null) {
                this.createConsole(interpreter, additionalInitialComands);
            } else {
                this.createDebugConsole(interpreter.getFrame(), additionalInitialComands, true, true, (IPyStackFrameProvider)new AnyPyStackFrameSelected());
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void createConsole(final PydevConsoleInterpreter interpreter, final String additionalInitialComands) {
        Job job = new Job("Create Interactive Console"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Create Interactive Console", 4);
                try {
                    PydevConsoleFactory.this.sayHello(interpreter, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    PydevConsoleFactory.this.connectDebugger(interpreter, additionalInitialComands, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    PydevConsoleFactory.this.enableGuiEvents(interpreter, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    try {
                        interpreter.close();
                    }
                    catch (Exception e_inner) {
                        Log.log((Throwable)e_inner);
                    }
                    if (e instanceof UserCanceledException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    Log.log((Throwable)e);
                    Status status = PydevDebugPlugin.makeStatus(4, "Error initializing console.", e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void enableGuiEvents(PydevConsoleInterpreter interpreter, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Enabling GUI Event Loop", 1);
        try {
            try {
                PydevConsoleCommunication consoleCommunication = (PydevConsoleCommunication)interpreter.getConsoleCommunication();
                String enableGuiOnStartup = InteractiveConsolePrefs.getEnableGuiOnStartup();
                consoleCommunication.enableGui(enableGuiOnStartup);
            }
            catch (Exception ex) {
                throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Failed to set GUI event loop integration", ex));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void sayHello(PydevConsoleInterpreter interpreter, IProgressMonitor monitor) throws UserCanceledException, CoreException {
        monitor.beginTask("Connect To PyDev Console Process", 1);
        try {
            PydevConsoleCommunication consoleCommunication = (PydevConsoleCommunication)interpreter.getConsoleCommunication();
            try {
                consoleCommunication.hello((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (UserCanceledException uce) {
                throw uce;
            }
            catch (Exception ex) {
                String message = ex instanceof SocketTimeoutException ? "Timed out after " + InteractiveConsolePrefs.getMaximumAttempts() + " attempts to connect to the console." : "Unexpected error connecting to console.";
                throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, message, ex));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void connectDebugger(PydevConsoleInterpreter interpreter, String additionalInitialComands, IProgressMonitor monitor) throws IOException, CoreException, DebugException, UserCanceledException {
        monitor.beginTask("Connect Debugger", 10);
        try {
            if (interpreter.getFrame() == null) {
                monitor.worked(1);
                PydevConsole console = new PydevConsole(interpreter, additionalInitialComands);
                monitor.worked(1);
                this.createDebugTarget(interpreter, console, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                ScriptConsoleManager manager = ScriptConsoleManager.getInstance();
                manager.add((ScriptConsole)console, true);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createDebugTarget(PydevConsoleInterpreter interpreter, PydevConsole console, IProgressMonitor monitor) throws IOException, CoreException, DebugException, UserCanceledException {
        block12: {
            monitor.beginTask("Connect Debug Target", 2);
            try {
                Process process = interpreter.getProcess();
                if (!InteractiveConsolePrefs.getConsoleConnectDebugSession() || process instanceof JythonEclipseProcess) break block12;
                PydevConsoleCommunication consoleCommunication = (PydevConsoleCommunication)interpreter.getConsoleCommunication();
                int acceptTimeout = PydevPrefs.getPreferences().getInt("CONNECT_TIMEOUT");
                PyDebugTargetConsole pyDebugTargetConsole = null;
                ILaunch launch = interpreter.getLaunch();
                IProcess eclipseProcess = launch.getProcesses()[0];
                RemoteDebuggerConsole debugger = new RemoteDebuggerConsole();
                ListenConnector connector = new ListenConnector(acceptTimeout);
                debugger.startConnect(connector);
                pyDebugTargetConsole = new PyDebugTargetConsole(consoleCommunication, launch, eclipseProcess, debugger);
                Socket socket = null;
                try {
                    consoleCommunication.connectToDebugger(connector.getLocalPort());
                    socket = debugger.waitForConnect(monitor, process, eclipseProcess);
                    if (socket == null) {
                        throw new UserCanceledException("Cancelled");
                    }
                }
                catch (Exception ex) {
                    try {
                        if (ex instanceof UserCanceledException) {
                            consoleCommunication.close();
                            debugger.dispose();
                        } else {
                            debugger.disposeConnector();
                        }
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                    if (ex instanceof UserCanceledException) {
                        UserCanceledException userCancelled = (UserCanceledException)ex;
                        throw userCancelled;
                    }
                    String message = "Unexpected error setting up the debugger";
                    if (ex instanceof SocketTimeoutException) {
                        message = "Timed out after " + Float.toString(acceptTimeout / 1000) + " seconds while waiting for python script to connect.";
                    }
                    throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, message, ex));
                }
                pyDebugTargetConsole.startTransmission(socket);
                pyDebugTargetConsole.initialize();
                consoleCommunication.setDebugTarget(pyDebugTargetConsole);
                launch.addDebugTarget((IDebugTarget)pyDebugTargetConsole);
                launch.setSourceLocator((ISourceLocator)new PySourceLocator());
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.addLaunch(launch);
                pyDebugTargetConsole.setConsole(console);
                console.setProcess(pyDebugTargetConsole.getProcess());
                pyDebugTargetConsole.finishedInit = true;
            }
            finally {
                monitor.done();
            }
        }
    }

    public PydevDebugConsole createDebugConsole(ILaunch launch, String additionalInitialComands, boolean addToManager, boolean bufferedOutput, IPyStackFrameProvider consoleFrameProvider) throws Exception {
        return this.createDebugConsole(launch, null, additionalInitialComands, addToManager, bufferedOutput, consoleFrameProvider);
    }

    public PydevDebugConsole createDebugConsole(PyStackFrame frame, String additionalInitialComands, boolean addToManager, boolean bufferedOutput, IPyStackFrameProvider consoleFrameProvider) throws Exception {
        return this.createDebugConsole(null, frame, additionalInitialComands, addToManager, bufferedOutput, consoleFrameProvider);
    }

    private PydevDebugConsole createDebugConsole(ILaunch launch, PyStackFrame frame, String additionalInitialComands, boolean addToManager, boolean bufferedOutput, IPyStackFrameProvider consoleFrameProvider) throws Exception {
        PydevIProcessFactory.PydevConsoleLaunchInfo launchAndProcess = new PydevIProcessFactory.PydevConsoleLaunchInfo(null, null, 0, null, frame, null, null, launch != null ? PydevIProcessFactory.getEncodingFromLaunch(launch) : PydevIProcessFactory.getEncodingFromFrame(frame));
        PydevConsoleInterpreter interpreter = PydevConsoleFactory.createPydevDebugInterpreter(launchAndProcess, bufferedOutput, consoleFrameProvider);
        PydevDebugConsole console = new PydevDebugConsole(interpreter, additionalInitialComands);
        if (addToManager) {
            ScriptConsoleManager manager = ScriptConsoleManager.getInstance();
            manager.add((ScriptConsole)console, true);
        }
        return console;
    }

    public static PydevConsoleInterpreter createDefaultPydevInterpreter() throws Exception, UserCanceledException {
        PydevIProcessFactory iprocessFactory = new PydevIProcessFactory();
        PydevIProcessFactory.PydevConsoleLaunchInfo launchAndProcess = iprocessFactory.createInteractiveLaunch();
        if (launchAndProcess == null) {
            return null;
        }
        if (launchAndProcess.interpreter != null) {
            return PydevConsoleFactory.createPydevInterpreter(launchAndProcess, iprocessFactory.getNaturesUsed(), launchAndProcess.encoding);
        }
        return PydevConsoleFactory.createPydevDebugInterpreter(launchAndProcess, true, new AnyPyStackFrameSelected());
    }

    public static PydevConsoleInterpreter createPydevInterpreter(PydevIProcessFactory.PydevConsoleLaunchInfo info, List<IPythonNature> natures, String encoding) throws Exception {
        Launch launch = info.launch;
        Process process = info.process;
        Integer clientPort = info.clientPort;
        IInterpreterInfo interpreterInfo = info.interpreter;
        if (launch == null) {
            return null;
        }
        PydevConsoleInterpreter consoleInterpreter = new PydevConsoleInterpreter();
        int port = Integer.parseInt(launch.getAttribute("INTERACTIVE_LAUNCH_PORT"));
        consoleInterpreter.setConsoleCommunication(new PydevConsoleCommunication(port, process, clientPort, info.cmdLine, info.env, encoding));
        consoleInterpreter.setNaturesUsed(natures);
        consoleInterpreter.setInterpreterInfo(interpreterInfo);
        consoleInterpreter.setLaunch((ILaunch)launch);
        consoleInterpreter.setProcess(process);
        InteractiveConsolePlugin.getDefault().addConsoleLaunch((ILaunch)launch);
        consoleInterpreter.addCloseOperation(new Runnable((ILaunch)launch){
            private final /* synthetic */ ILaunch val$launch;
            {
                this.val$launch = iLaunch;
            }

            @Override
            public void run() {
                InteractiveConsolePlugin.getDefault().removeConsoleLaunch(this.val$launch);
            }
        });
        return consoleInterpreter;
    }

    public static PydevConsoleInterpreter createPydevDebugInterpreter(PydevIProcessFactory.PydevConsoleLaunchInfo info, boolean bufferedOutput, IPyStackFrameProvider consoleFrameProvider) throws Exception {
        PyStackFrame frame = info.frame;
        PydevConsoleInterpreter consoleInterpreter = new PydevConsoleInterpreter();
        consoleInterpreter.setFrame(frame);
        consoleInterpreter.setLaunchAndRelatedInfo((ILaunch)info.launch);
        consoleInterpreter.setProcess(info.process);
        consoleInterpreter.setConsoleCommunication(new PydevDebugConsoleCommunication(bufferedOutput, consoleFrameProvider));
        return consoleInterpreter;
    }
}

