/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;

public class GetVariableCommand
extends AbstractDebuggerCommand {
    String locator;
    boolean isError = false;
    int responseCode;
    String payload;

    public GetVariableCommand(AbstractDebugTarget debugger, String locator) {
        super(debugger);
        this.locator = locator;
    }

    @Override
    public String getOutgoing() {
        return GetVariableCommand.makeCommand(this.getCommandId(), this.sequence, this.locator);
    }

    @Override
    public boolean needResponse() {
        return true;
    }

    @Override
    public void processOKResponse(int cmdCode, String payload) {
        this.responseCode = cmdCode;
        if (cmdCode == this.getCommandId()) {
            this.payload = payload;
        } else {
            this.isError = true;
            PydevDebugPlugin.log(4, "Unexpected response to " + this.getClass(), null);
        }
    }

    protected int getCommandId() {
        return 110;
    }

    @Override
    public void processErrorResponse(int cmdCode, String payload) {
        this.responseCode = cmdCode;
        this.payload = payload;
        this.isError = true;
    }

    public String getResponse() throws CoreException {
        if (this.isError) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "pydevd error:" + this.payload, null));
        }
        return this.payload;
    }
}

