/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IStackFrame;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyConditionalBreakPointManager;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariableCollection;
import org.python.pydev.debug.newconsole.EvaluateDebugConsoleExpression;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtils {
    public static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParser getSAXParser() throws CoreException {
        SAXParser parser = null;
        try {
            SAXParserFactory sAXParserFactory = parserFactory;
            synchronized (sAXParserFactory) {
                parser = parserFactory.newSAXParser();
            }
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML SAX error", e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML SAX error", e));
        }
        return parser;
    }

    private static String decode(String value) {
        if (value != null) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static PyThread[] ThreadsFromXML(AbstractDebugTarget target, String payload) throws CoreException {
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToThreadInfo info = new XMLToThreadInfo(target);
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            return info.threads.toArray(new PyThread[0]);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
    }

    static PyVariable createVariable(AbstractDebugTarget target, IVariableLocator locator, Attributes attributes) {
        String isContainer;
        String name = attributes.getValue("name");
        String type = attributes.getValue("type");
        String value = attributes.getValue("value");
        try {
            if (value != null) {
                value = URLDecoder.decode(value, "UTF-8");
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (name != null) {
                name = URLDecoder.decode(name, "UTF-8");
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        PyVariable var = "True".equals(isContainer = attributes.getValue("isContainer")) ? new PyVariableCollection(target, name, type, value, locator) : new PyVariable(target, name, type, value, locator);
        return var;
    }

    public static StoppedStack XMLToStack(AbstractDebugTarget target, String payload) throws CoreException {
        StoppedStack retVal;
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToStackInfo info = null;
            try {
                info = new XMLToStackInfo(target);
                parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            }
            catch (SAXParseException e) {
                info = new XMLToStackInfo(target);
                FastStringBuffer buf2 = XMLUtils.fixXml(payload);
                parser.parse((InputStream)new ByteArrayInputStream(buf2.getBytes()), (DefaultHandler)info);
                Log.log((String)("Received wrong xml which was fixed but indicates problem in the debugger in the server-side (please report error):\n" + payload), (Throwable)e);
            }
            IStackFrame[] stack = info.stack.toArray(new IStackFrame[0]);
            retVal = new StoppedStack(info.thread, info.stopReason, stack);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error reading:" + payload, e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected IO error reading xml:" + payload, e));
        }
        return retVal;
    }

    public static FastStringBuffer fixXml(String payload) {
        int length = payload.length();
        FastStringBuffer buf2 = new FastStringBuffer(length + 10);
        boolean inQuotes = false;
        boolean inTag = false;
        int i = 0;
        while (i < length) {
            char c = payload.charAt(i);
            if (c == '\"') {
                if (inTag) {
                    inQuotes = !inQuotes;
                    buf2.append(c);
                } else {
                    buf2.append("&quot;");
                }
            } else if (c == '<') {
                if (inQuotes) {
                    buf2.append("&lt;");
                } else {
                    inTag = true;
                    buf2.append(c);
                }
            } else if (c == '>') {
                if (inQuotes) {
                    buf2.append("&gt;");
                } else {
                    inTag = false;
                    buf2.append(c);
                }
            } else {
                buf2.append(c);
            }
            ++i;
        }
        return buf2;
    }

    public static PyVariable[] XMLToVariables(AbstractDebugTarget target, IVariableLocator locator, String payload) throws CoreException {
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToVariableInfo info = new XMLToVariableInfo(target, locator);
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            PyVariable[] vars = new PyVariable[info.vars.size()];
            int i = 0;
            while (i < info.vars.size()) {
                vars[i] = info.vars.get(i);
                ++i;
            }
            return vars;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
    }

    public static XMLToReferrersInfo XMLToReferrers(AbstractDebugTarget target, IVariableLocator locationInDb, String payload) {
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToReferrersInfoHandler info = new XMLToReferrersInfoHandler(target, locationInDb);
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            PyVariable[] vars = info.vars.toArray(new PyVariable[info.vars.size()]);
            return new XMLToReferrersInfo(target, info.forVar, vars);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public static List<Object[]> convertXMLcompletionsFromConsole(String payload) throws CoreException {
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToCompletionsInfo info = new XMLToCompletionsInfo();
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            return info.completions;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
    }

    public static EvaluateDebugConsoleExpression.PydevDebugConsoleMessage getConsoleMessage(String payload) throws CoreException {
        EvaluateDebugConsoleExpression.PydevDebugConsoleMessage debugConsoleMessage = new EvaluateDebugConsoleExpression.PydevDebugConsoleMessage();
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            DebugConsoleMessageInfo info = new DebugConsoleMessageInfo();
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            debugConsoleMessage = info.debugConsoleMessage;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error. Payload: " + payload, e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        return debugConsoleMessage;
    }

    public static List<PyConditionalBreakPointManager.ExceptionStackTrace> getExceptionStackTrace(AbstractDebugTarget target, String payload) throws CoreException {
        ArrayList<PyConditionalBreakPointManager.ExceptionStackTrace> exceptionStackTraceList = new ArrayList();
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            ExceptionStackTraceXMLInfo info = new ExceptionStackTraceXMLInfo(target);
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8)), (DefaultHandler)info);
            exceptionStackTraceList = info.exceptionStackTraceList;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        return exceptionStackTraceList;
    }

    static class DebugConsoleMessageInfo
    extends DefaultHandler {
        private EvaluateDebugConsoleExpression.PydevDebugConsoleMessage debugConsoleMessage = new EvaluateDebugConsoleExpression.PydevDebugConsoleMessage();
        private String attrValue;

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.attrValue = new String(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            boolean isError = true;
            if (qName.equalsIgnoreCase("MORE")) {
                return;
            }
            if (qName.equalsIgnoreCase("OUTPUT")) {
                isError = false;
            }
            int i = 0;
            while (i < attributes.getLength()) {
                if (attributes.getQName(i).equalsIgnoreCase("MESSAGE")) {
                    String outputMessage = attributes.getValue(i);
                    this.debugConsoleMessage.appendMessage(outputMessage, isError);
                }
                ++i;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("MORE")) {
                if (this.attrValue.equals("True")) {
                    this.debugConsoleMessage.setMore(true);
                } else {
                    this.debugConsoleMessage.setMore(false);
                }
            }
        }
    }

    static class ExceptionStackTraceXMLInfo
    extends DefaultHandler {
        private List<PyConditionalBreakPointManager.ExceptionStackTrace> exceptionStackTraceList = new ArrayList<PyConditionalBreakPointManager.ExceptionStackTrace>();
        private PyConditionalBreakPointManager.ExceptionStackTrace exceptionStackTrace;
        private AbstractDebugTarget target;

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("FRAME")) {
                String filename = "";
                String name = "";
                String methodObj = "";
                int line = 0;
                int i = 0;
                while (i < attributes.getLength()) {
                    if (!attributes.getQName(i).equalsIgnoreCase("THREAD_ID")) {
                        if (attributes.getQName(i).equalsIgnoreCase("FILE")) {
                            filename = attributes.getValue(i);
                        } else if (attributes.getQName(i).equalsIgnoreCase("LINE")) {
                            line = Integer.parseInt(attributes.getValue(i));
                        } else if (attributes.getQName(i).equalsIgnoreCase("NAME")) {
                            name = attributes.getValue(i);
                        } else if (attributes.getQName(i).equalsIgnoreCase("OBJ")) {
                            methodObj = attributes.getValue(i);
                        }
                    }
                    ++i;
                }
                this.exceptionStackTrace = new PyConditionalBreakPointManager.ExceptionStackTrace(this.target, filename, line, name, methodObj);
                this.exceptionStackTraceList.add(this.exceptionStackTrace);
            }
        }

        public ExceptionStackTraceXMLInfo(AbstractDebugTarget target) {
            this.target = target;
        }
    }

    public static class StoppedStack {
        public final PyThread thread;
        public final String stopReason;
        public final IStackFrame[] stack;

        public StoppedStack(PyThread thread, String stopReason, IStackFrame[] stack) {
            this.thread = thread;
            this.stopReason = stopReason;
            this.stack = stack;
        }
    }

    static class XMLToCompletionsInfo
    extends DefaultHandler {
        public List<Object[]> completions = new ArrayList<Object[]>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("comp")) {
                Object[] comp = new Object[]{XMLUtils.decode(attributes.getValue("p0")), XMLUtils.decode(attributes.getValue("p1")), XMLUtils.decode(attributes.getValue("p2")), XMLUtils.decode(attributes.getValue("p3"))};
                this.completions.add(comp);
            }
        }
    }

    public static class XMLToReferrersInfo {
        public final PyVariable forVar;
        public final PyVariable[] vars;
        public final AbstractDebugTarget target;

        public XMLToReferrersInfo(AbstractDebugTarget target, PyVariable forVar, PyVariable[] vars) {
            this.target = target;
            this.forVar = forVar;
            this.vars = vars;
        }
    }

    static class XMLToReferrersInfoHandler
    extends DefaultHandler {
        private AbstractDebugTarget target;
        public List<PyVariable> vars;
        public PyVariable forVar;
        private IVariableLocator locator;
        private boolean inFor;

        public XMLToReferrersInfoHandler(AbstractDebugTarget target, IVariableLocator locator) {
            this.target = target;
            this.locator = locator;
            this.vars = new ArrayList<PyVariable>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("for")) {
                this.inFor = true;
            } else if (qName.equals("var")) {
                PyVariable var = XMLUtils.createVariable(this.target, this.locator, attributes);
                String id = attributes.getValue("id");
                String foundAs = attributes.getValue("found_as");
                try {
                    if (foundAs != null) {
                        foundAs = URLDecoder.decode(foundAs, "UTF-8");
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                var.setRefererrerFoundInfo(id, foundAs);
                if (this.inFor) {
                    this.forVar = var;
                } else {
                    this.vars.add(var);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("for")) {
                this.inFor = false;
            }
        }
    }

    static class XMLToStackInfo
    extends DefaultHandler {
        public PyThread thread;
        public String stopReason;
        public List<IStackFrame> stack = new ArrayList<IStackFrame>();
        public List<PyVariable> locals;
        public AbstractDebugTarget target;
        PyStackFrame currentFrame;

        public XMLToStackInfo(AbstractDebugTarget target) {
            this.target = target;
        }

        private void startThread(Attributes attributes) throws SAXException {
            String target_id = attributes.getValue("id");
            this.thread = this.target.findThreadByID(target_id);
            if (this.thread == null) {
                throw new SAXException("Thread not found (" + target_id + ")");
            }
            this.stopReason = attributes.getValue("stop_reason");
        }

        private void startFrame(Attributes attributes) {
            String name = attributes.getValue("name");
            String id = attributes.getValue("id");
            String file = attributes.getValue("file");
            try {
                File tempFile;
                if (file != null && (tempFile = new File(file = URLDecoder.decode(file, "UTF-8"))).exists()) {
                    file = FileUtils.getFileAbsolutePath((File)tempFile);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String line = attributes.getValue("line");
            Path filePath = new Path(file);
            this.currentFrame = this.thread.findStackFrameByID(id);
            if (this.currentFrame == null) {
                this.currentFrame = new PyStackFrame(this.thread, id, name, (IPath)filePath, Integer.parseInt(line), this.target);
            } else {
                this.currentFrame.setName(name);
                this.currentFrame.setPath((IPath)filePath);
                this.currentFrame.setLine(Integer.parseInt(line));
            }
            this.stack.add(this.currentFrame);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("thread")) {
                this.startThread(attributes);
            } else if (qName.equals("frame")) {
                this.startFrame(attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    static class XMLToThreadInfo
    extends DefaultHandler {
        public AbstractDebugTarget target;
        public List<PyThread> threads = new ArrayList<PyThread>();

        public XMLToThreadInfo(AbstractDebugTarget target) {
            this.target = target;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("thread")) {
                String name = attributes.getValue("name");
                String id = attributes.getValue("id");
                name = XMLUtils.decode(name);
                this.threads.add(new PyThread(this.target, name, id));
            }
        }
    }

    static class XMLToVariableInfo
    extends DefaultHandler {
        private AbstractDebugTarget target;
        private IVariableLocator locator;
        public List<PyVariable> vars;

        public XMLToVariableInfo(AbstractDebugTarget target, IVariableLocator locator) {
            this.target = target;
            this.locator = locator;
            this.vars = new ArrayList<PyVariable>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("var")) {
                this.vars.add(XMLUtils.createVariable(this.target, this.locator, attributes));
            }
        }
    }
}

