/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console;

import java.io.IOException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.IOConsolePartitioner;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.console.PromptOverlayReplaceGlobalActionHandlers;
import org.python.pydev.debug.console.ShowPromptOverlayAction;
import org.python.pydev.debug.newconsole.CurrentPyStackFrameForConsole;
import org.python.pydev.debug.newconsole.IPyStackFrameProvider;
import org.python.pydev.debug.newconsole.PydevConsoleFactory;
import org.python.pydev.debug.newconsole.PydevDebugConsole;
import org.python.pydev.debug.newconsole.PydevDebugConsoleCommunication;
import org.python.pydev.debug.newconsole.prefs.ColorManager;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;
import org.python.pydev.shared_interactive_console.console.ScriptConsolePrompt;
import org.python.pydev.shared_interactive_console.console.ui.IConsoleStyleProvider;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleListener;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_interactive_console.console.ui.internal.IScriptConsoleContentHandler;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleViewer;

public class PromptOverlay
implements DisposeListener,
Listener,
IScriptConsoleContentHandler {
    private static final String IS_PROMPT_OVERLAY_STYLED_TEXT = "IS_PROMPT_OVERLAY_STYLED_TEXT";
    private StyledText interactiveConsoleTextWidget;
    private StyledText styledText;
    private Composite styledTextParent;
    private CustomPageBookLayout customLayout;
    private final CurrentPyStackFrameForConsole currentPyStackFrameForConsole;
    private ScriptConsoleViewer viewer;
    private PromptOverlayReplaceGlobalActionHandlers promptOverlayActionHandlers;
    private boolean overlayVisible = true;
    private double percSize = 0.3;
    private PydevDebugConsole debugConsole;
    private boolean bufferedOutput = false;

    public PromptOverlay(IOConsolePage consolePage, final ProcessConsole processConsole, CurrentPyStackFrameForConsole currentPyStackFrameForConsole) {
        StyledText styledText;
        SourceViewerConfiguration cfg;
        this.currentPyStackFrameForConsole = currentPyStackFrameForConsole;
        try {
            ILaunch launch = processConsole.getProcess().getLaunch();
            this.debugConsole = new PydevConsoleFactory().createDebugConsole(launch, "", false, this.bufferedOutput, (IPyStackFrameProvider)currentPyStackFrameForConsole);
            cfg = this.debugConsole.createSourceViewerConfiguration();
            processConsole.setAttribute("SCRIPT_DEBUG_CONSOLE_IN_PROCESS_CONSOLE", (Object)this.debugConsole);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return;
        }
        TextConsoleViewer consoleViewer = consolePage.getViewer();
        this.styledText = styledText = (StyledText)consoleViewer.getControl();
        this.styledTextParent = styledText.getParent();
        IConsoleStyleProvider styleProvider = this.debugConsole.createStyleProvider();
        this.viewer = new ScriptConsoleViewer(this.styledTextParent, (ScriptConsole)this.debugConsole, (IScriptConsoleContentHandler)this, styleProvider, this.debugConsole.getInitialCommands(), this.debugConsole.getFocusOnStart(), this.debugConsole.getBackspaceAction(), this.debugConsole.getAutoEditStrategy(), this.debugConsole.getTabCompletionEnabled(), false);
        this.viewer.configure(cfg);
        Layout currentLayout = this.styledTextParent.getLayout();
        this.customLayout = new CustomPageBookLayout(currentLayout);
        this.interactiveConsoleTextWidget = this.viewer.getTextWidget();
        this.interactiveConsoleTextWidget.setData(IS_PROMPT_OVERLAY_STYLED_TEXT, (Object)Boolean.TRUE);
        final IOConsoleOutputStream streamPrompt = processConsole.newOutputStream();
        final IOConsoleOutputStream stream = processConsole.newOutputStream();
        this.promptOverlayActionHandlers = new PromptOverlayReplaceGlobalActionHandlers(consolePage, this.viewer);
        IActionBars bars = consolePage.getSite().getActionBars();
        IToolBarManager toolbarManager = bars.getToolBarManager();
        ShowPromptOverlayAction showPromptOverlayAction = new ShowPromptOverlayAction(this);
        toolbarManager.prependToGroup("launchGroup", (IAction)showPromptOverlayAction);
        bars.updateActionBars();
        this.debugConsole.addListener(new IScriptConsoleListener(){

            public void userRequest(String text, ScriptConsolePrompt prompt) {
                try {
                    if (!PromptOverlay.this.bufferedOutput) {
                        streamPrompt.setColor(ColorManager.getDefault().getPreferenceColor("pydevconsole_prompt_color"));
                        stream.setColor(ColorManager.getDefault().getPreferenceColor("pydevconsole_sysin_color"));
                        IDocument document = processConsole.getDocument();
                        IDocumentPartitioner partitioner = document.getDocumentPartitioner();
                        IOConsolePartitioner ioConsolePartitioner = (IOConsolePartitioner)partitioner;
                        ioConsolePartitioner.streamAppended(streamPrompt, prompt.toString());
                        ioConsolePartitioner.streamAppended(stream, String.valueOf(text) + "\n");
                    }
                }
                catch (IOException e) {
                    Log.log((Throwable)e);
                }
            }

            public void interpreterResponse(InterpreterResponse response, ScriptConsolePrompt prompt) {
            }
        });
        styledText.addDisposeListener((DisposeListener)this);
        styledText.addListener(23, (Listener)this);
        styledText.addListener(22, (Listener)this);
        styledText.addListener(9, (Listener)this);
        styledText.addListener(11, (Listener)this);
        styledText.addListener(13, (Listener)this);
        this.adjust();
    }

    public void contentAssistRequired() {
        if (this.currentPyStackFrameForConsole.getLastSelectedFrame() == null) {
            return;
        }
        this.viewer.getContentAssist().showPossibleCompletions();
    }

    public void quickAssistRequired() {
        this.viewer.getQuickAssistAssistant().showPossibleQuickAssists();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public void handleEvent(Event event) {
        this.adjust();
    }

    private void adjust() {
        if (this.styledTextParent == null || this.styledTextParent.isDisposed()) {
            return;
        }
        if (this.overlayVisible && this.styledText != null && !this.styledText.isDisposed() && this.styledText.isVisible()) {
            if (this.styledTextParent.getLayout() != this.customLayout) {
                this.styledTextParent.setLayout((Layout)this.customLayout);
                this.styledTextParent.layout(true);
            }
            if (!this.interactiveConsoleTextWidget.isVisible()) {
                this.interactiveConsoleTextWidget.setVisible(true);
            }
            if (!this.interactiveConsoleTextWidget.getBackground().equals((Object)this.styledText.getBackground())) {
                this.interactiveConsoleTextWidget.setBackground(this.styledText.getBackground());
            }
            if (!this.interactiveConsoleTextWidget.getForeground().equals((Object)this.styledText.getForeground())) {
                this.interactiveConsoleTextWidget.setForeground(this.styledText.getForeground());
            }
            if (!this.interactiveConsoleTextWidget.getFont().equals((Object)this.styledText.getFont())) {
                this.interactiveConsoleTextWidget.setFont(this.styledText.getFont());
            }
        } else {
            if (this.interactiveConsoleTextWidget.isVisible()) {
                this.interactiveConsoleTextWidget.setVisible(false);
            }
            if (this.styledTextParent.getLayout() != this.customLayout.originalParentLayout) {
                this.styledTextParent.setLayout(this.customLayout.originalParentLayout);
                this.styledTextParent.layout(true);
            }
        }
    }

    public void dispose() {
        try {
            this.styledText = null;
            if (this.interactiveConsoleTextWidget != null) {
                this.interactiveConsoleTextWidget.setVisible(false);
                this.interactiveConsoleTextWidget.dispose();
                this.interactiveConsoleTextWidget = null;
            }
        }
        catch (Exception e1) {
            Log.log((Throwable)e1);
        }
        try {
            if (this.styledTextParent != null) {
                if (!this.styledTextParent.isDisposed() && this.styledTextParent.getLayout() == this.customLayout) {
                    this.styledTextParent.setLayout(this.customLayout.originalParentLayout);
                }
                this.styledTextParent = null;
            }
        }
        catch (Exception e1) {
            Log.log((Throwable)e1);
        }
        try {
            if (this.promptOverlayActionHandlers != null) {
                this.promptOverlayActionHandlers.dispose();
            }
            this.promptOverlayActionHandlers = null;
        }
        catch (Exception e1) {
            Log.log((Throwable)e1);
        }
    }

    public void setOverlayVisible(boolean visible) {
        if (this.overlayVisible != visible) {
            this.overlayVisible = visible;
            this.adjustAndLayout();
        }
    }

    public int getRelativeConsoleHeight() {
        return (int)(this.percSize * 100.0);
    }

    public void setRelativeConsoleHeight(int relSize0To100) {
        double newVal = (double)relSize0To100 / 100.0;
        if (newVal != this.percSize) {
            this.percSize = newVal;
            this.adjustAndLayout();
        }
    }

    private void adjustAndLayout() {
        this.adjust();
        if (this.styledTextParent != null && !this.styledTextParent.isDisposed()) {
            this.styledTextParent.layout(true);
        }
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public void setBufferedOutput(boolean bufferedOutput) {
        if (this.bufferedOutput != bufferedOutput) {
            this.bufferedOutput = bufferedOutput;
            IScriptConsoleCommunication consoleCommunication = this.debugConsole.getInterpreter().getConsoleCommunication();
            if (consoleCommunication instanceof PydevDebugConsoleCommunication) {
                PydevDebugConsoleCommunication pydevDebugConsoleCommunication = (PydevDebugConsoleCommunication)consoleCommunication;
                pydevDebugConsoleCommunication.setBufferedOutput(bufferedOutput);
            }
        }
    }

    private class CustomPageBookLayout
    extends Layout {
        public final Layout originalParentLayout;

        public CustomPageBookLayout(Layout originalParentLayout) {
            if (originalParentLayout instanceof CustomPageBookLayout) {
                CustomPageBookLayout customPageBookLayout = (CustomPageBookLayout)originalParentLayout;
                this.originalParentLayout = customPageBookLayout.originalParentLayout;
            } else {
                this.originalParentLayout = originalParentLayout;
            }
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = null;
            result = PromptOverlay.this.styledText != null ? PromptOverlay.this.styledText.computeSize(wHint, hHint, flushCache) : new Point(0, 0);
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (PromptOverlay.this.styledText != null && !PromptOverlay.this.styledText.isDisposed()) {
                Rectangle bounds = composite.getClientArea();
                int height = bounds.height;
                int perc = (int)((double)height * PromptOverlay.this.percSize);
                PromptOverlay.this.interactiveConsoleTextWidget.setBounds(bounds.x, bounds.y + height - perc, bounds.width, perc);
                PromptOverlay.this.styledText.setBounds(bounds.x, bounds.y, bounds.width, height - perc);
            }
        }
    }
}

