/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.codecoverage.CoverageCache;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.UniversalRunner;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.io.ThreadStreamReader;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.utils.PyFileListing;

public class PyCoverage {
    public CoverageCache cache = new CoverageCache();
    private static PyCoverage pyCoverage;

    /*
     * Unable to fully structure code
     */
    public void refreshCoverageInfo(IContainer container, IProgressMonitor monitor) {
        this.cache.clear();
        if (container == null) {
            return;
        }
        try {
            if (!container.exists()) {
                throw new RuntimeException("The directory passed: " + container + " no longer exists.");
            }
            file = container.getLocation().toFile();
            pyFilesBelow = new PyFileListing();
            if (file.exists()) {
                pyFilesBelow = PyFileListing.getPyFilesBelow((File)file, (IProgressMonitor)monitor, (boolean)true, (boolean)false);
            }
            if (pyFilesBelow.getFoundPyFileInfos().size() == 0) {
                return;
            }
            added = false;
            for (File f : pyFilesBelow.getFoundFolders()) {
                if (!added) {
                    this.cache.addFolder(f);
                    added = true;
                    continue;
                }
                this.cache.addFolder(f, f.getParentFile());
            }
            nature = PythonNature.getPythonNature((IResource)container);
            if (nature == null) {
                throw new RuntimeException("The directory passed: " + container + " does not have an associated nature.");
            }
            runner = UniversalRunner.getRunner((IPythonNature)nature);
            output = runner.runScriptAndGetOutput(PythonRunnerConfig.getCoverageScript(), new String[]{"combine"}, PyCoverage.getCoverageDirLocation(), monitor);
            if (output.o1 != null && ((String)output.o1).length() > 0) {
                Log.logInfo((String)((String)output.o1));
            }
            if (output.o2 != null && ((String)output.o2).length() > 0) {
                if (((String)output.o2).startsWith("Coverage.py warning:")) {
                    Log.logInfo((String)((String)output.o2));
                } else {
                    Log.log((String)((String)output.o2));
                }
            }
            monitor.setTaskName("Starting shell to get info...");
            monitor.worked(1);
            p = null;
            try {
                tup = runner.createProcess(PythonRunnerConfig.getCoverageScript(), new String[]{"--pydev-analyze"}, PyCoverage.getCoverageDirLocation(), monitor);
                p = (Process)tup.o1;
                try {
                    p.exitValue();
                    throw new RuntimeException("Some error happened... the process could not be created.");
                }
                catch (Exception v0) {
                    files = "";
                    iter = pyFilesBelow.getFoundPyFileInfos().iterator();
                    ** while (iter.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    fStr = ((PyFileListing.PyFileInfo)iter.next()).getFile().toString();
                    files = String.valueOf(files) + fStr + "|";
                    continue;
                }
lbl53:
                // 1 sources

                files = String.valueOf(files) + "\r";
                monitor.setTaskName("Writing to shell...");
                inputStream = new ThreadStreamReader(p.getInputStream(), false);
                inputStream.start();
                errorStream = new ThreadStreamReader(p.getErrorStream(), false);
                errorStream.start();
                monitor.worked(1);
                outputStream = p.getOutputStream();
                outputStream.write(files.getBytes());
                outputStream.close();
                monitor.setTaskName("Waiting for process to finish...");
                monitor.worked(1);
                while (true) {
                    try {
                        p.exitValue();
                    }
                    catch (IllegalThreadStateException v1) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException v2) {}
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        try {
                            p.destroy();
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                    break;
                }
                stdOut = inputStream.getAndClearContents();
                stdErr = errorStream.getAndClearContents().trim();
                if (stdErr.length() > 0) {
                    Log.log((String)stdErr);
                }
                monitor.setTaskName("Getting coverage info...(please wait, this could take a while)");
                monitor.worked(1);
                tempBuf = new FastStringBuffer();
                for (String str : StringUtils.splitInLines((String)stdOut)) {
                    this.analyzeReadLine(monitor, str.trim(), tempBuf);
                }
                monitor.setTaskName("Finished");
            }
            catch (Exception e) {
                if (p != null) {
                    p.destroy();
                }
                Log.log((Throwable)e);
            }
        }
        catch (Exception e1) {
            Log.log((Throwable)e1);
            throw new RuntimeException(e1);
        }
    }

    private void analyzeReadLine(IProgressMonitor monitor, String str, FastStringBuffer tempBuf) {
        boolean added = false;
        List strings = StringUtils.split((String)str, (char)' ', (int)5);
        String[] dottedValidSourceFiles = FileTypesPreferencesPage.getDottedValidSourceFiles();
        File f = null;
        int nTokens = strings.size();
        if (nTokens == 5 || nTokens == 4) {
            try {
                if (!((String)strings.get(1)).equalsIgnoreCase("stmts") && !((String)strings.get(0)).equalsIgnoreCase("total")) {
                    String ext;
                    String fileStr = (String)strings.get(0);
                    boolean found = false;
                    String[] stringArray = dottedValidSourceFiles;
                    int n = dottedValidSourceFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ext = stringArray[n2];
                        if (fileStr.endsWith(ext)) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        tempBuf.clear().append(fileStr);
                        stringArray = dottedValidSourceFiles;
                        n = dottedValidSourceFiles.length;
                        n2 = 0;
                        while (n2 < n) {
                            ext = stringArray[n2];
                            f = new File(tempBuf.append(ext).toString());
                            if (f.exists()) {
                                found = true;
                                break;
                            }
                            tempBuf.deleteLastChars(ext.length());
                            ++n2;
                        }
                    }
                    if (!found) {
                        return;
                    }
                    int stmts = Integer.parseInt((String)strings.get(1));
                    int miss = Integer.parseInt((String)strings.get(2));
                    if (nTokens == 4) {
                        this.cache.addFile(f, f.getParentFile(), stmts, miss, "");
                        added = true;
                    } else {
                        String missing = (String)strings.get(4);
                        this.cache.addFile(f, f.getParentFile(), stmts, miss, missing);
                        added = true;
                    }
                    String[] strs = f.toString().replaceAll("/", " ").replaceAll("\\\\", " ").split(" ");
                    if (strs.length > 1) {
                        monitor.setTaskName("Getting coverage info..." + strs[strs.length - 1]);
                    } else {
                        monitor.setTaskName("Getting coverage info..." + f.toString());
                    }
                    monitor.worked(1);
                }
            }
            catch (RuntimeException runtimeException) {
                Log.log((int)1, (String)("Code-coverage: ignored line: " + str), null);
            }
        }
        if (!added && f != null) {
            try {
                if (f.exists() && f.isFile() && !f.getName().startsWith(".coverage")) {
                    this.cache.addFile(f, f.getParentFile(), this.getError(strings));
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    private String getError(List<String> strings) {
        StringBuffer ret = new StringBuffer();
        int len = strings.size();
        int i = 1;
        while (i < len) {
            ret.append(strings.get(i)).append(' ');
            ++i;
        }
        return ret.toString();
    }

    public void clearInfo() {
        this.cache.clear();
        File dir = PyCoverage.getCoverageDirLocation();
        try {
            FileUtils.clearTempFilesAt((File)dir, (String)".coverage.");
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            new File(dir, ".coverage").delete();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static PyCoverage getPyCoverage() {
        if (pyCoverage == null) {
            pyCoverage = new PyCoverage();
        }
        return pyCoverage;
    }

    public static File getCoverageDirLocation() {
        IPath stateLocation = PydevDebugPlugin.getDefault().getStateLocation();
        stateLocation = stateLocation.append("coverage");
        String loc = FileUtils.getFileAbsolutePath((File)stateLocation.toFile());
        File dir = new File(loc);
        try {
            dir.mkdirs();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        if (!dir.exists()) {
            throw new RuntimeException("The directory: " + loc + " could not be created.");
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("Expected the path: " + loc + " to be a directory.");
        }
        return dir;
    }

    public static File getCoverageFileLocation() {
        return FileUtils.getTempFileAt((File)PyCoverage.getCoverageDirLocation(), (String)".coverage.");
    }
}

