/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.utils;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;

public class DirectoryTraverser
implements Iterable<String> {
    private Pattern filter;
    private File baseDirectory;

    public DirectoryTraverser(File baseDirectory, Pattern filter) {
        this.filter = filter;
        this.baseDirectory = baseDirectory;
        File directory = baseDirectory;
        if (!directory.exists()) {
            throw new RuntimeException("Given directory doesn't exist");
        }
        if (!directory.isDirectory()) {
            throw new RuntimeException("Specified path is not a directory");
        }
    }

    public List<String> getAllFiles() {
        LinkedListWarningOnSlowOperations files = new LinkedListWarningOnSlowOperations();
        this.traverse("", (List<String>)files);
        return files;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getAllFiles().iterator();
    }

    private void traverse(String relDir, List<String> files) {
        File currentDir = new File(this.baseDirectory, relDir);
        String[] list = currentDir.list();
        if (list != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String entryName = stringArray[n2];
                File absEntry = new File(currentDir, entryName);
                String relPath = relDir.length() != 0 ? String.valueOf(relDir) + entryName : entryName;
                if (absEntry.isDirectory()) {
                    this.traverse(String.valueOf(relPath) + File.separator, files);
                } else {
                    Matcher matcher = this.filter.matcher(absEntry.getAbsolutePath());
                    if (matcher.matches()) {
                        files.add(relPath);
                    }
                }
                ++n2;
            }
        }
    }
}

