/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generateproperties.request;

import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.NodeHelper;
import org.python.pydev.plugin.preferences.PyCodeStylePreferencesPage;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.INodeAdapter;
import org.python.pydev.refactoring.ast.adapters.PropertyTextAdapter;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.SelectionState;
import org.python.pydev.refactoring.core.request.IRefactoringRequest;
import org.python.pydev.shared_core.string.StringUtils;

public class GeneratePropertiesRequest
implements IRefactoringRequest {
    public final INodeAdapter attributeAdapter;
    public final int offsetMethodStrategy;
    public final int offsetPropertyStrategy;
    public final int accessModifier;
    private IClassDefAdapter classAdapter;
    private SelectionState state = new SelectionState();
    private NodeHelper nodeHelper;
    private final AdapterPrefs adapterPrefs;

    public GeneratePropertiesRequest(IClassDefAdapter classAdapter, INodeAdapter attributeAdapter, List<PropertyTextAdapter> properties, int offsetMethodStrategy, int offsetPropertyStrategy, int accessModifier, AdapterPrefs adapterPrefs) {
        this.classAdapter = classAdapter;
        this.attributeAdapter = attributeAdapter;
        this.offsetMethodStrategy = offsetMethodStrategy;
        this.offsetPropertyStrategy = offsetPropertyStrategy;
        this.accessModifier = accessModifier;
        this.adapterPrefs = adapterPrefs;
        this.nodeHelper = new NodeHelper(adapterPrefs);
        this.initialize(properties);
    }

    private void initialize(List<PropertyTextAdapter> properties) {
        for (PropertyTextAdapter propertyAdapter : properties) {
            switch (propertyAdapter.getType()) {
                case 0: {
                    this.state.addSelection(1);
                    break;
                }
                case 1: {
                    this.state.addSelection(2);
                    break;
                }
                case 2: {
                    this.state.addSelection(4);
                    break;
                }
                case 3: {
                    this.state.addSelection(8);
                    break;
                }
            }
        }
    }

    @Override
    public AdapterPrefs getAdapterPrefs() {
        return this.adapterPrefs;
    }

    public SelectionState getSelectionState() {
        return this.state;
    }

    @Override
    public IASTNodeAdapter<? extends SimpleNode> getOffsetNode() {
        return this.classAdapter;
    }

    public String getAttributeName() {
        return this.nodeHelper.getPublicAttr(this.attributeAdapter.getName());
    }

    public String getPropertyName() {
        return this.nodeHelper.getAccessName(this.getAttributeName(), this.accessModifier);
    }

    public static String getAccessorName(String accessType, String attributeName) {
        accessType = String.valueOf(accessType) + "_" + attributeName;
        int useMethodsCamelCase = PyCodeStylePreferencesPage.useMethodsCamelCase();
        if (useMethodsCamelCase == 0) {
            return StringUtils.asStyleCamelCaseFirstLower((String)accessType);
        }
        if (useMethodsCamelCase == 1) {
            return StringUtils.asStyleCamelCaseFirstUpper((String)accessType);
        }
        return StringUtils.asStyleLowercaseUnderscores((String)accessType);
    }
}

