/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.itertools;
import org.python.modules.itertools.permutations$PyExposer;

@ExposedType(name="itertools.permutations", base=PyObject.class)
public class permutations
extends PyObject {
    public static final PyType TYPE;
    private PyIterator iter;
    public static PyString __doc__;

    public permutations() {
    }

    public permutations(PyType subType) {
        super(subType);
    }

    public permutations(PyObject iterable, int r) {
        this.permutations___init__(iterable, r);
    }

    @ExposedNew
    final void permutations___init__(PyObject[] args, String[] kwds) {
        int perm_length;
        if (args.length > 2) {
            throw Py.TypeError("permutations() takes at most 2 arguments (3 given)");
        }
        ArgParser ap = new ArgParser("permutations", args, kwds, "iterable", "r");
        PyObject iterable = ap.getPyObject(0);
        PyObject r = ap.getPyObject(1, Py.None);
        if (r == Py.None) {
            perm_length = iterable.__len__();
        } else {
            perm_length = r.asInt();
            if (perm_length < 0) {
                throw Py.ValueError("r must be non-negative");
            }
        }
        this.permutations___init__(iterable, perm_length);
    }

    private void permutations___init__(PyObject iterable, int r) {
        PyTuple pool = PyTuple.fromIterable(iterable);
        int n = pool.__len__();
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        int[] cycles = new int[r];
        for (int i = 0; i < r; ++i) {
            cycles[i] = n - i;
        }
        this.iter = new itertools.ItertoolsIterator(this, r, n, pool, indices, cycles){
            private boolean firstthru = true;
            private /* synthetic */ int val$r;
            private /* synthetic */ int val$n;
            private /* synthetic */ PyTuple val$pool;
            private /* synthetic */ int[] val$indices;
            private /* synthetic */ int[] val$cycles;
            private /* synthetic */ permutations this$0;
            {
                this.val$r = n;
                this.val$n = n2;
                this.val$pool = pyTuple;
                this.val$indices = nArray;
                this.val$cycles = nArray2;
            }

            @Override
            public PyObject __iternext__() {
                if (this.val$r > this.val$n) {
                    return null;
                }
                if (this.firstthru) {
                    this.firstthru = false;
                    return itertools.makeIndexedTuple(this.val$pool, this.val$indices, this.val$r);
                }
                for (int i = this.val$r - 1; i >= 0; --i) {
                    int first;
                    int n = i;
                    this.val$cycles[n] = this.val$cycles[n] - 1;
                    if (this.val$cycles[i] == 0) {
                        first = this.val$indices[i];
                        for (int j = i; j < this.val$n - 1; ++j) {
                            this.val$indices[j] = this.val$indices[j + 1];
                        }
                    } else {
                        int j = this.val$cycles[i];
                        int index = this.val$indices[i];
                        this.val$indices[i] = this.val$indices[this.val$n - j];
                        this.val$indices[this.val$n - j] = index;
                        return itertools.makeIndexedTuple(this.val$pool, this.val$indices, this.val$r);
                    }
                    this.val$indices[this.val$n - 1] = first;
                    this.val$cycles[i] = this.val$n - i;
                }
                return null;
            }
        };
    }

    @Override
    public PyObject __iter__() {
        return this.iter;
    }

    public PyObject next() {
        return this.iter.next();
    }

    static {
        PyType.addBuilder(permutations.class, new permutations$PyExposer());
        TYPE = PyType.fromClass(permutations.class);
        __doc__ = new PyString("permutations(iterable[, r]) --> permutations object\n\nReturn successive r-length permutations of elements in the iterable.\n\npermutations(range(3), 2) --> (0,1), (0,2), (1,0), (1,2), (2,0), (2,1)");
    }
}

