/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public final class NWhile
extends NNode {
    private NNode test;
    private NBlock body;
    private NBlock orelse;

    public NWhile(NNode test, NBlock body, NBlock orelse) {
        this(null, null, null, 0, 1);
    }

    public NWhile(NNode test, NBlock body, NBlock orelse, int start, int end) {
        super(start, end);
        this.test = test;
        this.body = body;
        this.orelse = orelse;
        this.addChildren(test, body, orelse);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NWhile.resolveExpr(this.test, s);
        if (this.body != null) {
            this.setType(NWhile.resolveExpr(this.body, s));
        }
        if (this.orelse != null) {
            this.addType(NWhile.resolveExpr(this.orelse, s));
        }
        return this.getType();
    }

    public final String toString() {
        return "<While:" + this.test + ":" + this.body + ":" + this.orelse + ":" + this.start() + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NWhile.visitNode(this.test, v);
            NWhile.visitNode(this.body, v);
            NWhile.visitNode(this.orelse, v);
        }
    }
}

