/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NType;

public final class NSlice
extends NNode {
    private NNode lower;
    private NNode step;
    private NNode upper;

    public NSlice(NNode lower, NNode step, NNode upper) {
        this(null, null, null, 0, 1);
    }

    public NSlice(NNode lower, NNode step, NNode upper, int start, int end) {
        super(start, end);
        this.lower = lower;
        this.step = step;
        this.upper = upper;
        this.addChildren(lower, step, upper);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NSlice.resolveExpr(this.lower, s);
        NSlice.resolveExpr(this.step, s);
        NSlice.resolveExpr(this.upper, s);
        return this.setType(new NListType());
    }

    public final String toString() {
        return "<Slice:" + this.lower + ":" + this.step + ":" + this.upper + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NSlice.visitNode(this.lower, v);
            NSlice.visitNode(this.step, v);
            NSlice.visitNode(this.upper, v);
        }
    }
}

