/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import org.python.google.common.base.CharMatcher;

public class Joiner {
    private final String separator;

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }

    private Joiner(String separator) {
        this.separator = CharMatcher.LookupTable.checkNotNull(separator);
    }

    private Joiner(Joiner prototype) {
        this.separator = prototype.separator;
    }

    public final StringBuilder appendTo(StringBuilder builder, Iterable<?> parts) {
        return this.appendTo(builder, parts.iterator());
    }

    public final StringBuilder appendTo(StringBuilder builder, Iterator<?> parts) {
        try {
            Iterator<?> iterator = parts;
            StringBuilder stringBuilder = builder;
            Joiner joiner = this;
            CharMatcher.LookupTable.checkNotNull(stringBuilder);
            if (iterator.hasNext()) {
                stringBuilder.append(joiner.toString(iterator.next()));
                while (iterator.hasNext()) {
                    stringBuilder.append((CharSequence)joiner.separator);
                    stringBuilder.append(joiner.toString(iterator.next()));
                }
            }
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return builder;
    }

    @CheckReturnValue
    public Joiner useForNull(String nullText) {
        CharMatcher.LookupTable.checkNotNull(nullText);
        return new Joiner(this, this, nullText){
            private /* synthetic */ String val$nullText;
            private /* synthetic */ Joiner this$0;
            {
                this.this$0 = joiner;
                this.val$nullText = string;
                super(x0, (byte)0);
            }

            @Override
            final CharSequence toString(Object part) {
                if (part == null) {
                    return this.val$nullText;
                }
                return this.this$0.toString(part);
            }

            @Override
            public final Joiner useForNull(String nullText) {
                CharMatcher.LookupTable.checkNotNull(nullText);
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }

    @CheckReturnValue
    public final MapJoiner withKeyValueSeparator(String keyValueSeparator) {
        return new MapJoiner(this, keyValueSeparator, 0);
    }

    CharSequence toString(Object part) {
        CharMatcher.LookupTable.checkNotNull(part);
        if (part instanceof CharSequence) {
            return (CharSequence)part;
        }
        return part.toString();
    }

    /* synthetic */ Joiner(Joiner x0, byte by) {
        this(x0);
    }

    public static final class MapJoiner {
        private final Joiner joiner;
        private final String keyValueSeparator;

        private MapJoiner(Joiner joiner, String keyValueSeparator) {
            this.joiner = joiner;
            this.keyValueSeparator = CharMatcher.LookupTable.checkNotNull(keyValueSeparator);
        }

        public final StringBuilder appendTo(StringBuilder builder, Iterator<? extends Map.Entry<?, ?>> entries) {
            try {
                Iterator<Map.Entry<?, ?>> iterator = entries;
                StringBuilder stringBuilder = builder;
                MapJoiner mapJoiner = this;
                CharMatcher.LookupTable.checkNotNull(stringBuilder);
                if (iterator.hasNext()) {
                    Map.Entry<?, ?> entry = iterator.next();
                    stringBuilder.append(mapJoiner.joiner.toString(entry.getKey()));
                    stringBuilder.append((CharSequence)mapJoiner.keyValueSeparator);
                    stringBuilder.append(mapJoiner.joiner.toString(entry.getValue()));
                    while (iterator.hasNext()) {
                        stringBuilder.append((CharSequence)mapJoiner.joiner.separator);
                        Map.Entry<?, ?> entry2 = iterator.next();
                        stringBuilder.append(mapJoiner.joiner.toString(entry2.getKey()));
                        stringBuilder.append((CharSequence)mapJoiner.keyValueSeparator);
                        stringBuilder.append(mapJoiner.joiner.toString(entry2.getValue()));
                    }
                }
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
            return builder;
        }

        /* synthetic */ MapJoiner(Joiner x0, String x1, byte by) {
            this(x0, x1);
        }
    }
}

