/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import jnr.ffi.NativeType;
import jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.FastIntMethodGenerator;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SigType;

public class FastLongMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final boolean ENABLED = FastLongMethodGenerator.getBooleanProperty("jnr.ffi.fast-long.enabled", true);
    private static final int MAX_PARAMETERS = FastLongMethodGenerator.getMaximumFastLongParameters();
    private static final String[] signatures;
    private static final String[] methodNames;

    public FastLongMethodGenerator(BufferMethodGenerator bufgen) {
        super(bufgen);
    }

    final String getInvokerMethodName$5974725e(ParameterType[] parameterTypes) {
        int parameterCount = parameterTypes.length;
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    final String getInvokerSignature$15ec99b1(int parameterCount) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    final Class getInvokerType() {
        return Long.TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(ResultType resultType, ParameterType[] parameterTypes, CallingConvention callingConvention) {
        Platform platform;
        int parameterCount = parameterTypes.length;
        if (!ENABLED) {
            return false;
        }
        if (callingConvention != CallingConvention.DEFAULT) return false;
        if (parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform2 = Platform.getPlatform();
        if (Platform.getCPU() != Platform.CPU.X86_64) {
            return false;
        }
        if (platform2.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        ParameterType[] arr$ = parameterTypes;
        int len$ = parameterTypes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            platform = platform2;
            ParameterType parameterType = arr$[i$];
            ParameterType parameterType2 = parameterType;
            if (!FastLongMethodGenerator.isFastLongType(platform, parameterType2)) {
                if (!AsmUtil.isDelegate(parameterType2)) return false;
                ParameterType parameterType3 = parameterType2;
                if (NumberUtil.sizeof(parameterType3.nativeType) != 8) return false;
            }
            boolean bl = true;
            if (bl) continue;
            return false;
        }
        platform = platform2;
        ResultType resultType2 = resultType;
        if (FastLongMethodGenerator.isFastLongType(platform, resultType2)) return true;
        if (resultType2.nativeType == NativeType.VOID) return true;
        if (resultType2.nativeType != NativeType.ADDRESS) return false;
        ResultType resultType3 = resultType2;
        if (NumberUtil.sizeof(resultType3.nativeType) != 8) return false;
        return true;
    }

    private static int getMaximumFastLongParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeL6", CallContext.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private static boolean isFastLongType(Platform platform, SigType type) {
        return FastIntMethodGenerator.isFastIntType$4d9a0a37(type) || type.nativeType == NativeType.SLONG || type.nativeType == NativeType.ULONG || type.nativeType == NativeType.SLONGLONG || type.nativeType == NativeType.ULONGLONG;
    }

    private static boolean isFastLongResult(Platform platform, ResultType resultType) {
        block3: {
            block2: {
                if (FastLongMethodGenerator.isFastLongType(platform, resultType) || resultType.nativeType == NativeType.VOID) break block2;
                if (resultType.nativeType != NativeType.ADDRESS) break block3;
                ResultType resultType2 = resultType;
                if (NumberUtil.sizeof(resultType2.nativeType) != 8) break block3;
            }
            return true;
        }
        return false;
    }

    private static boolean isFastLongParameter(Platform platform, ParameterType type) {
        block3: {
            block2: {
                if (FastLongMethodGenerator.isFastLongType(platform, type)) break block2;
                if (!AsmUtil.isDelegate(type)) break block3;
                ParameterType parameterType = type;
                if (NumberUtil.sizeof(parameterType.nativeType) != 8) break block3;
            }
            return true;
        }
        return false;
    }

    static {
        methodNames = new String[]{"invokeL0", "invokeL1", "invokeL2", "invokeL3", "invokeL4", "invokeL5", "invokeL6"};
        signatures = new String[MAX_PARAMETERS + 1];
        for (int i = 0; i <= MAX_PARAMETERS; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(CallContext.class)).append(CodegenUtils.ci(Long.TYPE));
            for (int n = 0; n < i; ++n) {
                sb.append('J');
            }
            FastLongMethodGenerator.signatures[i] = sb.append(")J").toString();
        }
    }
}

