/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import jnr.ffi.NativeType;
import jnr.ffi.Runtime;
import jnr.ffi.Type;
import jnr.ffi.TypeAlias;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.util.EnumMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Struct {
    static final Charset ASCII = Charset.forName("ASCII");
    static final Charset UTF8 = Charset.forName("UTF-8");
    final Info __info;

    protected Struct(Runtime runtime) {
        this.__info = new Info(runtime);
    }

    Struct(Runtime runtime, boolean isUnion) {
        this(runtime);
        this.__info.resetIndex = true;
    }

    public final Runtime getRuntime() {
        return this.__info.runtime;
    }

    public final void useMemory(jnr.ffi.Pointer address) {
        this.__info.useMemory(address);
    }

    public static jnr.ffi.Pointer getMemory(Struct struct2) {
        return struct2.__info.getMemory(0);
    }

    public static jnr.ffi.Pointer getMemory(Struct struct2, int flags) {
        return struct2.__info.getMemory(flags);
    }

    public static int size(Struct struct2) {
        Info info = struct2.__info;
        return info.size;
    }

    public static int alignment(Struct struct2) {
        Info info = struct2.__info;
        return info.minAlign;
    }

    public static boolean isDirect(Struct struct2) {
        return struct2.__info.isDirect();
    }

    private static int align(int offset, int align) {
        return offset + align - 1 & ~(align - 1);
    }

    public static <T extends Struct> T[] arrayOf(Runtime runtime, Class<T> type, int length) {
        try {
            Struct[] array = (Struct[])Array.newInstance(type, length);
            Constructor<T> c = type.getConstructor(Runtime.class);
            for (int i = 0; i < length; ++i) {
                array[i] = (Struct)c.newInstance(runtime);
            }
            if (array.length > 0) {
                int structSize = Struct.align(Struct.size(array[0]), Struct.alignment(array[0]));
                jnr.ffi.Pointer memory = runtime.getMemoryManager().allocateDirect(structSize * length);
                for (int i = 0; i < array.length; ++i) {
                    array[i].useMemory(memory.slice(structSize * i, structSize));
                }
            }
            return array;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException ex = runtimeException;
            throw runtimeException;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public java.lang.String toString() {
        StringBuilder sb = new StringBuilder();
        Field[] fields = this.getClass().getDeclaredFields();
        sb.append(this.getClass().getSimpleName()).append(" { \n");
        Field[] arr$ = fields;
        int len$ = fields.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field field = arr$[i$];
            try {
                sb.append("    ");
                sb.append(field.getName()).append(" = ");
                sb.append(field.get(this).toString());
                sb.append("\n");
                continue;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    protected final void arrayBegin() {
        this.__info.resetIndex = false;
    }

    protected final void arrayEnd() {
        this.__info.resetIndex = false;
    }

    protected <T extends Member> T[] array(T[] array) {
        this.arrayBegin();
        try {
            Class<?> arrayClass = array.getClass().getComponentType();
            Constructor<?> ctor = arrayClass.getDeclaredConstructor(arrayClass.getEnclosingClass());
            Object[] parameters = new Object[]{this};
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Member)ctor.newInstance(parameters);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed8[] array(Signed8[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed8(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned8[] array(Unsigned8[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned8(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed16[] array(Signed16[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed16(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned16[] array(Unsigned16[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned16(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed32[] array(Signed32[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed32(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned32[] array(Unsigned32[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned32(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed64[] array(Signed64[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed64(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned64[] array(Unsigned64[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned64(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final SignedLong[] array(SignedLong[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new SignedLong(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final UnsignedLong[] array(UnsignedLong[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new UnsignedLong(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Float[] array(Float[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Float(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Double[] array(Double[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Double(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Address[] array(Address[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Address(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final Pointer[] array(Pointer[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Pointer(this);
        }
        this.arrayEnd();
        return array;
    }

    protected final <T extends Struct> T inner(Struct struct2) {
        Info info = struct2.__info;
        int off = Struct.align(this.__info.size, info.minAlign);
        struct2.__info.enclosing = this;
        struct2.__info.offset = off;
        this.__info.size = off + struct2.__info.size;
        return (T)struct2;
    }

    public final class rlim_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public rlim_t(Struct struct2) {
            super(struct2, TypeAlias.rlim_t);
        }

        public rlim_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.rlim_t, offset);
        }
    }

    public final class socklen_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public socklen_t(Struct struct2) {
            super(struct2, TypeAlias.socklen_t);
        }

        public socklen_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.socklen_t, offset);
        }
    }

    public final class sa_family_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public sa_family_t(Struct struct2) {
            super(struct2, TypeAlias.sa_family_t);
        }

        public sa_family_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.sa_family_t, offset);
        }
    }

    public final class fsfilcnt_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public fsfilcnt_t(Struct struct2) {
            super(struct2, TypeAlias.fsfilcnt_t);
        }

        public fsfilcnt_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.fsfilcnt_t, offset);
        }
    }

    public final class fsblkcnt_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public fsblkcnt_t(Struct struct2) {
            super(struct2, TypeAlias.fsblkcnt_t);
        }

        public fsblkcnt_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.fsblkcnt_t, offset);
        }
    }

    public final class time_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public time_t(Struct struct2) {
            super(struct2, TypeAlias.time_t);
        }

        public time_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.time_t, offset);
        }
    }

    public final class ssize_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public ssize_t(Struct struct2) {
            super(struct2, TypeAlias.ssize_t);
        }

        public ssize_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.ssize_t, offset);
        }
    }

    public final class size_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public size_t(Struct struct2) {
            super(struct2, TypeAlias.size_t);
        }

        public size_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.size_t, offset);
        }
    }

    public final class clock_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public clock_t(Struct struct2) {
            super(struct2, TypeAlias.clock_t);
        }

        public clock_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.clock_t, offset);
        }
    }

    public final class uid_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public uid_t(Struct struct2) {
            super(struct2, TypeAlias.uid_t);
        }

        public uid_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.uid_t, offset);
        }
    }

    public final class swblk_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public swblk_t(Struct struct2) {
            super(struct2, TypeAlias.swblk_t);
        }

        public swblk_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.swblk_t, offset);
        }
    }

    public final class off_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public off_t(Struct struct2) {
            super(struct2, TypeAlias.off_t);
        }

        public off_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.off_t, offset);
        }
    }

    public final class pid_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public pid_t(Struct struct2) {
            super(struct2, TypeAlias.pid_t);
        }

        public pid_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.pid_t, offset);
        }
    }

    public final class id_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public id_t(Struct struct2) {
            super(struct2, TypeAlias.id_t);
        }

        public id_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.id_t, offset);
        }
    }

    public final class nlink_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public nlink_t(Struct struct2) {
            super(struct2, TypeAlias.nlink_t);
        }

        public nlink_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.nlink_t, offset);
        }
    }

    public final class mode_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public mode_t(Struct struct2) {
            super(struct2, TypeAlias.mode_t);
        }

        public mode_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.mode_t, offset);
        }
    }

    public final class key_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public key_t(Struct struct2) {
            super(struct2, TypeAlias.key_t);
        }

        public key_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.key_t, offset);
        }
    }

    public final class ino64_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public ino64_t(Struct struct2) {
            super(struct2, TypeAlias.ino64_t);
        }

        public ino64_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.ino64_t, offset);
        }
    }

    public final class ino_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public ino_t(Struct struct2) {
            super(struct2, TypeAlias.ino_t);
        }

        public ino_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.ino_t, offset);
        }
    }

    public final class in_port_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public in_port_t(Struct struct2) {
            super(struct2, TypeAlias.in_port_t);
        }

        public in_port_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.in_port_t, offset);
        }
    }

    public final class in_addr_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public in_addr_t(Struct struct2) {
            super(struct2, TypeAlias.in_addr_t);
        }

        public in_addr_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.in_addr_t, offset);
        }
    }

    public final class gid_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public gid_t(Struct struct2) {
            super(struct2, TypeAlias.gid_t);
        }

        public gid_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.gid_t, offset);
        }
    }

    public final class blksize_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public blksize_t(Struct struct2) {
            super(struct2, TypeAlias.blksize_t);
        }

        public blksize_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.blksize_t, offset);
        }
    }

    public final class blkcnt_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public blkcnt_t(Struct struct2) {
            super(struct2, TypeAlias.blkcnt_t);
        }

        public blkcnt_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.blkcnt_t, offset);
        }
    }

    public final class dev_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public dev_t(Struct struct2) {
            super(struct2, TypeAlias.dev_t);
        }

        public dev_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.dev_t, offset);
        }
    }

    public final class caddr_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public caddr_t(Struct struct2) {
            super(struct2, TypeAlias.caddr_t);
        }

        public caddr_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.caddr_t, offset);
        }
    }

    public final class uintptr_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public uintptr_t(Struct struct2) {
            super(struct2, TypeAlias.uintptr_t);
        }

        public uintptr_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.uintptr_t, offset);
        }
    }

    public final class intptr_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public intptr_t(Struct struct2) {
            super(struct2, TypeAlias.intptr_t);
        }

        public intptr_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.intptr_t, offset);
        }
    }

    public final class u_int64_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public u_int64_t(Struct struct2) {
            super(struct2, TypeAlias.u_int64_t);
        }

        public u_int64_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.u_int64_t, offset);
        }
    }

    public final class int64_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public int64_t(Struct struct2) {
            super(struct2, TypeAlias.int64_t);
        }

        public int64_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.int64_t, offset);
        }
    }

    public final class u_int32_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public u_int32_t(Struct struct2) {
            super(struct2, TypeAlias.u_int32_t);
        }

        public u_int32_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.u_int32_t, offset);
        }
    }

    public final class int32_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public int32_t(Struct struct2) {
            super(struct2, TypeAlias.int32_t);
        }

        public int32_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.int32_t, offset);
        }
    }

    public final class u_int16_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public u_int16_t(Struct struct2) {
            super(struct2, TypeAlias.u_int16_t);
        }

        public u_int16_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.u_int16_t, offset);
        }
    }

    public final class int16_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public int16_t(Struct struct2) {
            super(struct2, TypeAlias.int16_t);
        }

        public int16_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.int16_t, offset);
        }
    }

    public final class u_int8_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public u_int8_t(Struct struct2) {
            super(struct2, TypeAlias.u_int8_t);
        }

        public u_int8_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.u_int8_t, offset);
        }
    }

    public final class int8_t
    extends IntegerAlias {
        private /* synthetic */ Struct this$0;

        public int8_t(Struct struct2) {
            super(struct2, TypeAlias.int8_t);
        }

        public int8_t(Struct struct2, Offset offset) {
            super(struct2, TypeAlias.int8_t, offset);
        }
    }

    public final class Padding
    extends AbstractMember {
        private /* synthetic */ Struct this$0;

        public Padding(Struct struct2, Type type, int length) {
            super(struct2, (type.size() << 3) * length, type.alignment() << 3);
        }

        public Padding(Struct struct2, NativeType type, int length) {
            super(struct2, (struct2.getRuntime().findType(type).size() << 3) * length, struct2.getRuntime().findType(type).alignment() << 3);
        }
    }

    public class AsciiStringRef
    extends UTFStringRef {
        private /* synthetic */ Struct this$0;

        public AsciiStringRef(Struct struct2, int size) {
            super(struct2, size, ASCII);
        }

        public AsciiStringRef(Struct struct2) {
            super(struct2, Integer.MAX_VALUE, ASCII);
        }
    }

    public class UTF8StringRef
    extends UTFStringRef {
        private /* synthetic */ Struct this$0;

        public UTF8StringRef(Struct struct2, int size) {
            super(struct2, size, UTF8);
        }

        public UTF8StringRef(Struct struct2) {
            super(struct2, Integer.MAX_VALUE, UTF8);
        }
    }

    public class UTFStringRef
    extends String {
        private jnr.ffi.Pointer valueHolder;
        private /* synthetic */ Struct this$0;

        public UTFStringRef(Struct struct2, int length, Charset cs) {
            this.this$0 = struct2;
            super(struct2, struct2.getRuntime().findType(NativeType.ADDRESS).size() << 3, struct2.getRuntime().findType(NativeType.ADDRESS).alignment() << 3, length, cs);
        }

        public UTFStringRef(Struct struct2, Charset cs) {
            this(struct2, Integer.MAX_VALUE, cs);
        }

        protected jnr.ffi.Pointer getStringMemory() {
            return this.getMemory().getPointer(this.offset(), this.length());
        }

        public final java.lang.String get() {
            jnr.ffi.Pointer ptr = this.getStringMemory();
            if (ptr != null) {
                return ptr.getString(0L, this.length, this.charset);
            }
            return null;
        }

        public final void set(java.lang.String value) {
            if (value != null) {
                this.valueHolder = this.this$0.getRuntime().getMemoryManager().allocateDirect(this.length() << 2);
                this.valueHolder.putString(0L, value, this.length() << 2, this.charset);
                this.getMemory().putPointer(this.offset(), this.valueHolder);
                return;
            }
            this.valueHolder = null;
            this.getMemory().putAddress(this.offset(), 0L);
        }
    }

    public class AsciiString
    extends UTFString {
        private /* synthetic */ Struct this$0;

        public AsciiString(Struct struct2, int size) {
            super(struct2, size, ASCII);
        }
    }

    public class UTF8String
    extends UTFString {
        private /* synthetic */ Struct this$0;

        public UTF8String(Struct struct2, int size) {
            super(struct2, size, UTF8);
        }
    }

    public class UTFString
    extends String {
        private /* synthetic */ Struct this$0;

        public UTFString(Struct struct2, int length, Charset cs) {
            super(struct2, length << 3, 8, length, cs);
        }

        protected jnr.ffi.Pointer getStringMemory() {
            return this.getMemory().slice(this.offset(), this.length());
        }

        public final java.lang.String get() {
            return this.getStringMemory().getString(0L, this.length, this.charset);
        }

        public final void set(java.lang.String value) {
            this.getStringMemory().putString(0L, value, this.length, this.charset);
        }
    }

    public abstract class String
    extends AbstractMember {
        protected final Charset charset;
        protected final int length;
        private /* synthetic */ Struct this$0;

        protected String(Struct struct2, int size, int align, int length, Charset cs) {
            super(struct2, size, align);
            this.length = length;
            this.charset = cs;
        }

        protected String(Struct struct2, int size, int align, Offset offset, int length, Charset cs) {
            super(struct2, size, align, offset);
            this.length = length;
            this.charset = cs;
        }

        public final int length() {
            return this.length;
        }

        protected abstract jnr.ffi.Pointer getStringMemory();

        public abstract java.lang.String get();

        public abstract void set(java.lang.String var1);

        public final java.lang.String toString() {
            return this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum<T extends java.lang.Enum<T>>
    extends Enum32<T> {
        private /* synthetic */ Struct this$0;

        public Enum(Struct struct2, Class<T> enumClass) {
            super(struct2, enumClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumLong<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ Struct this$0;

        public EnumLong(Struct struct2, Class<E> enumClass) {
            super(struct2, NativeType.SLONG, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putNativeLong(this.offset(), EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putNativeLong(this.offset(), value.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemory().getNativeLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum64<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ Struct this$0;

        public Enum64(Struct struct2, Class<E> enumClass) {
            super(struct2, NativeType.SLONGLONG, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putLongLong(this.offset(), EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putLongLong(this.offset(), value.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemory().getLongLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum32<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ Struct this$0;

        public Enum32(Struct struct2, Class<E> enumClass) {
            super(struct2, NativeType.SINT, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putInt(this.offset(), EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putInt(this.offset(), value.intValue());
        }

        @Override
        public final int intValue() {
            return this.getMemory().getInt(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum16<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ Struct this$0;

        public Enum16(Struct struct2, Class<E> enumClass) {
            super(struct2, NativeType.SSHORT, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putShort(this.offset(), (short)EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putShort(this.offset(), value.shortValue());
        }

        @Override
        public final int intValue() {
            return this.getMemory().getShort(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum8<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        private /* synthetic */ Struct this$0;

        public Enum8(Struct struct2, Class<E> enumClass) {
            super(struct2, NativeType.SCHAR, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putByte(this.offset(), (byte)EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putByte(this.offset(), value.byteValue());
        }

        @Override
        public final int intValue() {
            return this.getMemory().getByte(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class EnumField<E>
    extends NumberField {
        protected final Class<E> enumClass;
        private /* synthetic */ Struct this$0;

        public EnumField(Struct struct2, NativeType type, Class<E> enumClass) {
            super(struct2, type);
            this.enumClass = enumClass;
        }

        public abstract E get();

        @Override
        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Pointer
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Pointer(Struct struct2) {
            this.this$0 = struct2;
            super(struct2, NativeType.ADDRESS);
        }

        public Pointer(Struct struct2, Offset offset) {
            this.this$0 = struct2;
            super(struct2, NativeType.ADDRESS, offset);
        }

        public final jnr.ffi.Pointer get() {
            return this.getMemory().getPointer(this.offset());
        }

        public final int size() {
            return this.this$0.getRuntime().findType(NativeType.ADDRESS).size() << 3;
        }

        public final void set(jnr.ffi.Pointer value) {
            this.getMemory().putPointer(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putAddress(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.getMemory().getAddress(this.offset());
        }

        public final long longValue() {
            return this.getMemory().getAddress(this.offset());
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Address
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Address(Struct struct2) {
            super(struct2, NativeType.ADDRESS);
        }

        public Address(Struct struct2, Offset offset) {
            super(struct2, NativeType.ADDRESS, offset);
        }

        public final jnr.ffi.Address get() {
            return jnr.ffi.Address.valueOf(this.getMemory().getAddress(this.offset()));
        }

        public final void set(jnr.ffi.Address value) {
            this.getMemory().putAddress(this.offset(), value != null ? value.nativeAddress() : 0L);
        }

        public void set(Number value) {
            this.getMemory().putAddress(this.offset(), value.longValue());
        }

        public final int intValue() {
            return this.get().intValue();
        }

        public final long longValue() {
            return this.get().longValue();
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public final class Double
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Double(Struct struct2) {
            super(struct2, NativeType.DOUBLE);
        }

        public Double(Struct struct2, Offset offset) {
            super(struct2, NativeType.DOUBLE, offset);
        }

        public final double get() {
            return this.getMemory().getDouble(this.offset());
        }

        public final void set(double value) {
            this.getMemory().putDouble(this.offset(), value);
        }

        public final void set(Number value) {
            this.getMemory().putDouble(this.offset(), value.doubleValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final float floatValue() {
            return (float)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    public class Float
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Float(Struct struct2) {
            super(struct2, NativeType.FLOAT);
        }

        public Float(Struct struct2, Offset offset) {
            super(struct2, NativeType.FLOAT, offset);
        }

        public final float get() {
            return this.getMemory().getFloat(this.offset());
        }

        public final void set(float value) {
            this.getMemory().putFloat(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putFloat(this.offset(), value.floatValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final float floatValue() {
            return this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    public class UnsignedLong
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public UnsignedLong(Struct struct2) {
            this.this$0 = struct2;
            super(struct2, NativeType.ULONG);
        }

        public UnsignedLong(Struct struct2, Offset offset) {
            this.this$0 = struct2;
            super(struct2, NativeType.ULONG, offset);
        }

        public final long get() {
            long mask;
            long value = this.getMemory().getNativeLong(this.offset());
            long l = mask = this.this$0.getRuntime().findType(NativeType.SLONG).size() == 32 ? 0xFFFFFFFFL : -1L;
            if (value < 0L) {
                return (value & mask) + mask + 1L;
            }
            return value;
        }

        public final void set(long value) {
            this.getMemory().putNativeLong(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putNativeLong(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class SignedLong
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public SignedLong(Struct struct2) {
            super(struct2, NativeType.SLONG);
        }

        public SignedLong(Struct struct2, Offset offset) {
            super(struct2, NativeType.SLONG, offset);
        }

        public final long get() {
            return this.getMemory().getNativeLong(this.offset());
        }

        public final void set(long value) {
            this.getMemory().putNativeLong(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putNativeLong(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned64
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Unsigned64(Struct struct2) {
            super(struct2, NativeType.ULONGLONG);
        }

        public Unsigned64(Struct struct2, Offset offset) {
            super(struct2, NativeType.ULONGLONG, offset);
        }

        public final long get() {
            return this.getMemory().getLongLong(this.offset());
        }

        public final void set(long value) {
            this.getMemory().putLongLong(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putLongLong(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Signed64
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Signed64(Struct struct2) {
            super(struct2, NativeType.SLONGLONG);
        }

        public Signed64(Struct struct2, Offset offset) {
            super(struct2, NativeType.SLONGLONG, offset);
        }

        public final long get() {
            return this.getMemory().getLongLong(this.offset());
        }

        public final void set(long value) {
            this.getMemory().putLongLong(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putLongLong(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned32
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Unsigned32(Struct struct2) {
            super(struct2, NativeType.UINT);
        }

        public Unsigned32(Struct struct2, Offset offset) {
            super(struct2, NativeType.UINT, offset);
        }

        public final long get() {
            long value = this.getMemory().getInt(this.offset());
            if (value < 0L) {
                return (value & Integer.MAX_VALUE) + 0x80000000L;
            }
            return value;
        }

        public final void set(long value) {
            this.getMemory().putInt(this.offset(), (int)value);
        }

        public void set(Number value) {
            this.getMemory().putInt(this.offset(), value.intValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }
    }

    public class Signed32
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Signed32(Struct struct2) {
            super(struct2, NativeType.SINT);
        }

        public Signed32(Struct struct2, Offset offset) {
            super(struct2, NativeType.SINT, offset);
        }

        public final int get() {
            return this.getMemory().getInt(this.offset());
        }

        public final void set(int value) {
            this.getMemory().putInt(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putInt(this.offset(), value.intValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned16
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Unsigned16(Struct struct2) {
            super(struct2, NativeType.USHORT);
        }

        public Unsigned16(Struct struct2, Offset offset) {
            super(struct2, NativeType.USHORT, offset);
        }

        public final int get() {
            short value = this.getMemory().getShort(this.offset());
            if (value < 0) {
                return (value & Short.MAX_VALUE) + 32768;
            }
            return value;
        }

        public final void set(int value) {
            this.getMemory().putShort(this.offset(), (short)value);
        }

        public void set(Number value) {
            this.getMemory().putShort(this.offset(), value.shortValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed16
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Signed16(Struct struct2) {
            super(struct2, NativeType.SSHORT);
        }

        public Signed16(Struct struct2, Offset offset) {
            super(struct2, NativeType.SSHORT, offset);
        }

        public final short get() {
            return this.getMemory().getShort(this.offset());
        }

        public final void set(short value) {
            this.getMemory().putShort(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putShort(this.offset(), value.shortValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned8
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Unsigned8(Struct struct2) {
            super(struct2, NativeType.UCHAR);
        }

        public Unsigned8(Struct struct2, Offset offset) {
            super(struct2, NativeType.UCHAR, offset);
        }

        public final short get() {
            short value = this.getMemory().getByte(this.offset());
            if (value < 0) {
                return (short)((value & 0x7F) + 128);
            }
            return value;
        }

        public final void set(short value) {
            this.getMemory().putByte(this.offset(), (byte)value);
        }

        public void set(Number value) {
            this.getMemory().putByte(this.offset(), value.byteValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed8
    extends NumberField {
        private /* synthetic */ Struct this$0;

        public Signed8(Struct struct2) {
            super(struct2, NativeType.SCHAR);
        }

        public Signed8(Struct struct2, Offset offset) {
            super(struct2, NativeType.SCHAR, offset);
        }

        public final byte get() {
            return this.getMemory().getByte(this.offset());
        }

        public final void set(byte value) {
            this.getMemory().putByte(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putByte(this.offset(), value.byteValue());
        }

        public final byte byteValue() {
            return this.get();
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public abstract class IntegerAlias
    extends NumberField {
        private /* synthetic */ Struct this$0;

        IntegerAlias(Struct struct2, TypeAlias type) {
            super(struct2, type);
        }

        IntegerAlias(Struct struct2, TypeAlias type, Offset offset) {
            super(struct2, type, offset);
        }

        public void set(Number value) {
            this.getMemory().putInt(this.type, this.offset(), value.longValue());
        }

        public void set(long value) {
            this.getMemory().putInt(this.type, this.offset(), value);
        }

        public final long get() {
            return this.getMemory().getInt(this.type, this.offset());
        }

        public int intValue() {
            return (int)this.get();
        }

        public long longValue() {
            return this.get();
        }
    }

    public abstract class NumberField
    extends Member {
        private final int offset;
        protected final Type type;
        private /* synthetic */ Struct this$0;

        protected NumberField(Struct struct2, NativeType type) {
            this.this$0 = struct2;
            super(struct2);
            Type t = this.type = struct2.getRuntime().findType(type);
            this.offset = struct2.__info.addField(t.size() << 3, t.alignment() << 3);
        }

        protected NumberField(Struct struct2, NativeType type, Offset offset) {
            this.this$0 = struct2;
            super(struct2);
            Type t = this.type = struct2.getRuntime().findType(type);
            this.offset = struct2.__info.addField(t.size() << 3, t.alignment() << 3, offset);
        }

        protected NumberField(Struct struct2, TypeAlias type) {
            this.this$0 = struct2;
            super(struct2);
            Type t = this.type = struct2.getRuntime().findType(type);
            this.offset = struct2.__info.addField(t.size() << 3, t.alignment() << 3);
        }

        protected NumberField(Struct struct2, TypeAlias type, Offset offset) {
            this.this$0 = struct2;
            super(struct2);
            Type t = this.type = struct2.getRuntime().findType(type);
            this.offset = struct2.__info.addField(t.size() << 3, t.alignment() << 3, offset);
        }

        public final jnr.ffi.Pointer getMemory() {
            return this.this$0.__info.getMemory();
        }

        public final Struct struct() {
            return this.this$0;
        }

        public final long offset() {
            return this.offset + this.this$0.__info.offset;
        }

        public abstract void set(Number var1);

        public double doubleValue() {
            return this.longValue();
        }

        public float floatValue() {
            return this.intValue();
        }

        public byte byteValue() {
            return (byte)this.intValue();
        }

        public short shortValue() {
            return (short)this.intValue();
        }

        public abstract int intValue();

        public long longValue() {
            return this.intValue();
        }

        public java.lang.String toString() {
            return Integer.toString(this.intValue(), 10);
        }
    }

    public final class WBOOL
    extends AbstractBoolean {
        private /* synthetic */ Struct this$0;

        public WBOOL(Struct struct2) {
            super(struct2, NativeType.SINT);
        }

        public final boolean get() {
            return (this.getMemory().getInt(this.offset()) & 1) != 0;
        }

        public final void set(boolean value) {
            this.getMemory().putInt(this.offset(), value ? 1 : 0);
        }
    }

    public final class Boolean
    extends AbstractBoolean {
        private /* synthetic */ Struct this$0;

        public Boolean(Struct struct2) {
            super(struct2, NativeType.SCHAR);
        }

        public final boolean get() {
            return (this.getMemory().getByte(this.offset()) & 1) != 0;
        }

        public final void set(boolean value) {
            this.getMemory().putByte(this.offset(), (byte)(value ? 1 : 0));
        }
    }

    public abstract class AbstractBoolean
    extends AbstractMember {
        private /* synthetic */ Struct this$0;

        protected AbstractBoolean(Struct struct2, NativeType type) {
            super(struct2, type);
        }

        protected AbstractBoolean(Struct struct2, NativeType type, Offset offset) {
            super(struct2, type, offset);
        }

        public abstract boolean get();

        public abstract void set(boolean var1);

        public java.lang.String toString() {
            return java.lang.Boolean.toString(this.get());
        }
    }

    public abstract class AbstractMember
    extends Member {
        private final int offset;
        private /* synthetic */ Struct this$0;

        protected AbstractMember(Struct struct2, int size) {
            this(struct2, size, size);
        }

        protected AbstractMember(Struct struct2, int size, int align, Offset offset) {
            this.this$0 = struct2;
            super(struct2);
            this.offset = struct2.__info.addField(size, align, offset);
        }

        protected AbstractMember(Struct struct2, int size, int align) {
            this.this$0 = struct2;
            super(struct2);
            this.offset = struct2.__info.addField(size, align);
        }

        protected AbstractMember(Struct struct2, NativeType type) {
            this.this$0 = struct2;
            super(struct2);
            Type t = struct2.getRuntime().findType(type);
            this.offset = struct2.__info.addField(t.size() << 3, t.alignment() << 3);
        }

        protected AbstractMember(Struct struct2, NativeType type, Offset offset) {
            this.this$0 = struct2;
            super(struct2);
            Type t = struct2.getRuntime().findType(type);
            this.offset = struct2.__info.addField(t.size() << 3, t.alignment() << 3, offset);
        }

        public final jnr.ffi.Pointer getMemory() {
            return this.this$0.__info.getMemory();
        }

        public final Struct struct() {
            return this.this$0;
        }

        public final long offset() {
            return this.offset + this.this$0.__info.offset;
        }
    }

    public abstract class Member {
        private /* synthetic */ Struct this$0;

        protected Member(Struct struct2) {
        }
    }

    public static final class Offset
    extends Number {
        private final int offset;

        public Offset(int offset) {
            this.offset = offset;
        }

        public final int intValue() {
            return this.offset;
        }

        public final long longValue() {
            return this.offset;
        }

        public final float floatValue() {
            return this.offset;
        }

        public final double doubleValue() {
            return this.offset;
        }
    }

    static final class Info {
        private final Runtime runtime;
        private jnr.ffi.Pointer memory = null;
        Struct enclosing = null;
        int offset = 0;
        int size = 0;
        int minAlign = 1;
        boolean isUnion = false;
        boolean resetIndex = false;

        public Info(Runtime runtime) {
            this.runtime = runtime;
        }

        public final jnr.ffi.Pointer getMemory(int flags) {
            if (this.enclosing != null) {
                return this.enclosing.__info.getMemory(flags);
            }
            if (this.memory != null) {
                return this.memory;
            }
            this.memory = this.allocateMemory(flags);
            return this.memory;
        }

        public final jnr.ffi.Pointer getMemory() {
            return this.getMemory(16);
        }

        final boolean isDirect() {
            return this.enclosing != null && this.enclosing.__info.isDirect() || this.memory != null && this.memory.isDirect();
        }

        private final jnr.ffi.Pointer allocateMemory(int flags) {
            if (ParameterFlags.isDirect(flags)) {
                Info info = this;
                return this.runtime.getMemoryManager().allocateDirect(info.size, true);
            }
            Info info = this;
            return this.runtime.getMemoryManager().allocate(info.size);
        }

        public final void useMemory(jnr.ffi.Pointer io) {
            this.memory = io;
        }

        protected final int addField(int sizeBits, int alignBits, Offset offset) {
            this.size = Math.max(this.size, offset.intValue() + (sizeBits >> 3));
            this.minAlign = Math.max(this.minAlign, alignBits >> 3);
            return offset.intValue();
        }

        protected final int addField(int sizeBits, int alignBits) {
            int off = this.resetIndex ? 0 : Struct.align(this.size, alignBits >> 3);
            this.size = Math.max(this.size, off + (sizeBits >> 3));
            this.minAlign = Math.max(this.minAlign, alignBits >> 3);
            return off;
        }
    }
}

