/*
 * Decompiled with CFR 0.152.
 */
package jline;

import com.kenai.jffi.Closure;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import jline.ConsoleReader;
import jline.CursorBuffer;

public class CandidateListCompletionHandler
implements Closure {
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = CandidateListCompletionHandler.class$("jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    private boolean eagerNewlines = true;
    private static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public final boolean complete(ConsoleReader reader, List candidates, int pos) throws IOException {
        ConsoleReader consoleReader = reader;
        CursorBuffer buf = consoleReader.buf;
        if (candidates.size() == 1) {
            String value = candidates.get(0).toString();
            if (value.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (candidates.size() > 1) {
            String string;
            List list = candidates;
            CandidateListCompletionHandler candidateListCompletionHandler = this;
            if (list == null || list.size() == 0) {
                string = null;
            } else {
                String[] stringArray = list.toArray(new String[list.size()]);
                String string2 = stringArray[0];
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < string2.length() && CandidateListCompletionHandler.startsWith(string2.substring(0, i + 1), stringArray); ++i) {
                    stringBuffer.append(string2.charAt(i));
                }
                string = stringBuffer.toString();
            }
            String value = string;
            buf.toString();
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        if (this.eagerNewlines) {
            reader.printNewline();
        }
        CandidateListCompletionHandler.printCandidates(reader, candidates, this.eagerNewlines);
        reader.drawLine();
        return true;
    }

    private static void setBuffer(ConsoleReader reader, String value, int offset) throws IOException {
        ConsoleReader consoleReader;
        do {
            consoleReader = reader;
        } while (consoleReader.buf.cursor > offset && reader.backspace());
        reader.putString(value);
        reader.setCursorPosition(offset + value.length());
    }

    private static void printCandidates(ConsoleReader reader, Collection candidates, boolean eagerNewlines) throws IOException {
        HashSet distinct = new HashSet(candidates);
        if (distinct.size() > reader.getAutoprintThreshhold()) {
            int c;
            if (!eagerNewlines) {
                reader.printNewline();
            }
            reader.printString(MessageFormat.format(loc.getString("display-candidates"), new Integer(candidates.size())) + " ");
            ConsoleReader consoleReader = reader;
            consoleReader.out.flush();
            String noOpt = loc.getString("display-candidates-no");
            String yesOpt = loc.getString("display-candidates-yes");
            while ((c = reader.readCharacter(new char[]{yesOpt.charAt(0), noOpt.charAt(0)})) != -1) {
                if (noOpt.startsWith(new String(new char[]{(char)c}))) {
                    reader.printNewline();
                    return;
                }
                if (yesOpt.startsWith(new String(new char[]{(char)c}))) break;
                reader.beep();
            }
        }
        if (distinct.size() != candidates.size()) {
            ArrayList copy = new ArrayList();
            Iterator i = candidates.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (copy.contains(next)) continue;
                copy.add(next);
            }
            candidates = copy;
        }
        reader.printNewline();
        reader.printColumns(candidates);
    }

    private static boolean startsWith(String starts, String[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].startsWith(starts)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

