/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.messages.CompositeMessage;
import com.python.pydev.analysis.messages.IMessage;
import com.python.pydev.analysis.messages.Message;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.GenAndTok;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;

public final class MessagesManager {
    private final IAnalysisPreferences prefs;
    public final Map<IToken, List<IMessage>> messages = new HashMap<IToken, List<IMessage>>();
    public final List<IMessage> independentMessages = new ArrayList<IMessage>();
    private final String moduleName;
    private final IDocument document;
    private Set<String> namesToIgnoreCache = null;

    public MessagesManager(IAnalysisPreferences prefs, String moduleName, IDocument doc) {
        this.prefs = prefs;
        this.moduleName = moduleName;
        this.document = doc;
    }

    public boolean shouldAddUnusedImportMessage() {
        if (this.moduleName == null) {
            return true;
        }
        String onlyModName = FullRepIterable.headAndTail((String)this.moduleName, (boolean)true)[1];
        Set<String> patternsToBeIgnored = this.prefs.getModuleNamePatternsToBeIgnored();
        for (String pattern : patternsToBeIgnored) {
            if (!onlyModName.matches(pattern)) continue;
            return false;
        }
        return true;
    }

    public void addMessage(int type, IToken generator, Object ... objects) {
        if (this.isUnusedImportMessage(type) && !this.shouldAddUnusedImportMessage()) {
            return;
        }
        this.doAddMessage(this.independentMessages, type, objects, generator);
    }

    private boolean isUnusedImportMessage(int type) {
        return type == 1 || type == 8;
    }

    public void addMessage(int type, IToken token) {
        List<IMessage> msgs = this.getMsgsList(token);
        this.doAddMessage(msgs, type, token.getRepresentation(), token);
    }

    private void doAddMessage(List<IMessage> msgs, int type, Object string, IToken token) {
        if (this.isUnusedImportMessage(type) && !this.shouldAddUnusedImportMessage()) {
            return;
        }
        Message messageToAdd = new Message(type, string, token, this.prefs);
        this.doAddMessage(msgs, messageToAdd);
    }

    private void doAddMessage(List<IMessage> msgs, Message messageToAdd) {
        int startLine;
        String line;
        String messageToIgnore = this.prefs.getRequiredMessageToIgnore(messageToAdd.getType());
        if (messageToIgnore != null && (line = PySelection.getLine((IDocument)this.document, (int)(startLine = messageToAdd.getStartLine(this.document) - 1))).indexOf(messageToIgnore) != -1) {
            return;
        }
        msgs.add(messageToAdd);
    }

    public void addMessage(int type, IToken generator, IToken tok) {
        this.addMessage(type, generator, tok, tok.getRepresentation());
    }

    public void addMessage(int type, IToken generator, IToken tok, String rep) {
        List<IMessage> msgs = this.getMsgsList(generator);
        this.doAddMessage(msgs, type, rep, generator);
    }

    public List<IMessage> getMsgsList(IToken generator) {
        List<IMessage> msgs = this.messages.get(generator);
        if (msgs == null) {
            msgs = new ArrayList<IMessage>();
            this.messages.put(generator, msgs);
        }
        return msgs;
    }

    public void addUndefinedMessage(IToken token) {
        this.addUndefinedMessage(token, null);
    }

    public void addUndefinedMessage(IToken token, String rep) {
        Tuple<Boolean, String> undef = this.isActuallyUndefined(token, rep);
        if (((Boolean)undef.o1).booleanValue()) {
            this.addMessage(3, token, undef.o2);
        }
    }

    public void addUndefinedVarInImportMessage(IToken token, String rep) {
        Tuple<Boolean, String> undef = this.isActuallyUndefined(token, rep);
        if (((Boolean)undef.o1).booleanValue()) {
            this.addMessage(9, token, undef.o2);
        }
    }

    public void onAddAssignmentToBuiltinMessage(IToken token, String rep) {
        this.addMessage(14, token);
    }

    protected Tuple<Boolean, String> isActuallyUndefined(IToken token, String rep) {
        String builtinType;
        int i;
        String tokenRepresentation = token.getRepresentation();
        if (tokenRepresentation != null) {
            String firstPart = FullRepIterable.getFirstPart((String)tokenRepresentation);
            if (this.prefs.getTokensAlwaysInGlobals().contains(firstPart)) {
                return new Tuple((Object)false, (Object)firstPart);
            }
        }
        boolean isActuallyUndefined = true;
        if (rep == null) {
            rep = tokenRepresentation;
        }
        if ((i = rep.indexOf(46)) != -1) {
            rep = rep.substring(0, i);
        }
        if ((builtinType = NodeUtils.getBuiltinType((String)rep)) != null) {
            isActuallyUndefined = false;
        }
        return new Tuple((Object)isActuallyUndefined, (Object)rep);
    }

    public void onArgumentsMismatch(IToken token, Call callNode) {
        FastStringBuffer buf = new FastStringBuffer(128);
        buf.append(token.getRepresentation());
        buf.append(": arguments don't match");
        List<IMessage> msgs = this.getMsgsList(token);
        ParsingUtils parsingUtils = ParsingUtils.create((Object)this.document);
        try {
            int closeParensPos;
            int offset = PySelection.getAbsoluteCursorOffset((IDocument)this.document, (int)(callNode.func.beginLine - 1), (int)(callNode.func.beginColumn - 1));
            int openParensPos = parsingUtils.findNextChar(offset, '(');
            if (openParensPos != -1 && (closeParensPos = parsingUtils.eatPar(openParensPos, null)) != -1) {
                int startLine = PySelection.getLineOfOffset((IDocument)this.document, (int)openParensPos) + 1;
                int endLine = PySelection.getLineOfOffset((IDocument)this.document, (int)closeParensPos) + 1;
                int startCol = openParensPos - this.document.getLineInformationOfOffset(openParensPos).getOffset() + 1;
                int endCol = closeParensPos - this.document.getLineInformationOfOffset(closeParensPos).getOffset() + 1 + 1;
                Message messageToAdd = new Message(16, buf.toString(), startLine, endLine, startCol, endCol, this.prefs);
                this.doAddMessage(msgs, messageToAdd);
                return;
            }
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
        catch (SyntaxErrorException syntaxErrorException) {}
        this.doAddMessage(msgs, 16, buf.toString(), token);
    }

    public void addUnusedMessage(SimpleNode node, Found f) {
        List<GenAndTok> all = f.getAll();
        int len = all.size();
        int i = 0;
        while (i < len) {
            block17: {
                boolean addMessage;
                int type;
                GenAndTok g;
                block18: {
                    block16: {
                        SimpleNode ast;
                        boolean isFromImport;
                        g = all.get(i);
                        if (!(g.generator instanceof SourceToken) || !(isFromImport = (ast = ((SourceToken)g.generator).getAst()) instanceof ImportFrom) && !(ast instanceof Import)) break block16;
                        if (isFromImport && AbstractVisitor.isWildImport((ImportFrom)((ImportFrom)ast))) {
                            this.addMessage(8, g.generator, g.tok);
                        } else if (!(g.generator instanceof AbstractVisitor.ImportPartSourceToken)) {
                            this.addMessage(1, g.generator, g.tok);
                        }
                        break block17;
                    }
                    if (!this.startsWithNamesToIgnore(g)) break block17;
                    type = 2;
                    if (g.tok instanceof SourceToken) {
                        NameTok n;
                        SourceToken t = (SourceToken)g.tok;
                        SimpleNode ast = t.getAst();
                        if (ast instanceof NameTok) {
                            n = (NameTok)ast;
                            if (n.ctx == 6 || n.ctx == 5 || n.ctx == 3) {
                                type = 10;
                            }
                        } else if (ast instanceof Name) {
                            n = (Name)ast;
                            if (n.ctx == 6 || n.ctx == 8) {
                                type = 10;
                            }
                        }
                    }
                    addMessage = true;
                    if (type != 10 || !(node instanceof FunctionDef)) break block18;
                    addMessage = false;
                    FunctionDef def = (FunctionDef)node;
                    stmtType[] stmtTypeArray = def.body;
                    int n = def.body.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block19: {
                            block20: {
                                stmtType b = stmtTypeArray[n2];
                                if (b instanceof Pass) break block19;
                                if (!(b instanceof Expr)) break block20;
                                Expr expr = (Expr)b;
                                if (expr.value instanceof Str) break block19;
                            }
                            addMessage = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (addMessage) {
                    this.addMessage(type, g.generator, g.tok);
                }
            }
            ++i;
        }
    }

    private boolean startsWithNamesToIgnore(GenAndTok g) {
        if (this.namesToIgnoreCache == null) {
            this.namesToIgnoreCache = this.prefs.getNamesIgnoredByUnusedVariable();
        }
        String representation = g.tok.getRepresentation();
        boolean addIt = true;
        for (String str : this.namesToIgnoreCache) {
            if (!representation.startsWith(str)) continue;
            addIt = false;
            break;
        }
        return addIt;
    }

    public void addReimportMessage(Found f) {
        List<GenAndTok> all = f.getAll();
        int len = all.size();
        int i = 0;
        while (i < len) {
            GenAndTok g = all.get(i);
            if (g.generator instanceof SourceToken && !(g.generator instanceof AbstractVisitor.ImportPartSourceToken) && !g.generator.isWildImport()) {
                this.addMessage(5, g.generator, g.tok);
            }
            ++i;
        }
    }

    public List<IMessage> getMessages() {
        ArrayList<IMessage> result = new ArrayList<IMessage>();
        for (List<IMessage> l : this.messages.values()) {
            if (l.size() < 1) continue;
            Map<Integer, List<IMessage>> messagesByType = this.getMessagesByType(l);
            for (int type : messagesByType.keySet()) {
                l = messagesByType.get(type);
                IMessage message = l.get(0);
                if (message.getSeverity() == 0 && this.doIgnoreMessageIfJustInformational(message.getType())) continue;
                if (l.size() == 1) {
                    this.addToResult(result, message);
                    continue;
                }
                IToken generator = message.getGenerator();
                CompositeMessage compositeMessage = generator != null ? new CompositeMessage(message.getType(), generator, this.prefs) : new CompositeMessage(message.getType(), message.getStartLine(this.document), message.getEndLine(this.document), message.getStartCol(this.document), message.getEndCol(this.document), this.prefs);
                for (IMessage m : l) {
                    compositeMessage.addMessage(m);
                }
                this.addToResult(result, compositeMessage);
            }
        }
        for (IMessage message : this.independentMessages) {
            if (message.getSeverity() == 0 && this.doIgnoreMessageIfJustInformational(message.getType())) continue;
            this.addToResult(result, message);
        }
        return result;
    }

    private boolean doIgnoreMessageIfJustInformational(int type) {
        return type == 10 || type == 12 || type == 11 || type == 15 || type == 14 || type == 16;
    }

    private void addToResult(List<IMessage> result, IMessage message) {
        String asAbsoluteImport;
        IToken generator;
        if (this.isUnusedImportMessage(message.getType()) && (generator = message.getGenerator()) instanceof SourceToken && ((asAbsoluteImport = generator.getAsAbsoluteImport()).indexOf("__future__.") != -1 || asAbsoluteImport.indexOf("__metaclass__") != -1)) {
            return;
        }
        result.add(message);
    }

    private Map<Integer, List<IMessage>> getMessagesByType(List<IMessage> l) {
        HashMap<Integer, List<IMessage>> messagesByType = new HashMap<Integer, List<IMessage>>();
        for (IMessage message : l) {
            List<IMessage> messages = messagesByType.get(message.getType());
            if (messages == null) {
                messages = new ArrayList<IMessage>();
                messagesByType.put(message.getType(), messages);
            }
            messages.add(message);
        }
        return messagesByType;
    }
}

