/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.search_index;

import com.python.pydev.analysis.search_index.PyModuleLineElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.Region;
import org.eclipse.search.ui.text.Match;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.shared_ui.search.ICustomMatch;

public class PyModuleMatch
extends Match
implements ICustomMatch {
    private PyModuleLineElement fLineElement;
    private Region fOriginalLocation;
    private long fCreationTimeStamp;
    public final ModulesKey modulesKey;

    public PyModuleMatch(IFile element, int offset, int length, PyModuleLineElement lineEntry, ModulesKey modulesKey) {
        super((Object)element, offset, length);
        Assert.isLegal((lineEntry != null ? 1 : 0) != 0);
        this.modulesKey = modulesKey;
        this.fLineElement = lineEntry;
        this.fCreationTimeStamp = element.getModificationStamp();
    }

    public void setOffset(int offset) {
        if (this.fOriginalLocation == null) {
            this.fOriginalLocation = new Region(this.getOffset(), this.getLength());
        }
        super.setOffset(offset);
    }

    public void setLength(int length) {
        if (this.fOriginalLocation == null) {
            this.fOriginalLocation = new Region(this.getOffset(), this.getLength());
        }
        super.setLength(length);
    }

    public int getOriginalOffset() {
        if (this.fOriginalLocation != null) {
            return this.fOriginalLocation.getOffset();
        }
        return this.getOffset();
    }

    public int getOriginalLength() {
        if (this.fOriginalLocation != null) {
            return this.fOriginalLocation.getLength();
        }
        return this.getLength();
    }

    public PyModuleLineElement getLineElement() {
        return this.fLineElement;
    }

    public IFile getFile() {
        return (IFile)this.getElement();
    }

    public boolean isFileSearch() {
        return this.fLineElement == null;
    }

    public long getCreationTimeStamp() {
        return this.fCreationTimeStamp;
    }
}

