/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.AbstractAnalysisPreferences;
import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.PyAnalysisScopedPreferences;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.shared_core.preferences.IScopedPreferences;

public class AnalysisPreferences
extends AbstractAnalysisPreferences {
    private final IAdaptable projectAdaptable;
    static final Object[][] completeSeverityMap = new Object[][]{{1, "SEVERITY_UNUSED_IMPORT", 1}, {2, "SEVERITY_UNUSED_VARIABLE", 1}, {3, "SEVERITY_UNDEFINED_VARIABLE", 2}, {4, "SEVERITY_DUPLICATED_SIGNATURE", 2}, {5, "SEVERITY_REIMPORT", 1}, {6, "SEVERITY_UNRESOLVED_IMPORT", 2}, {7, "SEVERITY_NO_SELF", 2}, {8, "SEVERITY_UNUSED_WILD_IMPORT", 1}, {9, "SEVERITY_UNDEFINED_IMPORT_VARIABLE", 2}, {10, "SEVERITY_UNUSED_PARAMETER", 0}, {11, "SEVERITY_NO_EFFECT_STMT", 1}, {12, "SEVERITY_INDENTATION_PROBLEM", 1}, {14, "SEVERITY_ASSIGNMENT_TO_BUILT_IN_SYMBOL", 1}, {15, "SEVERITY_PEP8", 0}, {16, "SEVERITY_ARGUMENTS_MISMATCH", 0}};
    private HashMap<Integer, Integer> severityTypeMapCache;
    private final Object lock = new Object();

    public AnalysisPreferences(IAdaptable projectAdaptable) {
        this.projectAdaptable = projectAdaptable;
    }

    @Override
    public IAdaptable getProjectAdaptable() {
        return this.projectAdaptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Integer> getSeverityTypeMap() {
        if (this.severityTypeMapCache == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.severityTypeMapCache == null) {
                    HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
                    IPreferenceStore pluginPreferences = AnalysisPlugin.getDefault().getPreferenceStore();
                    IScopedPreferences iScopedPreferences = PyAnalysisScopedPreferences.get();
                    int i = 0;
                    while (i < completeSeverityMap.length) {
                        Object[] s = completeSeverityMap[i];
                        int v = iScopedPreferences.getInt(pluginPreferences, (String)s[1], this.projectAdaptable);
                        temp.put((Integer)s[0], v);
                        ++i;
                    }
                    temp.put(16, 0);
                    this.severityTypeMapCache = temp;
                }
            }
        }
        return this.severityTypeMapCache;
    }

    @Override
    public int getSeverityForType(int type) {
        Map<Integer, Integer> severityTypeMap = this.getSeverityTypeMap();
        Integer sev = severityTypeMap.get(type);
        if (sev == null) {
            throw new RuntimeException("Unable to get severity for: " + type);
        }
        return sev;
    }

    @Override
    public boolean makeCodeAnalysis() {
        AnalysisPlugin plugin = AnalysisPlugin.getDefault();
        if (plugin == null) {
            return false;
        }
        return PyAnalysisScopedPreferences.getBoolean("DO_CODE_ANALYSIS", this.projectAdaptable);
    }

    @Override
    public Set<String> getNamesIgnoredByUnusedVariable() {
        return this.getSetOfNames("NAMES_TO_IGNORE_UNUSED_VARIABLE");
    }

    @Override
    public Set<String> getTokensAlwaysInGlobals() {
        return this.getSetOfNames("NAMES_TO_CONSIDER_GLOBALS");
    }

    private Set<String> getSetOfNames(String preferencesName) {
        HashSet<String> names = new HashSet<String>();
        String string = PyAnalysisScopedPreferences.getString(preferencesName, this.projectAdaptable);
        if (string != null) {
            String[] strings = string.split(",");
            int i = 0;
            while (i < strings.length) {
                names.add(strings[i].trim());
                ++i;
            }
        }
        return names;
    }

    @Override
    public Set<String> getModuleNamePatternsToBeIgnored() {
        Set<String> setOfNames = this.getSetOfNames("NAMES_TO_IGNORE_UNUSED_IMPORT");
        HashSet<String> ret = new HashSet<String>();
        for (String string : setOfNames) {
            ret.add(string.replaceAll("\\*", ".*"));
        }
        return ret;
    }

    @Override
    public int getWhenAnalyze() {
        return PyAnalysisScopedPreferences.getInt("WHEN_ANALYZE", this.projectAdaptable, 0);
    }
}

