// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.console');
goog.require('cljs.core');
goog.require('lt.util.dom');
goog.require('lt.objs.app');
goog.require('lt.objs.files');
goog.require('lt.objs.statusbar');
goog.require('lt.util.dom');
goog.require('lt.objs.platform');
goog.require('lt.objs.tabs');
goog.require('lt.util.dom');
goog.require('clojure.string');
goog.require('lt.objs.command');
goog.require('lt.objs.platform');
goog.require('lt.objs.files');
goog.require('lt.objs.statusbar');
goog.require('lt.objs.bottombar');
goog.require('lt.objs.app');
goog.require('clojure.string');
goog.require('lt.object');
goog.require('lt.object');
goog.require('lt.objs.tabs');
goog.require('lt.objs.bottombar');
goog.require('lt.objs.command');
lt.objs.console.console_limit = 50;
lt.objs.console.util_inspect = require("util").inspect;
lt.objs.console.logs_dir = lt.objs.files.lt_user_dir.call(null,"logs");
lt.objs.console.core_log = (function (){try{if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,lt.objs.console.logs_dir)))
{} else
{if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,lt.objs.files.lt_user_dir.call(null))))
{} else
{lt.objs.files.mkdir.call(null,lt.objs.files.lt_user_dir.call(null));
}
lt.objs.files.mkdir.call(null,lt.objs.console.logs_dir);
}
return require("fs").createWriteStream(lt.objs.files.join.call(null,lt.objs.console.logs_dir,[cljs.core.str("window"),cljs.core.str(lt.objs.app.window_number.call(null)),cljs.core.str(".log")].join('')));
}catch (e10688){var e = e10688;return console.error([cljs.core.str("Failed to initialize the log writer: "),cljs.core.str(e)].join(''));
}})();
lt.objs.console.__GT_ui = (function __GT_ui(c){return lt.object.__GT_content.call(null,c);
});
lt.objs.console.dom_like_QMARK_ = (function dom_like_QMARK_(thing){var or__3520__auto__ = cljs.core.vector_QMARK_.call(null,thing);if(or__3520__auto__)
{return or__3520__auto__;
} else
{var or__3520__auto____$1 = thing.nodeType;if(cljs.core.truth_(or__3520__auto____$1))
{return or__3520__auto____$1;
} else
{return typeof thing === 'string';
}
}
});
lt.objs.console.write = (function write($console,msg){if((cljs.core.count.call(null,lt.util.dom.children.call(null,$console)) > (lt.objs.console.console_limit - 1)))
{lt.util.dom.remove.call(null,(lt.util.dom.children.call(null,$console)[0]));
} else
{}
if(lt.objs.bottombar.active_QMARK_.call(null,lt.objs.console.console))
{} else
{lt.objs.statusbar.dirty.call(null);
}
return lt.util.dom.append.call(null,$console,msg);
});
lt.objs.console.write_to_log = (function write_to_log(thing){if(cljs.core.truth_(lt.objs.console.core_log))
{return lt.objs.console.core_log.write(thing);
} else
{return null;
}
});
var group__6668__auto___10692 = cljs.core.swap_BANG_.call(null,crate.core.group_id,cljs.core.inc);/**
* @param {...*} var_args
*/
lt.objs.console.__GT_item = (function() { 
var __GT_item__delegate = function (l,p__10689){var vec__10691 = p__10689;var class$ = cljs.core.nth.call(null,vec__10691,0,null);var elem__6669__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",1108647146),class$], null),l], null));elem__6669__auto__.setAttribute("crateGroup",group__6668__auto___10692);
return elem__6669__auto__;
};
var __GT_item = function (l,var_args){
var p__10689 = null;if (arguments.length > 1) {
  p__10689 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return __GT_item__delegate.call(this,l,p__10689);};
__GT_item.cljs$lang$maxFixedArity = 1;
__GT_item.cljs$lang$applyTo = (function (arglist__10693){
var l = cljs.core.first(arglist__10693);
var p__10689 = cljs.core.rest(arglist__10693);
return __GT_item__delegate(l,p__10689);
});
__GT_item.cljs$core$IFn$_invoke$arity$variadic = __GT_item__delegate;
return __GT_item;
})()
;
lt.objs.console.__GT_item.prototype._crateGroup = group__6668__auto___10692;
lt.objs.console.log = (function() {
var log = null;
var log__1 = (function (l){return log.call(null,l,null);
});
var log__2 = (function (l,class$){return log.call(null,l,class$,null);
});
var log__3 = (function (l,class$,str_content){if(cljs.core._EQ_.call(null,"",l))
{return null;
} else
{var $console = lt.objs.console.__GT_ui.call(null,lt.objs.console.console);if(cljs.core.truth_((function (){var or__3520__auto__ = typeof l === 'string';if(or__3520__auto__)
{return or__3520__auto__;
} else
{return str_content;
}
})()))
{lt.objs.console.write_to_log.call(null,((typeof l === 'string')?l:str_content));
lt.objs.console.write.call(null,$console,lt.objs.console.__GT_item.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",1014015509),((cljs.core.not.call(null,lt.objs.console.dom_like_QMARK_.call(null,l)))?cljs.core.pr_str.call(null,l):l)], null),class$));
lt.util.dom.scroll_top.call(null,$console,10000000000);
return null;
} else
{return null;
}
}
});
log = function(l,class$,str_content){
switch(arguments.length){
case 1:
return log__1.call(this,l);
case 2:
return log__2.call(this,l,class$);
case 3:
return log__3.call(this,l,class$,str_content);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
log.cljs$core$IFn$_invoke$arity$1 = log__1;
log.cljs$core$IFn$_invoke$arity$2 = log__2;
log.cljs$core$IFn$_invoke$arity$3 = log__3;
return log;
})()
;
/**
* Log errors, strings or any objects as console error(s). If an error,
* its stack is logged
* @param {...*} var_args
*/
lt.objs.console.error = (function() { 
var error__delegate = function (errors){lt.objs.statusbar.console_class.call(null,"error");
var seq__10698 = cljs.core.seq.call(null,errors);var chunk__10699 = null;var count__10700 = 0;var i__10701 = 0;while(true){
if((i__10701 < count__10700))
{var e = cljs.core._nth.call(null,chunk__10699,i__10701);lt.objs.console.log.call(null,[cljs.core.str((cljs.core.truth_(e.stack)?e.stack:((typeof e === 'string')?e:((cljs.core.not_EQ_.call(null,cljs.core.pr_str.call(null,e),"[object Object]"))?cljs.core.pr_str.call(null,e):((new cljs.core.Keyword(null,"else","else",1017020587))?[cljs.core.str(e)].join(''):null)))))].join(''),"error");
{
var G__10702 = seq__10698;
var G__10703 = chunk__10699;
var G__10704 = count__10700;
var G__10705 = (i__10701 + 1);
seq__10698 = G__10702;
chunk__10699 = G__10703;
count__10700 = G__10704;
i__10701 = G__10705;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__10698);if(temp__4092__auto__)
{var seq__10698__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__10698__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__10698__$1);{
var G__10706 = cljs.core.chunk_rest.call(null,seq__10698__$1);
var G__10707 = c__4262__auto__;
var G__10708 = cljs.core.count.call(null,c__4262__auto__);
var G__10709 = 0;
seq__10698 = G__10706;
chunk__10699 = G__10707;
count__10700 = G__10708;
i__10701 = G__10709;
continue;
}
} else
{var e = cljs.core.first.call(null,seq__10698__$1);lt.objs.console.log.call(null,[cljs.core.str((cljs.core.truth_(e.stack)?e.stack:((typeof e === 'string')?e:((cljs.core.not_EQ_.call(null,cljs.core.pr_str.call(null,e),"[object Object]"))?cljs.core.pr_str.call(null,e):((new cljs.core.Keyword(null,"else","else",1017020587))?[cljs.core.str(e)].join(''):null)))))].join(''),"error");
{
var G__10710 = cljs.core.next.call(null,seq__10698__$1);
var G__10711 = null;
var G__10712 = 0;
var G__10713 = 0;
seq__10698 = G__10710;
chunk__10699 = G__10711;
count__10700 = G__10712;
i__10701 = G__10713;
continue;
}
}
} else
{return null;
}
}
break;
}
};
var error = function (var_args){
var errors = null;if (arguments.length > 0) {
  errors = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return error__delegate.call(this,errors);};
error.cljs$lang$maxFixedArity = 0;
error.cljs$lang$applyTo = (function (arglist__10714){
var errors = cljs.core.seq(arglist__10714);
return error__delegate(errors);
});
error.cljs$core$IFn$_invoke$arity$variadic = error__delegate;
return error;
})()
;
process.on("uncaughtException",(function (p1__10715_SHARP_){return lt.objs.console.error.call(null,p1__10715_SHARP_);
}));
lt.objs.console.console_ui = (function console_ui(this$){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.console","ul.console",1376481394)], null));var seq__10722_10728 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"contextmenu","contextmenu",911789824),(function (e){return lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"menu!","menu!",1117686292),e);
})], null)));var chunk__10723_10729 = null;var count__10724_10730 = 0;var i__10725_10731 = 0;while(true){
if((i__10725_10731 < count__10724_10730))
{var vec__10726_10732 = cljs.core._nth.call(null,chunk__10723_10729,i__10725_10731);var ev__3326__auto___10733 = cljs.core.nth.call(null,vec__10726_10732,0,null);var func__3327__auto___10734 = cljs.core.nth.call(null,vec__10726_10732,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___10733,func__3327__auto___10734);
{
var G__10735 = seq__10722_10728;
var G__10736 = chunk__10723_10729;
var G__10737 = count__10724_10730;
var G__10738 = (i__10725_10731 + 1);
seq__10722_10728 = G__10735;
chunk__10723_10729 = G__10736;
count__10724_10730 = G__10737;
i__10725_10731 = G__10738;
continue;
}
} else
{var temp__4092__auto___10739 = cljs.core.seq.call(null,seq__10722_10728);if(temp__4092__auto___10739)
{var seq__10722_10740__$1 = temp__4092__auto___10739;if(cljs.core.chunked_seq_QMARK_.call(null,seq__10722_10740__$1))
{var c__4262__auto___10741 = cljs.core.chunk_first.call(null,seq__10722_10740__$1);{
var G__10742 = cljs.core.chunk_rest.call(null,seq__10722_10740__$1);
var G__10743 = c__4262__auto___10741;
var G__10744 = cljs.core.count.call(null,c__4262__auto___10741);
var G__10745 = 0;
seq__10722_10728 = G__10742;
chunk__10723_10729 = G__10743;
count__10724_10730 = G__10744;
i__10725_10731 = G__10745;
continue;
}
} else
{var vec__10727_10746 = cljs.core.first.call(null,seq__10722_10740__$1);var ev__3326__auto___10747 = cljs.core.nth.call(null,vec__10727_10746,0,null);var func__3327__auto___10748 = cljs.core.nth.call(null,vec__10727_10746,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___10747,func__3327__auto___10748);
{
var G__10749 = cljs.core.next.call(null,seq__10722_10740__$1);
var G__10750 = null;
var G__10751 = 0;
var G__10752 = 0;
seq__10722_10728 = G__10749;
chunk__10723_10729 = G__10750;
count__10724_10730 = G__10751;
i__10725_10731 = G__10752;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.console.__BEH__on_close = (function __BEH__on_close(this$){lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"current-ui","current-ui",4219850458),new cljs.core.Keyword(null,"bottom","bottom",3925642653)], null));
return lt.objs.tabs.rem_BANG_.call(null,this$);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.console","on-close","lt.objs.console/on-close",3910850223),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.console.__BEH__on_close,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"close","close",1108660586),null], null), null));
lt.object.object_STAR_.call(null,new cljs.core.Keyword("lt.objs.console","console","lt.objs.console/console",4459732666),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console","console",1965414601),null], null), null),new cljs.core.Keyword(null,"name","name",1017277949),"console",new cljs.core.Keyword(null,"dirty","dirty",1109497668),false,new cljs.core.Keyword(null,"init","init",1017141378),(function (this$){lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"current-ui","current-ui",4219850458),new cljs.core.Keyword(null,"bottom","bottom",3925642653)], null));
return lt.objs.console.console_ui.call(null,this$);
}));
lt.objs.console.__BEH__set_console_limit = (function __BEH__set_console_limit(this$,size){return lt.objs.console.console_limit = size;
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.console","set-console-limit","lt.objs.console/set-console-limit",868332415),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.console.__BEH__set_console_limit,new cljs.core.Keyword(null,"desc","desc",1016984067),"Console: Set buffer size",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"size"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.console.inspect = (function inspect(thing){return lt.objs.console.util_inspect.call(null,thing,false,2);
});
lt.objs.console.verbatim = (function() {
var verbatim = null;
var verbatim__1 = (function (thing){return verbatim.call(null,thing,null);
});
var verbatim__2 = (function (thing,class$){return verbatim.call(null,thing,class$,null);
});
var verbatim__3 = (function (thing,class$,str_content){var $console = lt.objs.console.__GT_ui.call(null,lt.objs.console.console);if(cljs.core.truth_(str_content))
{lt.objs.console.write_to_log.call(null,str_content);
} else
{}
if(cljs.core.truth_(class$))
{lt.objs.statusbar.console_class.call(null,class$);
} else
{}
lt.objs.console.write.call(null,$console,lt.objs.console.__GT_item.call(null,thing,class$));
lt.util.dom.scroll_top.call(null,$console,10000000000);
return null;
});
verbatim = function(thing,class$,str_content){
switch(arguments.length){
case 1:
return verbatim__1.call(this,thing);
case 2:
return verbatim__2.call(this,thing,class$);
case 3:
return verbatim__3.call(this,thing,class$,str_content);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
verbatim.cljs$core$IFn$_invoke$arity$1 = verbatim__1;
verbatim.cljs$core$IFn$_invoke$arity$2 = verbatim__2;
verbatim.cljs$core$IFn$_invoke$arity$3 = verbatim__3;
return verbatim;
})()
;
lt.objs.console.try_update = (function try_update(p__10753){var map__10755 = p__10753;var map__10755__$1 = ((cljs.core.seq_QMARK_.call(null,map__10755))?cljs.core.apply.call(null,cljs.core.hash_map,map__10755):map__10755);var id = cljs.core.get.call(null,map__10755__$1,new cljs.core.Keyword(null,"id","id",1013907597));var content = cljs.core.get.call(null,map__10755__$1,new cljs.core.Keyword(null,"content","content",1965434859));if(cljs.core.truth_(id))
{var temp__4092__auto__ = lt.util.dom.$.call(null,[cljs.core.str("#console"),cljs.core.str(id)].join(''),lt.objs.console.__GT_ui.call(null,lt.objs.console.console));if(cljs.core.truth_(temp__4092__auto__))
{var pre = temp__4092__auto__;lt.util.dom.append.call(null,pre,lt.util.dom.text_node.call(null,content));
return true;
} else
{return null;
}
} else
{return null;
}
});
lt.objs.console.loc_log = (function loc_log(p__10756){var map__10758 = p__10756;var map__10758__$1 = ((cljs.core.seq_QMARK_.call(null,map__10758))?cljs.core.apply.call(null,cljs.core.hash_map,map__10758):map__10758);var msg = map__10758__$1;var id = cljs.core.get.call(null,map__10758__$1,new cljs.core.Keyword(null,"id","id",1013907597));var str_content = cljs.core.get.call(null,map__10758__$1,new cljs.core.Keyword(null,"str-content","str-content",1379403855));var class$ = cljs.core.get.call(null,map__10758__$1,new cljs.core.Keyword(null,"class","class",1108647146));var content = cljs.core.get.call(null,map__10758__$1,new cljs.core.Keyword(null,"content","content",1965434859));var line = cljs.core.get.call(null,map__10758__$1,new cljs.core.Keyword(null,"line","line",1017226086));var file = cljs.core.get.call(null,map__10758__$1,new cljs.core.Keyword(null,"file","file",1017047278));if(cljs.core.truth_(content))
{if(cljs.core.truth_((function (){var or__3520__auto__ = typeof content === 'string';if(or__3520__auto__)
{return or__3520__auto__;
} else
{return str_content;
}
})()))
{lt.objs.console.write_to_log.call(null,[cljs.core.str(file),cljs.core.str("["),cljs.core.str(line),cljs.core.str("]: "),cljs.core.str(((typeof content === 'string')?content:str_content)),cljs.core.str("\n")].join(''));
} else
{}
if(cljs.core.truth_(lt.objs.console.try_update.call(null,msg)))
{return null;
} else
{return lt.objs.console.verbatim.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table","table",1124020032),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",1013907952),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.loc","td.loc",4428715572),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"em.file","em.file",3623665268),file,(cljs.core.truth_(line)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"em.line","em.line",3623844076),"[",line,"]"], null):null),": "], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1013907938),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",1014015509),(cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",1013907597),[cljs.core.str("console"),cljs.core.str(id)].join('')], null):null),((typeof content === 'string')?clojure.string.replace.call(null,content,/^\s+/,""):content)], null)], null)], null)], null),class$);
}
} else
{return null;
}
});
lt.objs.console.clear = (function clear(){return lt.util.dom.empty.call(null,lt.objs.console.__GT_ui.call(null,lt.objs.console.console));
});
lt.object.object_STAR_.call(null,new cljs.core.Keyword("lt.objs.console","sidebar.console","lt.objs.console/sidebar.console",2213486188),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"console","console",1965414601),null], null), null),new cljs.core.Keyword(null,"label","label",1116631654),"console",new cljs.core.Keyword(null,"order","order",1119910592),4,new cljs.core.Keyword(null,"init","init",1017141378),(function (this$){return lt.objs.console.console_ui.call(null,this$);
}));
lt.objs.console.console = lt.object.create.call(null,new cljs.core.Keyword("lt.objs.console","console","lt.objs.console/console",4459732666));
lt.objs.console.__BEH__menu_PLUS_ = (function __BEH__menu_PLUS_(this$,items,event){return cljs.core.conj.call(null,items,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1116631654),"Clear",new cljs.core.Keyword(null,"order","order",1119910592),1,new cljs.core.Keyword(null,"click","click",1108654330),(function (){return lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"clear-console","clear-console",2279593289));
})], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1116631654),"Copy",new cljs.core.Keyword(null,"order","order",1119910592),2,new cljs.core.Keyword(null,"click","click",1108654330),(function (){var target = event.target;var item = ((cljs.core._EQ_.call(null,target.tagName.toLowerCase(),"li"))?target:lt.util.dom.parents.call(null,target,"ul.console li"));return lt.objs.platform.copy.call(null,target.textContent);
})], null),((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"tab","tab",1014018823),new cljs.core.Keyword(null,"current-ui","current-ui",4219850458).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.console.console))))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1116631654),"Hide console",new cljs.core.Keyword(null,"order","order",1119910592),3,new cljs.core.Keyword(null,"click","click",1108654330),(function (){return lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"toggle-console","toggle-console",4454540112));
})], null):null),((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"tab","tab",1014018823),new cljs.core.Keyword(null,"current-ui","current-ui",4219850458).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.console.console))))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1116631654),"Open console tab",new cljs.core.Keyword(null,"order","order",1119910592),4,new cljs.core.Keyword(null,"click","click",1108654330),(function (){lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"toggle-console","toggle-console",4454540112));
return lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"console-tab","console-tab",3389753745));
})], null):null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.console","menu+","lt.objs.console/menu+",4199189645),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.console.__BEH__menu_PLUS_,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"menu+","menu+",1117686302),null], null), null));
lt.objs.console.__BEH__statusbar_console_toggle = (function __BEH__statusbar_console_toggle(this$){lt.object.raise.call(null,lt.objs.bottombar.bottombar,new cljs.core.Keyword(null,"toggle","toggle",4440567494),lt.objs.console.console);
if(lt.objs.bottombar.active_QMARK_.call(null,lt.objs.console.console))
{lt.util.dom.scroll_top.call(null,lt.object.__GT_content.call(null,lt.objs.console.console),10000000000);
return lt.objs.statusbar.clean.call(null);
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.console","statusbar-console-toggle","lt.objs.console/statusbar-console-toggle",510309147),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.console.__BEH__statusbar_console_toggle,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"toggle","toggle",4440567494),null], null), null));
lt.objs.console.__BEH__statusbar_console_show = (function __BEH__statusbar_console_show(this$){lt.object.raise.call(null,lt.objs.bottombar.bottombar,new cljs.core.Keyword(null,"show!","show!",1123317814),lt.objs.console.console);
if(lt.objs.bottombar.active_QMARK_.call(null,lt.objs.console.console))
{lt.util.dom.scroll_top.call(null,lt.object.__GT_content.call(null,lt.objs.console.console),10000000000);
return lt.objs.statusbar.clean.call(null);
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.console","statusbar-console-show","lt.objs.console/statusbar-console-show",4407857938),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.console.__BEH__statusbar_console_show,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"show!","show!",1123317814),null], null), null));
lt.objs.console.__BEH__statusbar_console_hide = (function __BEH__statusbar_console_hide(this$){return lt.object.raise.call(null,lt.objs.bottombar.bottombar,new cljs.core.Keyword(null,"hide!","hide!",1113177745),lt.objs.console.console);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.console","statusbar-console-hide","lt.objs.console/statusbar-console-hide",4457881813),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.console.__BEH__statusbar_console_hide,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide!","hide!",1113177745),null], null), null));
lt.objs.bottombar.add_item.call(null,lt.objs.console.console);
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"console-tab","console-tab",3389753745),new cljs.core.Keyword(null,"desc","desc",1016984067),"Console: Open the console in a tab",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"tab","tab",1014018823),new cljs.core.Keyword(null,"current-ui","current-ui",4219850458).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.console.console))))
{lt.object.raise.call(null,lt.objs.statusbar.console_toggle,new cljs.core.Keyword(null,"hide!","hide!",1113177745));
lt.object.merge_BANG_.call(null,lt.objs.console.console,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"current-ui","current-ui",4219850458),new cljs.core.Keyword(null,"tab","tab",1014018823)], null));
return lt.objs.tabs.add_BANG_.call(null,lt.objs.console.console);
} else
{return null;
}
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"console.show","console.show",1651695782),new cljs.core.Keyword(null,"desc","desc",1016984067),"Console: Show console",new cljs.core.Keyword(null,"hidden","hidden",4091384092),true,new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"current-ui","current-ui",4219850458).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.console.console)),new cljs.core.Keyword(null,"tab","tab",1014018823)))
{lt.objs.tabs.active_BANG_.call(null,lt.objs.console.console);
return lt.objs.statusbar.clean.call(null);
} else
{return lt.object.raise.call(null,lt.objs.statusbar.console_toggle,new cljs.core.Keyword(null,"show!","show!",1123317814));
}
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"console.hide","console.hide",1651368683),new cljs.core.Keyword(null,"desc","desc",1016984067),"Console: Hide console",new cljs.core.Keyword(null,"hidden","hidden",4091384092),true,new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"current-ui","current-ui",4219850458).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.console.console)),new cljs.core.Keyword(null,"tab","tab",1014018823)))
{return lt.object.raise.call(null,lt.objs.console.console,new cljs.core.Keyword(null,"close","close",1108660586));
} else
{return lt.object.raise.call(null,lt.objs.statusbar.console_toggle,new cljs.core.Keyword(null,"hide!","hide!",1113177745));
}
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"toggle-console","toggle-console",4454540112),new cljs.core.Keyword(null,"desc","desc",1016984067),"Console: Toggle console",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"current-ui","current-ui",4219850458).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.console.console)),new cljs.core.Keyword(null,"tab","tab",1014018823)))
{lt.objs.tabs.active_BANG_.call(null,lt.objs.console.console);
return lt.objs.statusbar.clean.call(null);
} else
{return lt.object.raise.call(null,lt.objs.statusbar.console_toggle,new cljs.core.Keyword(null,"toggle","toggle",4440567494));
}
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"clear-console","clear-console",2279593289),new cljs.core.Keyword(null,"desc","desc",1016984067),"Console: Clear console",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (this$){var seq__10759_10763 = cljs.core.seq.call(null,lt.object.by_tag.call(null,new cljs.core.Keyword(null,"clients.devtools","clients.devtools",2282697598)));var chunk__10760_10764 = null;var count__10761_10765 = 0;var i__10762_10766 = 0;while(true){
if((i__10762_10766 < count__10761_10765))
{var o_10767 = cljs.core._nth.call(null,chunk__10760_10764,i__10762_10766);lt.object.raise.call(null,o_10767,new cljs.core.Keyword(null,"clear!","clear!",3951036134));
{
var G__10768 = seq__10759_10763;
var G__10769 = chunk__10760_10764;
var G__10770 = count__10761_10765;
var G__10771 = (i__10762_10766 + 1);
seq__10759_10763 = G__10768;
chunk__10760_10764 = G__10769;
count__10761_10765 = G__10770;
i__10762_10766 = G__10771;
continue;
}
} else
{var temp__4092__auto___10772 = cljs.core.seq.call(null,seq__10759_10763);if(temp__4092__auto___10772)
{var seq__10759_10773__$1 = temp__4092__auto___10772;if(cljs.core.chunked_seq_QMARK_.call(null,seq__10759_10773__$1))
{var c__4262__auto___10774 = cljs.core.chunk_first.call(null,seq__10759_10773__$1);{
var G__10775 = cljs.core.chunk_rest.call(null,seq__10759_10773__$1);
var G__10776 = c__4262__auto___10774;
var G__10777 = cljs.core.count.call(null,c__4262__auto___10774);
var G__10778 = 0;
seq__10759_10763 = G__10775;
chunk__10760_10764 = G__10776;
count__10761_10765 = G__10777;
i__10762_10766 = G__10778;
continue;
}
} else
{var o_10779 = cljs.core.first.call(null,seq__10759_10773__$1);lt.object.raise.call(null,o_10779,new cljs.core.Keyword(null,"clear!","clear!",3951036134));
{
var G__10780 = cljs.core.next.call(null,seq__10759_10773__$1);
var G__10781 = null;
var G__10782 = 0;
var G__10783 = 0;
seq__10759_10763 = G__10780;
chunk__10760_10764 = G__10781;
count__10761_10765 = G__10782;
i__10762_10766 = G__10783;
continue;
}
}
} else
{}
}
break;
}
return lt.objs.console.clear.call(null);
})], null));
