// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.plugins');
goog.require('cljs.core');
goog.require('crate.binding');
goog.require('lt.util.js');
goog.require('lt.objs.app');
goog.require('lt.objs.files');
goog.require('lt.objs.settings');
goog.require('clojure.walk');
goog.require('lt.util.js');
goog.require('lt.util.dom');
goog.require('lt.objs.context');
goog.require('lt.objs.platform');
goog.require('lt.objs.tabs');
goog.require('lt.objs.popup');
goog.require('lt.objs.popup');
goog.require('cljs.reader');
goog.require('crate.core');
goog.require('lt.objs.context');
goog.require('lt.objs.notifos');
goog.require('lt.objs.notifos');
goog.require('lt.util.dom');
goog.require('lt.objs.editor.pool');
goog.require('clojure.string');
goog.require('lt.util.kahn');
goog.require('clojure.walk');
goog.require('lt.objs.command');
goog.require('lt.objs.platform');
goog.require('lt.objs.files');
goog.require('clojure.set');
goog.require('lt.objs.settings');
goog.require('lt.objs.app');
goog.require('lt.util.kahn');
goog.require('lt.util.load');
goog.require('clojure.string');
goog.require('lt.objs.deploy');
goog.require('crate.binding');
goog.require('lt.object');
goog.require('cljs.reader');
goog.require('lt.object');
goog.require('clojure.set');
goog.require('lt.util.load');
goog.require('lt.objs.console');
goog.require('lt.objs.tabs');
goog.require('lt.objs.console');
goog.require('crate.core');
goog.require('lt.objs.editor.pool');
goog.require('lt.objs.command');
goog.require('fetch.core');
goog.require('lt.objs.deploy');
goog.require('fetch.core');
lt.objs.plugins.plugins_dir = lt.objs.files.lt_home.call(null,"plugins");
lt.objs.plugins.user_plugins_dir = lt.objs.files.lt_user_dir.call(null,"plugins");
lt.objs.plugins._STAR_plugin_dir_STAR_ = null;
lt.objs.plugins.EOF_read = (function EOF_read(s){if(cljs.core.truth_((function (){var and__3508__auto__ = s;if(cljs.core.truth_(and__3508__auto__))
{return cljs.core.seq.call(null,s);
} else
{return and__3508__auto__;
}
})()))
{return cljs.reader.read_string.call(null,s);
} else
{return null;
}
});
lt.objs.plugins.munge_plugin_name = (function munge_plugin_name(n){if(cljs.core.truth_(n))
{return clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,n," ","_"),"-","_"),".","_");
} else
{return null;
}
});
lt.objs.plugins.adjust_path = (function adjust_path(path){if(lt.objs.files.absolute_QMARK_.call(null,path))
{return path;
} else
{return lt.objs.files.join.call(null,(function (){var or__3520__auto__ = new cljs.core.Keyword("lt.objs.plugins","dir","lt.objs.plugins/dir",3366558592).cljs$core$IFn$_invoke$arity$1(lt.object._STAR_behavior_meta_STAR_);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return lt.objs.files.lt_home.call(null);
}
})(),path);
}
});
lt.objs.plugins.find_plugin = (function find_plugin(plugin_name){var plugin_name__$1 = lt.objs.plugins.munge_plugin_name.call(null,plugin_name);if(cljs.core.truth_(new cljs.core.Keyword("lt.objs.plugins","dir","lt.objs.plugins/dir",3366558592).cljs$core$IFn$_invoke$arity$1(lt.object._STAR_behavior_meta_STAR_)))
{return new cljs.core.Keyword("lt.objs.plugins","dir","lt.objs.plugins/dir",3366558592).cljs$core$IFn$_invoke$arity$1(lt.object._STAR_behavior_meta_STAR_);
} else
{if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,lt.objs.files.join.call(null,lt.objs.plugins.user_plugins_dir,plugin_name__$1))))
{return lt.objs.files.join.call(null,lt.objs.plugins.user_plugins_dir,plugin_name__$1);
} else
{if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,lt.objs.files.join.call(null,lt.objs.plugins.plugins_dir,plugin_name__$1))))
{return lt.objs.files.join.call(null,lt.objs.plugins.plugins_dir,plugin_name__$1);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return null;
} else
{return null;
}
}
}
}
});
lt.objs.plugins.local_module = (function local_module(plugin_name,module_name){var temp__4092__auto__ = lt.objs.plugins.find_plugin.call(null,plugin_name);if(cljs.core.truth_(temp__4092__auto__))
{var plugin_path = temp__4092__auto__;return lt.objs.files.join.call(null,plugin_path,"node_modules",module_name);
} else
{return null;
}
});
lt.objs.plugins.by_name = (function by_name(plugin_name){return cljs.core.get.call(null,new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.app.app)),plugin_name);
});
lt.objs.plugins.installed_QMARK_ = (function installed_QMARK_(plugin_name){return cljs.core.boolean$.call(null,lt.objs.plugins.by_name.call(null,plugin_name));
});
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"build","build",1107999200),new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: build file or project",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){var temp__4092__auto__ = lt.objs.editor.pool.last_active.call(null);if(cljs.core.truth_(temp__4092__auto__))
{var ed = temp__4092__auto__;return lt.object.raise.call(null,ed,new cljs.core.Keyword(null,"build","build",1107999200));
} else
{return null;
}
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"behaviors.force-reload","behaviors.force-reload",1611218586),new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugins: Ignore cache and force reload the current behaviors file",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){var temp__4092__auto__ = lt.objs.editor.pool.last_active.call(null);if(cljs.core.truth_(temp__4092__auto__))
{var ed = temp__4092__auto__;if(cljs.core.truth_(lt.object.has_tag_QMARK_.call(null,ed,new cljs.core.Keyword(null,"editor.behaviors","editor.behaviors",2095045778))))
{cljs.core.swap_BANG_.call(null,lt.objs.plugins.manager,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","force-reload","lt.objs.plugins/force-reload",4731263182)], null),(function (p1__11591_SHARP_){return cljs.core.conj.call(null,(function (){var or__3520__auto__ = p1__11591_SHARP_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentHashSet.EMPTY;
}
})(),cljs.core.get_in.call(null,cljs.core.deref.call(null,ed),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",1017141280),new cljs.core.Keyword(null,"path","path",1017337751)], null)));
}));
return lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"behaviors.reload","behaviors.reload",2942796600));
} else
{return null;
}
} else
{return null;
}
})], null));
lt.objs.plugins.validate = (function validate(plugin,filename){var valid_QMARK_ = cljs.core.every_QMARK_.call(null,plugin,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1017277949),new cljs.core.Keyword(null,"author","author",3902543101),new cljs.core.Keyword(null,"behaviors","behaviors",607554515),new cljs.core.Keyword(null,"desc","desc",1016984067)], null));if(!(valid_QMARK_))
{lt.objs.console.error.call(null,[cljs.core.str("Invalid "),cljs.core.str(filename),cljs.core.str(" file: "),cljs.core.str(new cljs.core.Keyword(null,"dir","dir",1014003711).cljs$core$IFn$_invoke$arity$1(plugin)),cljs.core.str("/"),cljs.core.str(filename),cljs.core.str("\nPlugins "),cljs.core.str("must include values for name, version, author, behaviors, and desc.")].join(''));
return null;
} else
{return plugin;
}
});
lt.objs.plugins.plugin_edn = (function plugin_edn(dir){var file = lt.objs.files.join.call(null,dir,"plugin.edn");var temp__4092__auto__ = (function (){var and__3508__auto__ = lt.objs.files.exists_QMARK_.call(null,file);if(cljs.core.truth_(and__3508__auto__))
{return lt.objs.files.open_sync.call(null,file);
} else
{return and__3508__auto__;
}
})();if(cljs.core.truth_(temp__4092__auto__))
{var content = temp__4092__auto__;try{return lt.objs.plugins.validate.call(null,cljs.core.assoc.call(null,lt.objs.plugins.EOF_read.call(null,new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(content)),new cljs.core.Keyword(null,"dir","dir",1014003711),dir),"plugin.edn");
}catch (e11593){var e = e11593;return lt.objs.console.error.call(null,[cljs.core.str("FAILED to load plugin.edn: "),cljs.core.str(dir)].join(''));
}} else
{return null;
}
});
lt.objs.plugins.plugin_json = (function plugin_json(dir){var file = lt.objs.files.join.call(null,dir,"plugin.json");var temp__4092__auto__ = (function (){var and__3508__auto__ = lt.objs.files.exists_QMARK_.call(null,file);if(cljs.core.truth_(and__3508__auto__))
{return lt.objs.files.open_sync.call(null,file);
} else
{return and__3508__auto__;
}
})();if(cljs.core.truth_(temp__4092__auto__))
{var content = temp__4092__auto__;return lt.objs.plugins.validate.call(null,cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,JSON.parse(new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(content)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",4191781672),true),new cljs.core.Keyword(null,"dir","dir",1014003711),dir),"plugin.json");
} else
{return null;
}
});
lt.objs.plugins.plugin_info = (function plugin_info(dir){var or__3520__auto__ = lt.objs.plugins.plugin_json.call(null,dir);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return lt.objs.plugins.plugin_edn.call(null,dir);
}
});
lt.objs.plugins.missing_deps = (function missing_deps(all){var deps = cljs.core.mapcat.call(null,cljs.core.comp.call(null,cljs.core.seq,new cljs.core.Keyword(null,"dependencies","dependencies",1517678747)),cljs.core.vals.call(null,all));return cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (final$,p__11596){var vec__11597 = p__11596;var name = cljs.core.nth.call(null,vec__11597,0,null);var version = cljs.core.nth.call(null,vec__11597,1,null);var name__$1 = cljs.core.name.call(null,name);var temp__4090__auto__ = (function (){var or__3520__auto__ = cljs.core.get.call(null,all,name__$1);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.get.call(null,final$,name__$1);
}
})();if(cljs.core.truth_(temp__4090__auto__))
{var cur = temp__4090__auto__;if(lt.objs.deploy.is_newer_QMARK_.call(null,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(cur),version))
{return cljs.core.assoc_BANG_.call(null,final$,name__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1017277949),name__$1,new cljs.core.Keyword(null,"version","version",1365512266),version], null));
} else
{return final$;
}
} else
{return cljs.core.assoc_BANG_.call(null,final$,name__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1017277949),name__$1,new cljs.core.Keyword(null,"version","version",1365512266),version], null));
}
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),deps))));
});
lt.objs.plugins.outdated_QMARK_ = (function outdated_QMARK_(plugin){var cached = new cljs.core.Keyword(null,"latest-version","latest-version",1676217348).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.plugins.manager)),new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin)));if(cljs.core.truth_(cached))
{return lt.objs.deploy.is_newer_QMARK_.call(null,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin),cached);
} else
{return null;
}
});
lt.objs.plugins.plugin_behaviors = (function plugin_behaviors(plug){if(cljs.core.seq.call(null,plug))
{try{var map__11601 = plug;var map__11601__$1 = ((cljs.core.seq_QMARK_.call(null,map__11601))?cljs.core.apply.call(null,cljs.core.hash_map,map__11601):map__11601);var dir = cljs.core.get.call(null,map__11601__$1,new cljs.core.Keyword(null,"dir","dir",1014003711));var behaviors = cljs.core.get.call(null,map__11601__$1,new cljs.core.Keyword(null,"behaviors","behaviors",607554515));var file = lt.objs.files.join.call(null,dir,behaviors);var file__$1 = lt.objs.files.real_path.call(null,file);var behs = lt.objs.settings.parse_file.call(null,file__$1);var force_QMARK_ = cljs.core.get.call(null,new cljs.core.Keyword("lt.objs.plugins","force-reload","lt.objs.plugins/force-reload",4731263182).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.plugins.manager)),file__$1);if(cljs.core.truth_(force_QMARK_))
{cljs.core.swap_BANG_.call(null,lt.objs.plugins.manager,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","force-reload","lt.objs.plugins/force-reload",4731263182)], null),cljs.core.disj,file__$1);
} else
{}
if(cljs.core.truth_(behs))
{clojure.walk.prewalk.call(null,(function (x){if(cljs.core.coll_QMARK_.call(null,x))
{cljs.core.alter_meta_BANG_.call(null,x,cljs.core.assoc,new cljs.core.Keyword("lt.objs.plugins","dir","lt.objs.plugins/dir",3366558592),dir,new cljs.core.Keyword("lt.objs.plugins","force-reload","lt.objs.plugins/force-reload",4731263182),force_QMARK_);
} else
{}
return x;
}),behs);
return behs;
} else
{return null;
}
}catch (e11600){var e = e11600;lt.objs.console.error.call(null,[cljs.core.str("Could not load behaviors for plugin: "),cljs.core.str(new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plug))].join(''));
return cljs.core.PersistentArrayMap.EMPTY;
}} else
{return null;
}
});
lt.objs.plugins.plugin_dependency_graph = (function plugin_dependency_graph(plugins){return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4231__auto__ = (function iter__11610(s__11611){return (new cljs.core.LazySeq(null,(function (){var s__11611__$1 = s__11611;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__11611__$1);if(temp__4092__auto__)
{var s__11611__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__11611__$2))
{var c__4229__auto__ = cljs.core.chunk_first.call(null,s__11611__$2);var size__4230__auto__ = cljs.core.count.call(null,c__4229__auto__);var b__11613 = cljs.core.chunk_buffer.call(null,size__4230__auto__);if((function (){var i__11612 = 0;while(true){
if((i__11612 < size__4230__auto__))
{var vec__11616 = cljs.core._nth.call(null,c__4229__auto__,i__11612);var nme = cljs.core.nth.call(null,vec__11616,0,null);var v = cljs.core.nth.call(null,vec__11616,1,null);cljs.core.chunk_append.call(null,b__11613,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nme,cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.name,cljs.core.keys.call(null,new cljs.core.Keyword(null,"dependencies","dependencies",1517678747).cljs$core$IFn$_invoke$arity$1(v))))], null));
{
var G__11618 = (i__11612 + 1);
i__11612 = G__11618;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11613),iter__11610.call(null,cljs.core.chunk_rest.call(null,s__11611__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11613),null);
}
} else
{var vec__11617 = cljs.core.first.call(null,s__11611__$2);var nme = cljs.core.nth.call(null,vec__11617,0,null);var v = cljs.core.nth.call(null,vec__11617,1,null);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nme,cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.name,cljs.core.keys.call(null,new cljs.core.Keyword(null,"dependencies","dependencies",1517678747).cljs$core$IFn$_invoke$arity$1(v))))], null),iter__11610.call(null,cljs.core.rest.call(null,s__11611__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4231__auto__.call(null,plugins);
})());
});
lt.objs.plugins.find_cycles = (function find_cycles(cur,p__11619){var map__11625 = p__11619;var map__11625__$1 = ((cljs.core.seq_QMARK_.call(null,map__11625))?cljs.core.apply.call(null,cljs.core.hash_map,map__11625):map__11625);var state = map__11625__$1;var graph = cljs.core.get.call(null,map__11625__$1,new cljs.core.Keyword(null,"graph","graph",1112519872));var stack = cljs.core.get.call(null,map__11625__$1,new cljs.core.Keyword(null,"stack","stack",1123661306));var root = cljs.core.get.call(null,map__11625__$1,new cljs.core.Keyword(null,"root","root",1017410644));var seen = cljs.core.get.call(null,map__11625__$1,new cljs.core.Keyword(null,"seen","seen",1017430509));return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,(function (){var iter__4231__auto__ = (function iter__11626(s__11627){return (new cljs.core.LazySeq(null,(function (){var s__11627__$1 = s__11627;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__11627__$1);if(temp__4092__auto__)
{var s__11627__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__11627__$2))
{var c__4229__auto__ = cljs.core.chunk_first.call(null,s__11627__$2);var size__4230__auto__ = cljs.core.count.call(null,c__4229__auto__);var b__11629 = cljs.core.chunk_buffer.call(null,size__4230__auto__);if((function (){var i__11628 = 0;while(true){
if((i__11628 < size__4230__auto__))
{var c = cljs.core._nth.call(null,c__4229__auto__,i__11628);cljs.core.chunk_append.call(null,b__11629,((cljs.core._EQ_.call(null,c,root))?cljs.core.conj.call(null,stack,c):find_cycles.call(null,cljs.core.get.call(null,graph,c),cljs.core.update_in.call(null,cljs.core.update_in.call(null,state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"stack","stack",1123661306)], null),cljs.core.conj,c),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"seen","seen",1017430509)], null),cljs.core.conj,c))));
{
var G__11630 = (i__11628 + 1);
i__11628 = G__11630;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11629),iter__11626.call(null,cljs.core.chunk_rest.call(null,s__11627__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11629),null);
}
} else
{var c = cljs.core.first.call(null,s__11627__$2);return cljs.core.cons.call(null,((cljs.core._EQ_.call(null,c,root))?cljs.core.conj.call(null,stack,c):find_cycles.call(null,cljs.core.get.call(null,graph,c),cljs.core.update_in.call(null,cljs.core.update_in.call(null,state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"stack","stack",1123661306)], null),cljs.core.conj,c),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"seen","seen",1017430509)], null),cljs.core.conj,c))),iter__11626.call(null,cljs.core.rest.call(null,s__11627__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4231__auto__.call(null,cljs.core.remove.call(null,seen,cur));
})()));
});
lt.objs.plugins.__GT_cycles = (function __GT_cycles(graph){return cljs.core.filterv.call(null,cljs.core.identity,(function (){var iter__4231__auto__ = (function iter__11639(s__11640){return (new cljs.core.LazySeq(null,(function (){var s__11640__$1 = s__11640;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__11640__$1);if(temp__4092__auto__)
{var s__11640__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__11640__$2))
{var c__4229__auto__ = cljs.core.chunk_first.call(null,s__11640__$2);var size__4230__auto__ = cljs.core.count.call(null,c__4229__auto__);var b__11642 = cljs.core.chunk_buffer.call(null,size__4230__auto__);if((function (){var i__11641 = 0;while(true){
if((i__11641 < size__4230__auto__))
{var vec__11645 = cljs.core._nth.call(null,c__4229__auto__,i__11641);var root = cljs.core.nth.call(null,vec__11645,0,null);var deps = cljs.core.nth.call(null,vec__11645,1,null);var stack = lt.objs.plugins.find_cycles.call(null,deps,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"seen","seen",1017430509),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"stack","stack",1123661306),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),new cljs.core.Keyword(null,"graph","graph",1112519872),graph,new cljs.core.Keyword(null,"root","root",1017410644),root], null));cljs.core.chunk_append.call(null,b__11642,stack);
{
var G__11647 = (i__11641 + 1);
i__11641 = G__11647;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11642),iter__11639.call(null,cljs.core.chunk_rest.call(null,s__11640__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11642),null);
}
} else
{var vec__11646 = cljs.core.first.call(null,s__11640__$2);var root = cljs.core.nth.call(null,vec__11646,0,null);var deps = cljs.core.nth.call(null,vec__11646,1,null);var stack = lt.objs.plugins.find_cycles.call(null,deps,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"seen","seen",1017430509),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"stack","stack",1123661306),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),new cljs.core.Keyword(null,"graph","graph",1112519872),graph,new cljs.core.Keyword(null,"root","root",1017410644),root], null));return cljs.core.cons.call(null,stack,iter__11639.call(null,cljs.core.rest.call(null,s__11640__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4231__auto__.call(null,graph);
})());
});
lt.objs.plugins.cycle_desc = (function cycle_desc(cycles){var iter__4231__auto__ = (function iter__11652(s__11653){return (new cljs.core.LazySeq(null,(function (){var s__11653__$1 = s__11653;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__11653__$1);if(temp__4092__auto__)
{var s__11653__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__11653__$2))
{var c__4229__auto__ = cljs.core.chunk_first.call(null,s__11653__$2);var size__4230__auto__ = cljs.core.count.call(null,c__4229__auto__);var b__11655 = cljs.core.chunk_buffer.call(null,size__4230__auto__);if((function (){var i__11654 = 0;while(true){
if((i__11654 < size__4230__auto__))
{var cycle = cljs.core._nth.call(null,c__4229__auto__,i__11654);cljs.core.chunk_append.call(null,b__11655,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1014003715),cljs.core.reduce.call(null,cljs.core.str,cljs.core.interpose.call(null," => ",cycle))], null));
{
var G__11656 = (i__11654 + 1);
i__11654 = G__11656;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11655),iter__11652.call(null,cljs.core.chunk_rest.call(null,s__11653__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11655),null);
}
} else
{var cycle = cljs.core.first.call(null,s__11653__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1014003715),cljs.core.reduce.call(null,cljs.core.str,cljs.core.interpose.call(null," => ",cycle))], null),iter__11652.call(null,cljs.core.rest.call(null,s__11653__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4231__auto__.call(null,cycles);
});
lt.objs.plugins.metadata_commits = "https://api.github.com/repos/LightTable/plugin-metadata/commits";
lt.objs.plugins.metadata_download = "https://api.github.com/repos/LightTable/plugin-metadata/tarball/master";
lt.objs.plugins.metadata_dir = lt.objs.files.lt_user_dir.call(null,"metadata");
lt.objs.plugins.metadata_cache = lt.objs.files.join.call(null,lt.objs.plugins.metadata_dir,"cache.json");
lt.objs.plugins.version_sort = (function version_sort(a,b){if(cljs.core._EQ_.call(null,a,b))
{return 0;
} else
{if(lt.objs.deploy.is_newer_QMARK_.call(null,a,b))
{return -1;
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return 1;
} else
{return null;
}
}
}
});
lt.objs.plugins.build_cache = (function build_cache(sha){var items = cljs.core.filter.call(null,lt.objs.files.dir_QMARK_,lt.objs.files.full_path_ls.call(null,lt.objs.plugins.metadata_dir));var cache = cljs.core.into.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"__sha","__sha",1104582718),sha], null),(function (){var iter__4231__auto__ = ((function (items){
return (function iter__11661(s__11662){return (new cljs.core.LazySeq(null,((function (items){
return (function (){var s__11662__$1 = s__11662;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__11662__$1);if(temp__4092__auto__)
{var s__11662__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__11662__$2))
{var c__4229__auto__ = cljs.core.chunk_first.call(null,s__11662__$2);var size__4230__auto__ = cljs.core.count.call(null,c__4229__auto__);var b__11664 = cljs.core.chunk_buffer.call(null,size__4230__auto__);if((function (){var i__11663 = 0;while(true){
if((i__11663 < size__4230__auto__))
{var plugin = cljs.core._nth.call(null,c__4229__auto__,i__11663);var versions = cljs.core.vec.call(null,cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"version","version",1365512266),lt.objs.plugins.version_sort,cljs.core.map.call(null,lt.objs.plugins.plugin_info,cljs.core.filter.call(null,lt.objs.files.dir_QMARK_,lt.objs.files.full_path_ls.call(null,plugin)))));var latest = cljs.core.last.call(null,versions);cljs.core.chunk_append.call(null,b__11664,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(latest),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"versions","versions",3323818509),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"version","version",1365512266),cljs.core.identity),versions)),new cljs.core.Keyword(null,"latest-version","latest-version",1676217348),new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(latest)], null)], null));
{
var G__11665 = (i__11663 + 1);
i__11663 = G__11665;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11664),iter__11661.call(null,cljs.core.chunk_rest.call(null,s__11662__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11664),null);
}
} else
{var plugin = cljs.core.first.call(null,s__11662__$2);var versions = cljs.core.vec.call(null,cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"version","version",1365512266),lt.objs.plugins.version_sort,cljs.core.map.call(null,lt.objs.plugins.plugin_info,cljs.core.filter.call(null,lt.objs.files.dir_QMARK_,lt.objs.files.full_path_ls.call(null,plugin)))));var latest = cljs.core.last.call(null,versions);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(latest),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"versions","versions",3323818509),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"version","version",1365512266),cljs.core.identity),versions)),new cljs.core.Keyword(null,"latest-version","latest-version",1676217348),new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(latest)], null)], null),iter__11661.call(null,cljs.core.rest.call(null,s__11662__$2)));
}
} else
{return null;
}
break;
}
});})(items))
,null,null));
});})(items))
;return iter__4231__auto__.call(null,items);
})());return cache;
});
lt.objs.plugins.save_cache = (function save_cache(cache){return lt.objs.files.save.call(null,lt.objs.plugins.metadata_cache,JSON.stringify(cljs.core.clj__GT_js.call(null,cache)));
});
lt.objs.plugins.latest_metadata_sha = (function latest_metadata_sha(){return fetch.core.xhr.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"get","get",1014006472),lt.objs.plugins.metadata_commits], null),cljs.core.PersistentArrayMap.EMPTY,(function (data){var temp__4092__auto__ = (function (){try{return JSON.parse(data);
}catch (e11667){var e = e11667;return lt.objs.console.error.call(null,[cljs.core.str("Invalid JSON response from "),cljs.core.str(lt.objs.plugins.metadata_commits),cljs.core.str(": "),cljs.core.str(cljs.core.pr_str.call(null,data))].join(''));
}})();if(cljs.core.truth_(temp__4092__auto__))
{var parsed = temp__4092__auto__;var sha = ((parsed[0])["sha"]);return lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"metadata.sha","metadata.sha",2333336799),sha);
} else
{return null;
}
}));
});
lt.objs.plugins.download_metadata = (function download_metadata(sha){var tmp_gz = lt.objs.files.lt_user_dir.call(null,"metadata-temp.tar.gz");var tmp_dir = lt.objs.files.lt_user_dir.call(null,"metadata-temp");lt.objs.notifos.working.call(null,"Updating plugin metadata");
return lt.objs.deploy.download_file.call(null,lt.objs.plugins.metadata_download,tmp_gz,(function (){return lt.objs.deploy.untar.call(null,tmp_gz,tmp_dir,(function (){lt.objs.notifos.done_working.call(null);
var munged_dir = cljs.core.first.call(null,lt.objs.files.full_path_ls.call(null,tmp_dir));if(cljs.core.truth_(munged_dir))
{if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,lt.objs.plugins.metadata_dir)))
{lt.objs.files.delete_BANG_.call(null,lt.objs.plugins.metadata_dir);
} else
{}
lt.objs.files.move_BANG_.call(null,munged_dir,lt.objs.plugins.metadata_dir);
} else
{}
lt.objs.files.delete_BANG_.call(null,tmp_dir);
lt.objs.files.delete_BANG_.call(null,tmp_gz);
if(cljs.core.truth_(munged_dir))
{lt.objs.plugins.save_cache.call(null,lt.objs.plugins.build_cache.call(null,sha));
lt.objs.notifos.done_working.call(null,[cljs.core.str("Plugin metadata updated. ")].join(''));
return lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"metadata.updated","metadata.updated",1526644846));
} else
{return lt.objs.plugins.install_failed.call(null,"metadata");
}
}));
}));
});
lt.objs.plugins.read_cache = (function read_cache(){if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,lt.objs.plugins.metadata_cache)))
{return cljs.core.js__GT_clj.call(null,JSON.parse(new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(lt.objs.files.open_sync.call(null,lt.objs.plugins.metadata_cache))),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",4191781672),true);
} else
{return null;
}
});
lt.objs.plugins.search_plugins = (function search_plugins(plugins,search){var search__$1 = search.toLowerCase();return cljs.core.filter.call(null,(function (plugin){return ((new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$2(plugin,"").toLowerCase().indexOf(search__$1) > -1)) || ((new cljs.core.Keyword(null,"author","author",3902543101).cljs$core$IFn$_invoke$arity$2(plugin,"").toLowerCase().indexOf(search__$1) > -1)) || ((new cljs.core.Keyword(null,"desc","desc",1016984067).cljs$core$IFn$_invoke$arity$2(plugin,"").toLowerCase().indexOf(search__$1) > -1));
}),plugins);
});
lt.objs.plugins.latest_version_merge = (function latest_version_merge(neue,old){var neue__$1 = cljs.core.seq.call(null,neue);return cljs.core.reduce.call(null,(function (final$,p__11670){var vec__11671 = p__11670;var name = cljs.core.nth.call(null,vec__11671,0,null);var ver = cljs.core.nth.call(null,vec__11671,1,null);var temp__4090__auto__ = new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(final$.call(null,name));if(cljs.core.truth_(temp__4090__auto__))
{var cur_ver = temp__4090__auto__;if(lt.objs.deploy.is_newer_QMARK_.call(null,ver,cur_ver))
{return cljs.core.assoc.call(null,final$,name,ver);
} else
{return final$;
}
} else
{return cljs.core.assoc.call(null,final$,name,ver);
}
}),old,neue__$1);
});
lt.objs.plugins.transitive_deps = (function transitive_deps(plugins,p__11672,seen){var vec__11674 = p__11672;var name = cljs.core.nth.call(null,vec__11674,0,null);var ver = cljs.core.nth.call(null,vec__11674,1,null);var name__$1 = cljs.core.keyword.call(null,name);var temp__4090__auto__ = cljs.core.get_in.call(null,plugins,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1,new cljs.core.Keyword(null,"versions","versions",3323818509),cljs.core.keyword.call(null,ver)], null));if(cljs.core.truth_(temp__4090__auto__))
{var cur = temp__4090__auto__;var deps = new cljs.core.Keyword(null,"dependencies","dependencies",1517678747).cljs$core$IFn$_invoke$arity$1(cur);var unique = cljs.core.remove.call(null,seen,cljs.core.keys.call(null,deps));var seen__$1 = lt.objs.plugins.latest_version_merge.call(null,new cljs.core.PersistentArrayMap.fromArray([name__$1,cur], true, false),seen);return cljs.core.reduce.call(null,(function (seen__$2,cur__$1){return transitive_deps.call(null,plugins,cur__$1,seen__$2);
}),seen__$1,cljs.core.select_keys.call(null,deps,unique));
} else
{return seen;
}
});
lt.objs.plugins.latest_version = (function latest_version(plugin){return cljs.core.get.call(null,new cljs.core.Keyword(null,"versions","versions",3323818509).cljs$core$IFn$_invoke$arity$1(plugin),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"latest-version","latest-version",1676217348).cljs$core$IFn$_invoke$arity$1(plugin)));
});
lt.objs.plugins.all_latest = (function all_latest(plugins){return cljs.core.map.call(null,lt.objs.plugins.latest_version,cljs.core.vals.call(null,cljs.core.dissoc.call(null,plugins,new cljs.core.Keyword(null,"__sha","__sha",1104582718))));
});
lt.objs.plugins.install_failed = (function install_failed(name){if(cljs.core.truth_((function (){var and__3508__auto__ = lt.objs.plugins.by_name.call(null,name);if(cljs.core.truth_(and__3508__auto__))
{return cljs.core.not.call(null,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(lt.objs.plugins.by_name.call(null,name)));
} else
{return and__3508__auto__;
}
})()))
{lt.object.update_BANG_.call(null,lt.objs.app.app,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683)], null),cljs.core.dissoc,name);
} else
{}
return lt.objs.notifos.done_working.call(null,[cljs.core.str("Plugin install failed for: "),cljs.core.str(name)].join(''));
});
lt.objs.plugins.plugin__GT_tar = (function plugin__GT_tar(plugin){var vec__11677 = cljs.core.take.call(null,2,cljs.core.filter.call(null,(function (p1__11675_SHARP_){return cljs.core.not_EQ_.call(null,p1__11675_SHARP_,"");
}),cljs.core.reverse.call(null,clojure.string.split.call(null,new cljs.core.Keyword(null,"source","source",4412365709).cljs$core$IFn$_invoke$arity$1(plugin),"/"))));var repo = cljs.core.nth.call(null,vec__11677,0,null);var username = cljs.core.nth.call(null,vec__11677,1,null);var repo__$1 = repo.replace(/.git/,"");return [cljs.core.str("https://api.github.com/repos/"),cljs.core.str(username),cljs.core.str("/"),cljs.core.str(repo__$1),cljs.core.str("/tarball/"),cljs.core.str(new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin))].join('');
});
lt.objs.plugins.fetch_and_install = (function fetch_and_install(url,name,cb){var munged_name = lt.objs.plugins.munge_plugin_name.call(null,name);var tmp_gz = [cljs.core.str(lt.objs.plugins.user_plugins_dir),cljs.core.str("/"),cljs.core.str(munged_name),cljs.core.str("-tmp.tar.gz")].join('');var tmp_dir = [cljs.core.str(lt.objs.plugins.user_plugins_dir),cljs.core.str("/"),cljs.core.str(munged_name),cljs.core.str("-tmp")].join('');lt.objs.notifos.working.call(null,[cljs.core.str("Downloading plugin: "),cljs.core.str(name)].join(''));
return lt.objs.deploy.download_file.call(null,url,tmp_gz,(function (){lt.objs.notifos.done_working.call(null);
lt.objs.notifos.working.call(null,"Extracting plugin...");
return lt.objs.deploy.untar.call(null,tmp_gz,tmp_dir,(function (){var munged_dir = cljs.core.first.call(null,lt.objs.files.full_path_ls.call(null,tmp_dir));var final_path = [cljs.core.str(lt.objs.plugins.user_plugins_dir),cljs.core.str("/"),cljs.core.str(munged_name),cljs.core.str("/")].join('');if(cljs.core.truth_(munged_dir))
{if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,final_path)))
{lt.objs.files.delete_BANG_.call(null,final_path);
} else
{}
lt.objs.files.move_BANG_.call(null,munged_dir,final_path);
} else
{}
lt.objs.files.delete_BANG_.call(null,tmp_dir);
lt.objs.files.delete_BANG_.call(null,tmp_gz);
if(cljs.core.truth_(munged_dir))
{lt.objs.notifos.done_working.call(null,[cljs.core.str("Plugin fetched: "),cljs.core.str(name)].join(''));
lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"plugin.fetched","plugin.fetched",1905646736));
if(cljs.core.truth_(cb))
{return cb.call(null);
} else
{return null;
}
} else
{return lt.objs.plugins.install_failed.call(null,name);
}
}));
}));
});
lt.objs.plugins.install_version = (function install_version(plugin,cb){var name = new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin);var ver = new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin);var installed_QMARK_ = cljs.core.get.call(null,new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.app.app)),name);if(cljs.core.truth_((function (){var or__3520__auto__ = cljs.core.not.call(null,installed_QMARK_);if(or__3520__auto__)
{return or__3520__auto__;
} else
{var and__3508__auto__ = new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(installed_QMARK_);if(cljs.core.truth_(and__3508__auto__))
{return lt.objs.deploy.is_newer_QMARK_.call(null,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(installed_QMARK_),ver);
} else
{return and__3508__auto__;
}
}
})()))
{lt.object.update_BANG_.call(null,lt.objs.app.app,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683)], null),cljs.core.assoc,name,cljs.core.PersistentArrayMap.EMPTY);
return lt.objs.plugins.fetch_and_install.call(null,lt.objs.plugins.plugin__GT_tar.call(null,plugin),name,(function (){if(cljs.core.truth_(cb))
{return cb.call(null,true);
} else
{return null;
}
}));
} else
{lt.objs.notifos.set_msg_BANG_.call(null,[cljs.core.str(name),cljs.core.str(" is already installed")].join(''));
if(cljs.core.truth_(cb))
{return cb.call(null,false);
} else
{return null;
}
}
});
lt.objs.plugins.transitive_install = (function transitive_install(plugin,deps,cb){var cur = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin));var others = cljs.core.dissoc.call(null,deps,cur);var counter = cljs.core.atom.call(null,cljs.core.count.call(null,others));var count_down = ((function (cur,others,counter){
return (function (){cljs.core.swap_BANG_.call(null,counter,cljs.core.dec);
if((cljs.core.deref.call(null,counter) <= 0))
{return lt.objs.plugins.install_version.call(null,deps.call(null,cur),((function (cur,others,counter){
return (function (installed_QMARK_){if(cljs.core.truth_(cb))
{return cb.call(null,installed_QMARK_);
} else
{return null;
}
});})(cur,others,counter))
);
} else
{return null;
}
});})(cur,others,counter))
;if(cljs.core.seq.call(null,others))
{var seq__11684 = cljs.core.seq.call(null,others);var chunk__11685 = null;var count__11686 = 0;var i__11687 = 0;while(true){
if((i__11687 < count__11686))
{var vec__11688 = cljs.core._nth.call(null,chunk__11685,i__11687);var _ = cljs.core.nth.call(null,vec__11688,0,null);var dep = cljs.core.nth.call(null,vec__11688,1,null);lt.objs.plugins.install_version.call(null,dep,count_down);
{
var G__11690 = seq__11684;
var G__11691 = chunk__11685;
var G__11692 = count__11686;
var G__11693 = (i__11687 + 1);
seq__11684 = G__11690;
chunk__11685 = G__11691;
count__11686 = G__11692;
i__11687 = G__11693;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__11684);if(temp__4092__auto__)
{var seq__11684__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11684__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__11684__$1);{
var G__11694 = cljs.core.chunk_rest.call(null,seq__11684__$1);
var G__11695 = c__4262__auto__;
var G__11696 = cljs.core.count.call(null,c__4262__auto__);
var G__11697 = 0;
seq__11684 = G__11694;
chunk__11685 = G__11695;
count__11686 = G__11696;
i__11687 = G__11697;
continue;
}
} else
{var vec__11689 = cljs.core.first.call(null,seq__11684__$1);var _ = cljs.core.nth.call(null,vec__11689,0,null);var dep = cljs.core.nth.call(null,vec__11689,1,null);lt.objs.plugins.install_version.call(null,dep,count_down);
{
var G__11698 = cljs.core.next.call(null,seq__11684__$1);
var G__11699 = null;
var G__11700 = 0;
var G__11701 = 0;
seq__11684 = G__11698;
chunk__11685 = G__11699;
count__11686 = G__11700;
i__11687 = G__11701;
continue;
}
}
} else
{return null;
}
}
break;
}
} else
{return count_down.call(null);
}
});
lt.objs.plugins.discover_deps = (function discover_deps(plugin,cb){var deps = lt.objs.plugins.transitive_deps.call(null,new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.plugins.manager)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin),new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin)], null),cljs.core.PersistentArrayMap.EMPTY);if(cljs.core.not.call(null,cljs.core.seq.call(null,deps)))
{return lt.objs.plugins.install_failed.call(null,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin));
} else
{return lt.objs.plugins.transitive_install.call(null,plugin,deps,cb);
}
});
lt.objs.plugins.install_missing = (function install_missing(missing){var counter = cljs.core.atom.call(null,cljs.core.count.call(null,missing));var count_down = ((function (counter){
return (function (){cljs.core.swap_BANG_.call(null,counter,cljs.core.dec);
if((cljs.core.deref.call(null,counter) <= 0))
{lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"behaviors.reload","behaviors.reload",2942796600));
lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"refresh!","refresh!",4597922840));
return lt.objs.notifos.set_msg_BANG_.call(null,"All missing dependencies installed.");
} else
{return null;
}
});})(counter))
;var seq__11706 = cljs.core.seq.call(null,missing);var chunk__11707 = null;var count__11708 = 0;var i__11709 = 0;while(true){
if((i__11709 < count__11708))
{var dep = cljs.core._nth.call(null,chunk__11707,i__11709);lt.objs.plugins.discover_deps.call(null,dep,count_down);
{
var G__11710 = seq__11706;
var G__11711 = chunk__11707;
var G__11712 = count__11708;
var G__11713 = (i__11709 + 1);
seq__11706 = G__11710;
chunk__11707 = G__11711;
count__11708 = G__11712;
i__11709 = G__11713;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__11706);if(temp__4092__auto__)
{var seq__11706__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11706__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__11706__$1);{
var G__11714 = cljs.core.chunk_rest.call(null,seq__11706__$1);
var G__11715 = c__4262__auto__;
var G__11716 = cljs.core.count.call(null,c__4262__auto__);
var G__11717 = 0;
seq__11706 = G__11714;
chunk__11707 = G__11715;
count__11708 = G__11716;
i__11709 = G__11717;
continue;
}
} else
{var dep = cljs.core.first.call(null,seq__11706__$1);lt.objs.plugins.discover_deps.call(null,dep,count_down);
{
var G__11718 = cljs.core.next.call(null,seq__11706__$1);
var G__11719 = null;
var G__11720 = 0;
var G__11721 = 0;
seq__11706 = G__11718;
chunk__11707 = G__11719;
count__11708 = G__11720;
i__11709 = G__11721;
continue;
}
}
} else
{return null;
}
}
break;
}
});
/**
* Check a plugins map for outdated or missing :dependencies and prompt
* to install missing ones
*/
lt.objs.plugins.check_missing = (function check_missing(deps){var temp__4092__auto__ = lt.objs.plugins.missing_deps.call(null,deps);if(temp__4092__auto__)
{var missing_QMARK_ = temp__4092__auto__;return lt.objs.popup.popup_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",4087600639),"Some plugin dependencies are missing.",new cljs.core.Keyword(null,"body","body",1016933652),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1014003715),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1017440956),"We found that the following plugin dependencies are missing: "], null),(function (){var iter__4231__auto__ = (function iter__11730(s__11731){return (new cljs.core.LazySeq(null,(function (){var s__11731__$1 = s__11731;while(true){
var temp__4092__auto____$1 = cljs.core.seq.call(null,s__11731__$1);if(temp__4092__auto____$1)
{var s__11731__$2 = temp__4092__auto____$1;if(cljs.core.chunked_seq_QMARK_.call(null,s__11731__$2))
{var c__4229__auto__ = cljs.core.chunk_first.call(null,s__11731__$2);var size__4230__auto__ = cljs.core.count.call(null,c__4229__auto__);var b__11733 = cljs.core.chunk_buffer.call(null,size__4230__auto__);if((function (){var i__11732 = 0;while(true){
if((i__11732 < size__4230__auto__))
{var map__11736 = cljs.core._nth.call(null,c__4229__auto__,i__11732);var map__11736__$1 = ((cljs.core.seq_QMARK_.call(null,map__11736))?cljs.core.apply.call(null,cljs.core.hash_map,map__11736):map__11736);var version = cljs.core.get.call(null,map__11736__$1,new cljs.core.Keyword(null,"version","version",1365512266));var name = cljs.core.get.call(null,map__11736__$1,new cljs.core.Keyword(null,"name","name",1017277949));cljs.core.chunk_append.call(null,b__11733,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1014003715),name," ",version," "], null));
{
var G__11738 = (i__11732 + 1);
i__11732 = G__11738;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11733),iter__11730.call(null,cljs.core.chunk_rest.call(null,s__11731__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11733),null);
}
} else
{var map__11737 = cljs.core.first.call(null,s__11731__$2);var map__11737__$1 = ((cljs.core.seq_QMARK_.call(null,map__11737))?cljs.core.apply.call(null,cljs.core.hash_map,map__11737):map__11737);var version = cljs.core.get.call(null,map__11737__$1,new cljs.core.Keyword(null,"version","version",1365512266));var name = cljs.core.get.call(null,map__11737__$1,new cljs.core.Keyword(null,"name","name",1017277949));return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1014003715),name," ",version," "], null),iter__11730.call(null,cljs.core.rest.call(null,s__11731__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4231__auto__.call(null,missing_QMARK_);
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1017440956),"Would you like us to install them?"], null)], null),new cljs.core.Keyword(null,"buttons","buttons",1255256819),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"Cancel"], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Install all",new cljs.core.Keyword(null,"action","action",3885920680),(function (){return lt.objs.plugins.install_missing.call(null,missing_QMARK_);
})], null)], null)], null));
} else
{return null;
}
});
/**
* Return a map of plugins by plugin name based on what's read from filesystem
*/
lt.objs.plugins.available_plugins = (function available_plugins(){var ds = cljs.core.concat.call(null,lt.objs.files.dirs.call(null,lt.objs.plugins.user_plugins_dir),lt.objs.files.dirs.call(null,lt.objs.plugins.plugins_dir),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lt.objs.settings.user_plugin_dir], null));var plugins = cljs.core.filterv.call(null,cljs.core.identity,cljs.core.map.call(null,lt.objs.plugins.plugin_info,ds));return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (final$,p){var temp__4090__auto__ = cljs.core.get.call(null,final$,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(p));if(cljs.core.truth_(temp__4090__auto__))
{var cur = temp__4090__auto__;if(lt.objs.deploy.is_newer_QMARK_.call(null,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(cur),new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(p)))
{return cljs.core.assoc_BANG_.call(null,final$,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(p),p);
} else
{return final$;
}
} else
{return cljs.core.assoc_BANG_.call(null,final$,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(p),p);
}
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),plugins));
});
lt.objs.plugins.uninstall = (function uninstall(plugin){if(cljs.core.truth_(new cljs.core.Keyword(null,"dir","dir",1014003711).cljs$core$IFn$_invoke$arity$1(plugin)))
{lt.objs.files.delete_BANG_.call(null,new cljs.core.Keyword(null,"dir","dir",1014003711).cljs$core$IFn$_invoke$arity$1(plugin));
lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"refresh!","refresh!",4597922840),new cljs.core.Keyword(null,"ignore-missing","ignore-missing",2124702685),true);
return lt.objs.notifos.set_msg_BANG_.call(null,[cljs.core.str("Uninstalled "),cljs.core.str(new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin)),cljs.core.str(" "),cljs.core.str(new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin))].join(''));
} else
{return null;
}
});
lt.objs.plugins.url_input = (function url_input(){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1017479852),"text",new cljs.core.Keyword(null,"placeholder","placeholder",1612151013),"Github URL"], null)], null));var seq__11745_11751 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",1111509066),(function (){return lt.objs.context.in_BANG_.call(null,new cljs.core.Keyword(null,"popup.input","popup.input",4788025210));
}),new cljs.core.Keyword(null,"blur","blur",1016931289),(function (){return lt.objs.context.out_BANG_.call(null,new cljs.core.Keyword(null,"popup.input","popup.input",4788025210));
})], null)));var chunk__11746_11752 = null;var count__11747_11753 = 0;var i__11748_11754 = 0;while(true){
if((i__11748_11754 < count__11747_11753))
{var vec__11749_11755 = cljs.core._nth.call(null,chunk__11746_11752,i__11748_11754);var ev__3326__auto___11756 = cljs.core.nth.call(null,vec__11749_11755,0,null);var func__3327__auto___11757 = cljs.core.nth.call(null,vec__11749_11755,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11756,func__3327__auto___11757);
{
var G__11758 = seq__11745_11751;
var G__11759 = chunk__11746_11752;
var G__11760 = count__11747_11753;
var G__11761 = (i__11748_11754 + 1);
seq__11745_11751 = G__11758;
chunk__11746_11752 = G__11759;
count__11747_11753 = G__11760;
i__11748_11754 = G__11761;
continue;
}
} else
{var temp__4092__auto___11762 = cljs.core.seq.call(null,seq__11745_11751);if(temp__4092__auto___11762)
{var seq__11745_11763__$1 = temp__4092__auto___11762;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11745_11763__$1))
{var c__4262__auto___11764 = cljs.core.chunk_first.call(null,seq__11745_11763__$1);{
var G__11765 = cljs.core.chunk_rest.call(null,seq__11745_11763__$1);
var G__11766 = c__4262__auto___11764;
var G__11767 = cljs.core.count.call(null,c__4262__auto___11764);
var G__11768 = 0;
seq__11745_11751 = G__11765;
chunk__11746_11752 = G__11766;
count__11747_11753 = G__11767;
i__11748_11754 = G__11768;
continue;
}
} else
{var vec__11750_11769 = cljs.core.first.call(null,seq__11745_11763__$1);var ev__3326__auto___11770 = cljs.core.nth.call(null,vec__11750_11769,0,null);var func__3327__auto___11771 = cljs.core.nth.call(null,vec__11750_11769,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11770,func__3327__auto___11771);
{
var G__11772 = cljs.core.next.call(null,seq__11745_11763__$1);
var G__11773 = null;
var G__11774 = 0;
var G__11775 = 0;
seq__11745_11751 = G__11772;
chunk__11746_11752 = G__11773;
count__11747_11753 = G__11774;
i__11748_11754 = G__11775;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.tab = (function tab(this$,tab_name,label){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",3931183780),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",1108647146),crate.binding.bound.call(null,this$,(function (p1__11776_SHARP_){if(cljs.core._EQ_.call(null,tab_name,new cljs.core.Keyword(null,"tab","tab",1014018823).cljs$core$IFn$_invoke$arity$1(p1__11776_SHARP_)))
{return "active";
} else
{return null;
}
}))], null),label], null));var seq__11783_11789 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"click","click",1108654330),(function (){return lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tab","tab",1014018823),tab_name], null));
})], null)));var chunk__11784_11790 = null;var count__11785_11791 = 0;var i__11786_11792 = 0;while(true){
if((i__11786_11792 < count__11785_11791))
{var vec__11787_11793 = cljs.core._nth.call(null,chunk__11784_11790,i__11786_11792);var ev__3326__auto___11794 = cljs.core.nth.call(null,vec__11787_11793,0,null);var func__3327__auto___11795 = cljs.core.nth.call(null,vec__11787_11793,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11794,func__3327__auto___11795);
{
var G__11796 = seq__11783_11789;
var G__11797 = chunk__11784_11790;
var G__11798 = count__11785_11791;
var G__11799 = (i__11786_11792 + 1);
seq__11783_11789 = G__11796;
chunk__11784_11790 = G__11797;
count__11785_11791 = G__11798;
i__11786_11792 = G__11799;
continue;
}
} else
{var temp__4092__auto___11800 = cljs.core.seq.call(null,seq__11783_11789);if(temp__4092__auto___11800)
{var seq__11783_11801__$1 = temp__4092__auto___11800;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11783_11801__$1))
{var c__4262__auto___11802 = cljs.core.chunk_first.call(null,seq__11783_11801__$1);{
var G__11803 = cljs.core.chunk_rest.call(null,seq__11783_11801__$1);
var G__11804 = c__4262__auto___11802;
var G__11805 = cljs.core.count.call(null,c__4262__auto___11802);
var G__11806 = 0;
seq__11783_11789 = G__11803;
chunk__11784_11790 = G__11804;
count__11785_11791 = G__11805;
i__11786_11792 = G__11806;
continue;
}
} else
{var vec__11788_11807 = cljs.core.first.call(null,seq__11783_11801__$1);var ev__3326__auto___11808 = cljs.core.nth.call(null,vec__11788_11807,0,null);var func__3327__auto___11809 = cljs.core.nth.call(null,vec__11788_11807,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11808,func__3327__auto___11809);
{
var G__11810 = cljs.core.next.call(null,seq__11783_11801__$1);
var G__11811 = null;
var G__11812 = 0;
var G__11813 = 0;
seq__11783_11789 = G__11810;
chunk__11784_11790 = G__11811;
count__11785_11791 = G__11812;
i__11786_11792 = G__11813;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.search_input = (function search_input(this$){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"placeholder","placeholder",1612151013),"Search available plugins"], null)], null));var seq__11820_11826 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"focus","focus",1111509066),(function (){return lt.objs.context.in_BANG_.call(null,new cljs.core.Keyword(null,"plugin-manager.search","plugin-manager.search",4116247637),this$);
}),new cljs.core.Keyword(null,"blur","blur",1016931289),(function (){return lt.objs.context.out_BANG_.call(null,new cljs.core.Keyword(null,"plugin-manager.search","plugin-manager.search",4116247637));
})], null)));var chunk__11821_11827 = null;var count__11822_11828 = 0;var i__11823_11829 = 0;while(true){
if((i__11823_11829 < count__11822_11828))
{var vec__11824_11830 = cljs.core._nth.call(null,chunk__11821_11827,i__11823_11829);var ev__3326__auto___11831 = cljs.core.nth.call(null,vec__11824_11830,0,null);var func__3327__auto___11832 = cljs.core.nth.call(null,vec__11824_11830,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11831,func__3327__auto___11832);
{
var G__11833 = seq__11820_11826;
var G__11834 = chunk__11821_11827;
var G__11835 = count__11822_11828;
var G__11836 = (i__11823_11829 + 1);
seq__11820_11826 = G__11833;
chunk__11821_11827 = G__11834;
count__11822_11828 = G__11835;
i__11823_11829 = G__11836;
continue;
}
} else
{var temp__4092__auto___11837 = cljs.core.seq.call(null,seq__11820_11826);if(temp__4092__auto___11837)
{var seq__11820_11838__$1 = temp__4092__auto___11837;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11820_11838__$1))
{var c__4262__auto___11839 = cljs.core.chunk_first.call(null,seq__11820_11838__$1);{
var G__11840 = cljs.core.chunk_rest.call(null,seq__11820_11838__$1);
var G__11841 = c__4262__auto___11839;
var G__11842 = cljs.core.count.call(null,c__4262__auto___11839);
var G__11843 = 0;
seq__11820_11826 = G__11840;
chunk__11821_11827 = G__11841;
count__11822_11828 = G__11842;
i__11823_11829 = G__11843;
continue;
}
} else
{var vec__11825_11844 = cljs.core.first.call(null,seq__11820_11838__$1);var ev__3326__auto___11845 = cljs.core.nth.call(null,vec__11825_11844,0,null);var func__3327__auto___11846 = cljs.core.nth.call(null,vec__11825_11844,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11845,func__3327__auto___11846);
{
var G__11847 = cljs.core.next.call(null,seq__11820_11838__$1);
var G__11848 = null;
var G__11849 = 0;
var G__11850 = 0;
seq__11820_11826 = G__11847;
chunk__11821_11827 = G__11848;
count__11822_11828 = G__11849;
i__11823_11829 = G__11850;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.tabs_and_search = (function tabs_and_search(this$){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tabs","div.tabs",1324158509),lt.objs.plugins.tab.call(null,this$,new cljs.core.Keyword(null,"installed","installed",1042950892),"Installed"),lt.objs.plugins.tab.call(null,this$,new cljs.core.Keyword(null,"server","server",4403045045),"Available"),lt.objs.plugins.search_input.call(null,this$)], null));var seq__11857_11863 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,cljs.core.PersistentVector.EMPTY));var chunk__11858_11864 = null;var count__11859_11865 = 0;var i__11860_11866 = 0;while(true){
if((i__11860_11866 < count__11859_11865))
{var vec__11861_11867 = cljs.core._nth.call(null,chunk__11858_11864,i__11860_11866);var ev__3326__auto___11868 = cljs.core.nth.call(null,vec__11861_11867,0,null);var func__3327__auto___11869 = cljs.core.nth.call(null,vec__11861_11867,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11868,func__3327__auto___11869);
{
var G__11870 = seq__11857_11863;
var G__11871 = chunk__11858_11864;
var G__11872 = count__11859_11865;
var G__11873 = (i__11860_11866 + 1);
seq__11857_11863 = G__11870;
chunk__11858_11864 = G__11871;
count__11859_11865 = G__11872;
i__11860_11866 = G__11873;
continue;
}
} else
{var temp__4092__auto___11874 = cljs.core.seq.call(null,seq__11857_11863);if(temp__4092__auto___11874)
{var seq__11857_11875__$1 = temp__4092__auto___11874;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11857_11875__$1))
{var c__4262__auto___11876 = cljs.core.chunk_first.call(null,seq__11857_11875__$1);{
var G__11877 = cljs.core.chunk_rest.call(null,seq__11857_11875__$1);
var G__11878 = c__4262__auto___11876;
var G__11879 = cljs.core.count.call(null,c__4262__auto___11876);
var G__11880 = 0;
seq__11857_11863 = G__11877;
chunk__11858_11864 = G__11878;
count__11859_11865 = G__11879;
i__11860_11866 = G__11880;
continue;
}
} else
{var vec__11862_11881 = cljs.core.first.call(null,seq__11857_11875__$1);var ev__3326__auto___11882 = cljs.core.nth.call(null,vec__11862_11881,0,null);var func__3327__auto___11883 = cljs.core.nth.call(null,vec__11862_11881,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11882,func__3327__auto___11883);
{
var G__11884 = cljs.core.next.call(null,seq__11857_11875__$1);
var G__11885 = null;
var G__11886 = 0;
var G__11887 = 0;
seq__11857_11863 = G__11884;
chunk__11858_11864 = G__11885;
count__11859_11865 = G__11886;
i__11860_11866 = G__11887;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.source_button = (function source_button(plugin){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.source","span.source",4763361969),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",1013904339),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",1017115293),new cljs.core.Keyword(null,"url","url",1014020321).cljs$core$IFn$_invoke$arity$2(plugin,new cljs.core.Keyword(null,"source","source",4412365709).cljs$core$IFn$_invoke$arity$1(plugin))], null),"source"], null)], null));var seq__11894_11900 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"click","click",1108654330),(function (e){lt.util.dom.prevent.call(null,e);
lt.util.dom.stop_propagation.call(null,e);
return lt.objs.platform.open_url.call(null,new cljs.core.Keyword(null,"url","url",1014020321).cljs$core$IFn$_invoke$arity$2(plugin,new cljs.core.Keyword(null,"source","source",4412365709).cljs$core$IFn$_invoke$arity$1(plugin)));
})], null)));var chunk__11895_11901 = null;var count__11896_11902 = 0;var i__11897_11903 = 0;while(true){
if((i__11897_11903 < count__11896_11902))
{var vec__11898_11904 = cljs.core._nth.call(null,chunk__11895_11901,i__11897_11903);var ev__3326__auto___11905 = cljs.core.nth.call(null,vec__11898_11904,0,null);var func__3327__auto___11906 = cljs.core.nth.call(null,vec__11898_11904,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11905,func__3327__auto___11906);
{
var G__11907 = seq__11894_11900;
var G__11908 = chunk__11895_11901;
var G__11909 = count__11896_11902;
var G__11910 = (i__11897_11903 + 1);
seq__11894_11900 = G__11907;
chunk__11895_11901 = G__11908;
count__11896_11902 = G__11909;
i__11897_11903 = G__11910;
continue;
}
} else
{var temp__4092__auto___11911 = cljs.core.seq.call(null,seq__11894_11900);if(temp__4092__auto___11911)
{var seq__11894_11912__$1 = temp__4092__auto___11911;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11894_11912__$1))
{var c__4262__auto___11913 = cljs.core.chunk_first.call(null,seq__11894_11912__$1);{
var G__11914 = cljs.core.chunk_rest.call(null,seq__11894_11912__$1);
var G__11915 = c__4262__auto___11913;
var G__11916 = cljs.core.count.call(null,c__4262__auto___11913);
var G__11917 = 0;
seq__11894_11900 = G__11914;
chunk__11895_11901 = G__11915;
count__11896_11902 = G__11916;
i__11897_11903 = G__11917;
continue;
}
} else
{var vec__11899_11918 = cljs.core.first.call(null,seq__11894_11912__$1);var ev__3326__auto___11919 = cljs.core.nth.call(null,vec__11899_11918,0,null);var func__3327__auto___11920 = cljs.core.nth.call(null,vec__11899_11918,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11919,func__3327__auto___11920);
{
var G__11921 = cljs.core.next.call(null,seq__11894_11912__$1);
var G__11922 = null;
var G__11923 = 0;
var G__11924 = 0;
seq__11894_11900 = G__11921;
chunk__11895_11901 = G__11922;
count__11896_11902 = G__11923;
i__11897_11903 = G__11924;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.update_button = (function update_button(plugin){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.update","span.update",526054239)], null));var seq__11931_11937 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"click","click",1108654330),(function (e){lt.util.dom.prevent.call(null,e);
lt.util.dom.stop_propagation.call(null,e);
return lt.objs.plugins.discover_deps.call(null,plugin,(function (){lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"refresh!","refresh!",4597922840));
lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"behaviors.reload","behaviors.reload",2942796600));
return lt.util.js.wait.call(null,1000,(function (){return lt.objs.notifos.set_msg_BANG_.call(null,[cljs.core.str("Updated "),cljs.core.str(new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin)),cljs.core.str(" "),cljs.core.str(new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin))].join(''));
}));
}));
})], null)));var chunk__11932_11938 = null;var count__11933_11939 = 0;var i__11934_11940 = 0;while(true){
if((i__11934_11940 < count__11933_11939))
{var vec__11935_11941 = cljs.core._nth.call(null,chunk__11932_11938,i__11934_11940);var ev__3326__auto___11942 = cljs.core.nth.call(null,vec__11935_11941,0,null);var func__3327__auto___11943 = cljs.core.nth.call(null,vec__11935_11941,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11942,func__3327__auto___11943);
{
var G__11944 = seq__11931_11937;
var G__11945 = chunk__11932_11938;
var G__11946 = count__11933_11939;
var G__11947 = (i__11934_11940 + 1);
seq__11931_11937 = G__11944;
chunk__11932_11938 = G__11945;
count__11933_11939 = G__11946;
i__11934_11940 = G__11947;
continue;
}
} else
{var temp__4092__auto___11948 = cljs.core.seq.call(null,seq__11931_11937);if(temp__4092__auto___11948)
{var seq__11931_11949__$1 = temp__4092__auto___11948;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11931_11949__$1))
{var c__4262__auto___11950 = cljs.core.chunk_first.call(null,seq__11931_11949__$1);{
var G__11951 = cljs.core.chunk_rest.call(null,seq__11931_11949__$1);
var G__11952 = c__4262__auto___11950;
var G__11953 = cljs.core.count.call(null,c__4262__auto___11950);
var G__11954 = 0;
seq__11931_11937 = G__11951;
chunk__11932_11938 = G__11952;
count__11933_11939 = G__11953;
i__11934_11940 = G__11954;
continue;
}
} else
{var vec__11936_11955 = cljs.core.first.call(null,seq__11931_11949__$1);var ev__3326__auto___11956 = cljs.core.nth.call(null,vec__11936_11955,0,null);var func__3327__auto___11957 = cljs.core.nth.call(null,vec__11936_11955,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11956,func__3327__auto___11957);
{
var G__11958 = cljs.core.next.call(null,seq__11931_11949__$1);
var G__11959 = null;
var G__11960 = 0;
var G__11961 = 0;
seq__11931_11937 = G__11958;
chunk__11932_11938 = G__11959;
count__11933_11939 = G__11960;
i__11934_11940 = G__11961;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.install_button = (function install_button(plugin){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.install","span.install",967456361)], null));var seq__11968_11974 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"click","click",1108654330),(function (e){var me_11978 = this;lt.objs.plugins.discover_deps.call(null,plugin,((function (me_11978){
return (function (){lt.util.dom.remove.call(null,lt.util.dom.parent.call(null,me_11978));
lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"refresh!","refresh!",4597922840));
lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"behaviors.reload","behaviors.reload",2942796600));
return lt.util.js.wait.call(null,1000,((function (me_11978){
return (function (){return lt.objs.notifos.set_msg_BANG_.call(null,[cljs.core.str("Installed "),cljs.core.str(new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin)),cljs.core.str(" "),cljs.core.str(new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin))].join(''));
});})(me_11978))
);
});})(me_11978))
);
lt.util.dom.prevent.call(null,e);
return lt.util.dom.stop_propagation.call(null,e);
})], null)));var chunk__11969_11975 = null;var count__11970_11976 = 0;var i__11971_11977 = 0;while(true){
if((i__11971_11977 < count__11970_11976))
{var vec__11972_11979 = cljs.core._nth.call(null,chunk__11969_11975,i__11971_11977);var ev__3326__auto___11980 = cljs.core.nth.call(null,vec__11972_11979,0,null);var func__3327__auto___11981 = cljs.core.nth.call(null,vec__11972_11979,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11980,func__3327__auto___11981);
{
var G__11982 = seq__11968_11974;
var G__11983 = chunk__11969_11975;
var G__11984 = count__11970_11976;
var G__11985 = (i__11971_11977 + 1);
seq__11968_11974 = G__11982;
chunk__11969_11975 = G__11983;
count__11970_11976 = G__11984;
i__11971_11977 = G__11985;
continue;
}
} else
{var temp__4092__auto___11986 = cljs.core.seq.call(null,seq__11968_11974);if(temp__4092__auto___11986)
{var seq__11968_11987__$1 = temp__4092__auto___11986;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11968_11987__$1))
{var c__4262__auto___11988 = cljs.core.chunk_first.call(null,seq__11968_11987__$1);{
var G__11989 = cljs.core.chunk_rest.call(null,seq__11968_11987__$1);
var G__11990 = c__4262__auto___11988;
var G__11991 = cljs.core.count.call(null,c__4262__auto___11988);
var G__11992 = 0;
seq__11968_11974 = G__11989;
chunk__11969_11975 = G__11990;
count__11970_11976 = G__11991;
i__11971_11977 = G__11992;
continue;
}
} else
{var vec__11973_11993 = cljs.core.first.call(null,seq__11968_11987__$1);var ev__3326__auto___11994 = cljs.core.nth.call(null,vec__11973_11993,0,null);var func__3327__auto___11995 = cljs.core.nth.call(null,vec__11973_11993,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___11994,func__3327__auto___11995);
{
var G__11996 = cljs.core.next.call(null,seq__11968_11987__$1);
var G__11997 = null;
var G__11998 = 0;
var G__11999 = 0;
seq__11968_11974 = G__11996;
chunk__11969_11975 = G__11997;
count__11970_11976 = G__11998;
i__11971_11977 = G__11999;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.server_plugin_ui = (function server_plugin_ui(plugin){var e__3325__auto__ = crate.core.html.call(null,(function (){var info = plugin;var ver = new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(info);var installed = cljs.core.get.call(null,new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.app.app)),new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(info));var update_QMARK_ = (function (){var and__3508__auto__ = new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(installed);if(cljs.core.truth_(and__3508__auto__))
{return lt.objs.deploy.is_newer_QMARK_.call(null,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(installed),ver);
} else
{return and__3508__auto__;
}
})();return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",1108647146),(cljs.core.truth_(update_QMARK_)?"has-update":null)], null),((cljs.core.not.call(null,installed))?lt.objs.plugins.install_button.call(null,plugin):(cljs.core.truth_(update_QMARK_)?lt.objs.plugins.update_button.call(null,plugin):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.installed","span.installed",3622134088)], null))),lt.objs.plugins.source_button.call(null,plugin),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",1013907515),new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.version","span.version",3656461734),ver], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",1013907517),new cljs.core.Keyword(null,"author","author",3902543101).cljs$core$IFn$_invoke$arity$1(info)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",1013904354),new cljs.core.Keyword(null,"desc","desc",1016984067).cljs$core$IFn$_invoke$arity$1(info)], null)], null);
})());var seq__12006_12012 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,cljs.core.PersistentVector.EMPTY));var chunk__12007_12013 = null;var count__12008_12014 = 0;var i__12009_12015 = 0;while(true){
if((i__12009_12015 < count__12008_12014))
{var vec__12010_12016 = cljs.core._nth.call(null,chunk__12007_12013,i__12009_12015);var ev__3326__auto___12017 = cljs.core.nth.call(null,vec__12010_12016,0,null);var func__3327__auto___12018 = cljs.core.nth.call(null,vec__12010_12016,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___12017,func__3327__auto___12018);
{
var G__12019 = seq__12006_12012;
var G__12020 = chunk__12007_12013;
var G__12021 = count__12008_12014;
var G__12022 = (i__12009_12015 + 1);
seq__12006_12012 = G__12019;
chunk__12007_12013 = G__12020;
count__12008_12014 = G__12021;
i__12009_12015 = G__12022;
continue;
}
} else
{var temp__4092__auto___12023 = cljs.core.seq.call(null,seq__12006_12012);if(temp__4092__auto___12023)
{var seq__12006_12024__$1 = temp__4092__auto___12023;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12006_12024__$1))
{var c__4262__auto___12025 = cljs.core.chunk_first.call(null,seq__12006_12024__$1);{
var G__12026 = cljs.core.chunk_rest.call(null,seq__12006_12024__$1);
var G__12027 = c__4262__auto___12025;
var G__12028 = cljs.core.count.call(null,c__4262__auto___12025);
var G__12029 = 0;
seq__12006_12012 = G__12026;
chunk__12007_12013 = G__12027;
count__12008_12014 = G__12028;
i__12009_12015 = G__12029;
continue;
}
} else
{var vec__12011_12030 = cljs.core.first.call(null,seq__12006_12024__$1);var ev__3326__auto___12031 = cljs.core.nth.call(null,vec__12011_12030,0,null);var func__3327__auto___12032 = cljs.core.nth.call(null,vec__12011_12030,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___12031,func__3327__auto___12032);
{
var G__12033 = cljs.core.next.call(null,seq__12006_12024__$1);
var G__12034 = null;
var G__12035 = 0;
var G__12036 = 0;
seq__12006_12012 = G__12033;
chunk__12007_12013 = G__12034;
count__12008_12014 = G__12035;
i__12009_12015 = G__12036;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.uninstall_button = (function uninstall_button(plugin){var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.uninstall","span.uninstall",2967491248)], null));var seq__12043_12049 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"click","click",1108654330),(function (){return lt.objs.popup.popup_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",4087600639),"Uninstall plugin?",new cljs.core.Keyword(null,"body","body",1016933652),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1014003715),"This will delete the plugin from your system, removing any local\n                                 changes you may have made, and cannot be undone."], null),new cljs.core.Keyword(null,"buttons","buttons",1255256819),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Delete plugin",new cljs.core.Keyword(null,"action","action",3885920680),(function (){return lt.objs.plugins.uninstall.call(null,plugin);
})], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"Cancel"], null)], null)], null));
})], null)));var chunk__12044_12050 = null;var count__12045_12051 = 0;var i__12046_12052 = 0;while(true){
if((i__12046_12052 < count__12045_12051))
{var vec__12047_12053 = cljs.core._nth.call(null,chunk__12044_12050,i__12046_12052);var ev__3326__auto___12054 = cljs.core.nth.call(null,vec__12047_12053,0,null);var func__3327__auto___12055 = cljs.core.nth.call(null,vec__12047_12053,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___12054,func__3327__auto___12055);
{
var G__12056 = seq__12043_12049;
var G__12057 = chunk__12044_12050;
var G__12058 = count__12045_12051;
var G__12059 = (i__12046_12052 + 1);
seq__12043_12049 = G__12056;
chunk__12044_12050 = G__12057;
count__12045_12051 = G__12058;
i__12046_12052 = G__12059;
continue;
}
} else
{var temp__4092__auto___12060 = cljs.core.seq.call(null,seq__12043_12049);if(temp__4092__auto___12060)
{var seq__12043_12061__$1 = temp__4092__auto___12060;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12043_12061__$1))
{var c__4262__auto___12062 = cljs.core.chunk_first.call(null,seq__12043_12061__$1);{
var G__12063 = cljs.core.chunk_rest.call(null,seq__12043_12061__$1);
var G__12064 = c__4262__auto___12062;
var G__12065 = cljs.core.count.call(null,c__4262__auto___12062);
var G__12066 = 0;
seq__12043_12049 = G__12063;
chunk__12044_12050 = G__12064;
count__12045_12051 = G__12065;
i__12046_12052 = G__12066;
continue;
}
} else
{var vec__12048_12067 = cljs.core.first.call(null,seq__12043_12061__$1);var ev__3326__auto___12068 = cljs.core.nth.call(null,vec__12048_12067,0,null);var func__3327__auto___12069 = cljs.core.nth.call(null,vec__12048_12067,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___12068,func__3327__auto___12069);
{
var G__12070 = cljs.core.next.call(null,seq__12043_12061__$1);
var G__12071 = null;
var G__12072 = 0;
var G__12073 = 0;
seq__12043_12049 = G__12070;
chunk__12044_12050 = G__12071;
count__12045_12051 = G__12072;
i__12046_12052 = G__12073;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.objs.plugins.installed_plugin_ui = (function installed_plugin_ui(plugin){var e__3325__auto__ = crate.core.html.call(null,(function (){var cached = new cljs.core.Keyword(null,"latest-version","latest-version",1676217348).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.plugins.manager)),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin))));var update_QMARK_ = (cljs.core.truth_(cached)?lt.objs.deploy.is_newer_QMARK_.call(null,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin),cached):null);return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",1108647146),(cljs.core.truth_(update_QMARK_)?"has-update":null)], null),(cljs.core.truth_(update_QMARK_)?lt.objs.plugins.update_button.call(null,cljs.core.assoc.call(null,plugin,new cljs.core.Keyword(null,"version","version",1365512266),cached)):null),lt.objs.plugins.uninstall_button.call(null,plugin),lt.objs.plugins.source_button.call(null,plugin),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",1013907515),new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.version","span.version",3656461734),new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(plugin)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",1013907517),new cljs.core.Keyword(null,"author","author",3902543101).cljs$core$IFn$_invoke$arity$1(plugin)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",1013904354),new cljs.core.Keyword(null,"desc","desc",1016984067).cljs$core$IFn$_invoke$arity$1(plugin)], null)], null);
})());var seq__12080_12086 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,cljs.core.PersistentVector.EMPTY));var chunk__12081_12087 = null;var count__12082_12088 = 0;var i__12083_12089 = 0;while(true){
if((i__12083_12089 < count__12082_12088))
{var vec__12084_12090 = cljs.core._nth.call(null,chunk__12081_12087,i__12083_12089);var ev__3326__auto___12091 = cljs.core.nth.call(null,vec__12084_12090,0,null);var func__3327__auto___12092 = cljs.core.nth.call(null,vec__12084_12090,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___12091,func__3327__auto___12092);
{
var G__12093 = seq__12080_12086;
var G__12094 = chunk__12081_12087;
var G__12095 = count__12082_12088;
var G__12096 = (i__12083_12089 + 1);
seq__12080_12086 = G__12093;
chunk__12081_12087 = G__12094;
count__12082_12088 = G__12095;
i__12083_12089 = G__12096;
continue;
}
} else
{var temp__4092__auto___12097 = cljs.core.seq.call(null,seq__12080_12086);if(temp__4092__auto___12097)
{var seq__12080_12098__$1 = temp__4092__auto___12097;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12080_12098__$1))
{var c__4262__auto___12099 = cljs.core.chunk_first.call(null,seq__12080_12098__$1);{
var G__12100 = cljs.core.chunk_rest.call(null,seq__12080_12098__$1);
var G__12101 = c__4262__auto___12099;
var G__12102 = cljs.core.count.call(null,c__4262__auto___12099);
var G__12103 = 0;
seq__12080_12086 = G__12100;
chunk__12081_12087 = G__12101;
count__12082_12088 = G__12102;
i__12083_12089 = G__12103;
continue;
}
} else
{var vec__12085_12104 = cljs.core.first.call(null,seq__12080_12098__$1);var ev__3326__auto___12105 = cljs.core.nth.call(null,vec__12085_12104,0,null);var func__3327__auto___12106 = cljs.core.nth.call(null,vec__12085_12104,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___12105,func__3327__auto___12106);
{
var G__12107 = cljs.core.next.call(null,seq__12080_12098__$1);
var G__12108 = null;
var G__12109 = 0;
var G__12110 = 0;
seq__12080_12086 = G__12107;
chunk__12081_12087 = G__12108;
count__12082_12088 = G__12109;
i__12083_12089 = G__12110;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
});
lt.object.object_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","plugin-manager","lt.objs.plugins/plugin-manager",2152899846),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"plugin-manager","plugin-manager",1960276613),null], null), null),new cljs.core.Keyword(null,"name","name",1017277949),"Plugins",new cljs.core.Keyword(null,"tab","tab",1014018823),new cljs.core.Keyword(null,"installed","installed",1042950892),new cljs.core.Keyword(null,"init","init",1017141378),(function (this$){lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784),lt.objs.plugins.read_cache.call(null)], null));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1014003715),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",1108647146),crate.binding.bound.call(null,this$,(function (p1__12111_SHARP_){return [cljs.core.str("plugin-manager"),cljs.core.str(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tab","tab",1014018823).cljs$core$IFn$_invoke$arity$1(p1__12111_SHARP_),new cljs.core.Keyword(null,"server","server",4403045045)))?" server":null))].join('');
}))], null),lt.objs.plugins.tabs_and_search.call(null,this$),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.server-plugins","ul.server-plugins",2509222591)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.plugins","ul.plugins",4244308667)], null)], null);
}));
lt.objs.plugins.manager = lt.object.create.call(null,new cljs.core.Keyword("lt.objs.plugins","plugin-manager","lt.objs.plugins/plugin-manager",2152899846));
lt.objs.plugins.__BEH__check_local_metadata_cache = (function __BEH__check_local_metadata_cache(this$,sha){if(!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"__sha","__sha",1104582718).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$))),sha)))
{return lt.objs.plugins.download_metadata.call(null,sha);
} else
{return lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"metadata.updated","metadata.updated",1526644846));
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","check-local-metadata-cache","lt.objs.plugins/check-local-metadata-cache",3873892318),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__check_local_metadata_cache,new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugin Manager: check local metadata cache for update",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"metadata.sha","metadata.sha",2333336799),null], null), null));
lt.objs.plugins.__BEH__draw_plugins_on_updated = (function __BEH__draw_plugins_on_updated(this$,sha){lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784),lt.objs.plugins.read_cache.call(null)], null));
return lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"plugin-results","plugin-results",2222563022),lt.objs.plugins.all_latest.call(null,new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$))));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","draw-plugins-on-updated","lt.objs.plugins/draw-plugins-on-updated",604527958),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__draw_plugins_on_updated,new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugin Manager: draw plugins on metadata update",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"metadata.updated","metadata.updated",1526644846),null], null), null));
lt.objs.plugins.__BEH__get_latest_metadata_sha = (function __BEH__get_latest_metadata_sha(this$,sha){return lt.objs.plugins.latest_metadata_sha.call(null);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","get-latest-metadata-sha","lt.objs.plugins/get-latest-metadata-sha",1607213808),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__get_latest_metadata_sha,new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugin Manager: get the latest metadata sha",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fetch-plugins","fetch-plugins",2680814335),null], null), null));
lt.objs.plugins.__BEH__render_server_plugins = (function __BEH__render_server_plugins(this$,plugins){var ul = lt.util.dom.$.call(null,new cljs.core.Keyword(null,".server-plugins",".server-plugins",2388894262),lt.object.__GT_content.call(null,this$));lt.util.dom.empty.call(null,ul);
return lt.util.dom.append.call(null,ul,lt.util.dom.fragment.call(null,cljs.core.map.call(null,lt.objs.plugins.server_plugin_ui,cljs.core.remove.call(null,(function (p1__12112_SHARP_){return lt.objs.plugins.installed_QMARK_.call(null,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(p1__12112_SHARP_));
}),plugins))));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","render-server-plugins","lt.objs.plugins/render-server-plugins",797162336),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__render_server_plugins,new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugin Manager: render plugin results",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"plugin-results","plugin-results",2222563022),null], null), null));
lt.objs.plugins.__BEH__search_server_plugins = (function __BEH__search_server_plugins(this$,search){var plugins = lt.objs.plugins.all_latest.call(null,new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.plugins.manager)));return lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"plugin-results","plugin-results",2222563022),((cljs.core.empty_QMARK_.call(null,search))?plugins:lt.objs.plugins.search_plugins.call(null,plugins,search)));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","search-server-plugins","lt.objs.plugins/search-server-plugins",2575945774),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__search_server_plugins,new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugin Manager: search plugins",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"search-plugins!","search-plugins!",4139281016),null], null), null));
lt.objs.plugins.save_plugins = (function save_plugins(plugin_maps){var plugin_edn_file = lt.objs.files.join.call(null,lt.objs.settings.user_plugin_dir,"plugin.edn");var plugin_edn = lt.objs.settings.safe_read.call(null,new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(lt.objs.files.open_sync.call(null,plugin_edn_file)),plugin_edn_file);var plugin_name = (function (){var G__12116 = new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin_edn);if(cljs.core.truth_(G__12116))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("User plugin doesn't have a :name"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"G__12116","G__12116",-1274985465,null)))].join('')));
}
return G__12116;
})();var deps = cljs.core.into.call(null,cljs.core.sorted_map.call(null),cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"name","name",1017277949),new cljs.core.Keyword(null,"version","version",1365512266)),cljs.core.remove.call(null,((function (plugin_edn_file,plugin_edn,plugin_name){
return (function (p1__12113_SHARP_){return cljs.core.contains_QMARK_.call(null,cljs.core.PersistentHashSet.fromArray([plugin_name], true),new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(p1__12113_SHARP_));
});})(plugin_edn_file,plugin_edn,plugin_name))
,cljs.core.vals.call(null,plugin_maps))));var plugin_edn_body = cljs.core.pr_str.call(null,cljs.core.assoc.call(null,plugin_edn,new cljs.core.Keyword(null,"dependencies","dependencies",1517678747),deps));return lt.objs.files.save.call(null,plugin_edn_file,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace.call(null,plugin_edn_body,/(\"\s*,|\{|\},)/,(function (p1__12114_SHARP_){return [cljs.core.str(p1__12114_SHARP_),cljs.core.str("\n")].join('');
})),/^\{\n/,"{"),/:dependencies/,";; Do not edit - :dependencies are auto-generated\n:dependencies"));
});
/**
* @param {...*} var_args
*/
lt.objs.plugins.__BEH__save_user_plugin_dependencies = (function() { 
var __BEH__save_user_plugin_dependencies__delegate = function (this$,opts){return lt.objs.plugins.save_plugins.call(null,lt.objs.plugins.available_plugins.call(null));
};
var __BEH__save_user_plugin_dependencies = function (this$,var_args){
var opts = null;if (arguments.length > 1) {
  opts = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return __BEH__save_user_plugin_dependencies__delegate.call(this,this$,opts);};
__BEH__save_user_plugin_dependencies.cljs$lang$maxFixedArity = 1;
__BEH__save_user_plugin_dependencies.cljs$lang$applyTo = (function (arglist__12117){
var this$ = cljs.core.first(arglist__12117);
var opts = cljs.core.rest(arglist__12117);
return __BEH__save_user_plugin_dependencies__delegate(this$,opts);
});
__BEH__save_user_plugin_dependencies.cljs$core$IFn$_invoke$arity$variadic = __BEH__save_user_plugin_dependencies__delegate;
return __BEH__save_user_plugin_dependencies;
})()
;
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","save-user-plugin-dependencies","lt.objs.plugins/save-user-plugin-dependencies",1525590204),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__save_user_plugin_dependencies,new cljs.core.Keyword(null,"desc","desc",1016984067),"Saves dependencies to user's plugin.edn",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"refresh!","refresh!",4597922840),null], null), null));
/**
* @param {...*} var_args
*/
lt.objs.plugins.__BEH__render_installed_plugins = (function() { 
var __BEH__render_installed_plugins__delegate = function (this$,p__12119){var map__12121 = p__12119;var map__12121__$1 = ((cljs.core.seq_QMARK_.call(null,map__12121))?cljs.core.apply.call(null,cljs.core.hash_map,map__12121):map__12121);var ignore_missing = cljs.core.get.call(null,map__12121__$1,new cljs.core.Keyword(null,"ignore-missing","ignore-missing",2124702685));lt.object.merge_BANG_.call(null,lt.objs.app.app,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683),lt.objs.plugins.available_plugins.call(null)], null));
if(cljs.core.truth_(ignore_missing))
{} else
{lt.objs.plugins.check_missing.call(null,new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.app.app)));
}
var ul = lt.util.dom.$.call(null,new cljs.core.Keyword(null,".plugins",".plugins",3398138660),lt.object.__GT_content.call(null,this$));lt.util.dom.empty.call(null,ul);
return lt.util.dom.append.call(null,ul,lt.util.dom.fragment.call(null,cljs.core.map.call(null,lt.objs.plugins.installed_plugin_ui,cljs.core.sort_by.call(null,(function (p1__12118_SHARP_){return new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(p1__12118_SHARP_).toUpperCase();
}),cljs.core.vals.call(null,new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.app.app)))))));
};
var __BEH__render_installed_plugins = function (this$,var_args){
var p__12119 = null;if (arguments.length > 1) {
  p__12119 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return __BEH__render_installed_plugins__delegate.call(this,this$,p__12119);};
__BEH__render_installed_plugins.cljs$lang$maxFixedArity = 1;
__BEH__render_installed_plugins.cljs$lang$applyTo = (function (arglist__12122){
var this$ = cljs.core.first(arglist__12122);
var p__12119 = cljs.core.rest(arglist__12122);
return __BEH__render_installed_plugins__delegate(this$,p__12119);
});
__BEH__render_installed_plugins.cljs$core$IFn$_invoke$arity$variadic = __BEH__render_installed_plugins__delegate;
return __BEH__render_installed_plugins;
})()
;
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","render-installed-plugins","lt.objs.plugins/render-installed-plugins",560702913),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__render_installed_plugins,new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugin Manager: refresh installed plugins",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"refresh!","refresh!",4597922840),null], null), null));
lt.objs.plugins.__BEH__on_close = (function __BEH__on_close(this$){return lt.objs.tabs.rem_BANG_.call(null,this$);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","on-close","lt.objs.plugins/on-close",1621607293),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__on_close,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"close","close",1108660586),null], null), null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"plugin-manager.search","plugin-manager.search",4116247637),new cljs.core.Keyword(null,"hidden","hidden",4091384092),true,new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugins: Search",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (term){var term__$1 = (function (){var or__3520__auto__ = term;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return lt.util.dom.val.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"input","input",1114262332),lt.object.__GT_content.call(null,lt.objs.plugins.manager)));
}
})();lt.object.merge_BANG_.call(null,lt.objs.plugins.manager,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tab","tab",1014018823),new cljs.core.Keyword(null,"server","server",4403045045)], null));
return lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"search-plugins!","search-plugins!",4139281016),term__$1);
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"plugin-manager.refresh","plugin-manager.refresh",1814385266),new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugins: Refresh plugin list",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"refresh!","refresh!",4597922840));
return lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"fetch-plugins","fetch-plugins",2680814335));
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"plugin-manager.show","plugin-manager.show",3752328298),new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugins: Show plugin manager",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){lt.objs.tabs.add_or_focus_BANG_.call(null,lt.objs.plugins.manager);
lt.util.dom.focus.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"input","input",1114262332),lt.object.__GT_content.call(null,lt.objs.plugins.manager)));
return lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"plugin-manager.refresh","plugin-manager.refresh",1814385266));
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"plugin-manager.update-outdated","plugin-manager.update-outdated",1387765507),new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugins: Update all outdated",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){var outdated = cljs.core.filter.call(null,lt.objs.plugins.outdated_QMARK_,cljs.core.vals.call(null,new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.app.app))));var names = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);var countdown = cljs.core.atom.call(null,cljs.core.count.call(null,outdated));var seq__12123 = cljs.core.seq.call(null,outdated);var chunk__12126 = null;var count__12127 = 0;var i__12128 = 0;while(true){
if((i__12128 < count__12127))
{var plugin = cljs.core._nth.call(null,chunk__12126,i__12128);if(cljs.core.seq.call(null,outdated))
{var cached_12131 = new cljs.core.Keyword(null,"latest-version","latest-version",1676217348).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.plugins.manager)),new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin)));lt.objs.plugins.discover_deps.call(null,cljs.core.assoc.call(null,plugin,new cljs.core.Keyword(null,"version","version",1365512266),cached_12131),((function (seq__12123,chunk__12126,count__12127,i__12128,cached_12131,plugin){
return (function (){cljs.core.swap_BANG_.call(null,names,cljs.core.conj,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin));
cljs.core.swap_BANG_.call(null,countdown,cljs.core.dec);
lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"refresh!","refresh!",4597922840));
if((cljs.core.deref.call(null,countdown) <= 0))
{lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"behaviors.reload","behaviors.reload",2942796600));
return lt.objs.notifos.set_msg_BANG_.call(null,cljs.core.apply.call(null,cljs.core.str,"Updated: ",cljs.core.interpose.call(null,", ",cljs.core.deref.call(null,names))));
} else
{return null;
}
});})(seq__12123,chunk__12126,count__12127,i__12128,cached_12131,plugin))
);
{
var G__12132 = seq__12123;
var G__12133 = chunk__12126;
var G__12134 = count__12127;
var G__12135 = (i__12128 + 1);
seq__12123 = G__12132;
chunk__12126 = G__12133;
count__12127 = G__12134;
i__12128 = G__12135;
continue;
}
} else
{{
var G__12136 = seq__12123;
var G__12137 = chunk__12126;
var G__12138 = count__12127;
var G__12139 = (i__12128 + 1);
seq__12123 = G__12136;
chunk__12126 = G__12137;
count__12127 = G__12138;
i__12128 = G__12139;
continue;
}
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__12123);if(temp__4092__auto__)
{var seq__12123__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12123__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__12123__$1);{
var G__12140 = cljs.core.chunk_rest.call(null,seq__12123__$1);
var G__12141 = c__4262__auto__;
var G__12142 = cljs.core.count.call(null,c__4262__auto__);
var G__12143 = 0;
seq__12123 = G__12140;
chunk__12126 = G__12141;
count__12127 = G__12142;
i__12128 = G__12143;
continue;
}
} else
{var plugin = cljs.core.first.call(null,seq__12123__$1);if(cljs.core.seq.call(null,outdated))
{var cached_12144 = new cljs.core.Keyword(null,"latest-version","latest-version",1676217348).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"server-plugins","server-plugins",1760987784).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.plugins.manager)),new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin)));lt.objs.plugins.discover_deps.call(null,cljs.core.assoc.call(null,plugin,new cljs.core.Keyword(null,"version","version",1365512266),cached_12144),((function (seq__12123,chunk__12126,count__12127,i__12128,cached_12144,plugin,seq__12123__$1,temp__4092__auto__){
return (function (){cljs.core.swap_BANG_.call(null,names,cljs.core.conj,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(plugin));
cljs.core.swap_BANG_.call(null,countdown,cljs.core.dec);
lt.object.raise.call(null,lt.objs.plugins.manager,new cljs.core.Keyword(null,"refresh!","refresh!",4597922840));
if((cljs.core.deref.call(null,countdown) <= 0))
{lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"behaviors.reload","behaviors.reload",2942796600));
return lt.objs.notifos.set_msg_BANG_.call(null,cljs.core.apply.call(null,cljs.core.str,"Updated: ",cljs.core.interpose.call(null,", ",cljs.core.deref.call(null,names))));
} else
{return null;
}
});})(seq__12123,chunk__12126,count__12127,i__12128,cached_12144,plugin,seq__12123__$1,temp__4092__auto__))
);
{
var G__12145 = cljs.core.next.call(null,seq__12123__$1);
var G__12146 = null;
var G__12147 = 0;
var G__12148 = 0;
seq__12123 = G__12145;
chunk__12126 = G__12146;
count__12127 = G__12147;
i__12128 = G__12148;
continue;
}
} else
{{
var G__12149 = cljs.core.next.call(null,seq__12123__$1);
var G__12150 = null;
var G__12151 = 0;
var G__12152 = 0;
seq__12123 = G__12149;
chunk__12126 = G__12150;
count__12127 = G__12151;
i__12128 = G__12152;
continue;
}
}
}
} else
{return null;
}
}
break;
}
})], null));
lt.objs.plugins.__BEH__init_plugins = (function __BEH__init_plugins(app){if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,lt.objs.plugins.user_plugins_dir)))
{} else
{lt.objs.files.mkdir.call(null,lt.objs.plugins.user_plugins_dir);
}
lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"create-user-plugin","create-user-plugin",2686594966));
lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"flatten-map-settings","flatten-map-settings",3992976911));
lt.object.merge_BANG_.call(null,lt.objs.app.app,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683),lt.objs.plugins.available_plugins.call(null)], null));
return lt.objs.plugins.check_missing.call(null,new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.app.app)));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","init-plugins","lt.objs.plugins/init-plugins",4096325174),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__init_plugins,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre-load","pre-load",3967767874),null], null), null));
lt.objs.plugins.__BEH__behaviors__DOT__refreshed_load_keys = (function __BEH__behaviors__DOT__refreshed_load_keys(){return lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"keymaps.reload","keymaps.reload",666881155));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","behaviors.refreshed-load-keys","lt.objs.plugins/behaviors.refreshed-load-keys",1002486638),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__behaviors__DOT__refreshed_load_keys,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behaviors.refreshed","behaviors.refreshed",1338765023),null], null), null));
lt.objs.plugins.__BEH__plugin_behavior_diffs = (function __BEH__plugin_behavior_diffs(this$,diffs){var plugins = new cljs.core.Keyword("lt.objs.plugins","plugins","lt.objs.plugins/plugins",2920328683).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$));var dep_graph = lt.objs.plugins.plugin_dependency_graph.call(null,plugins);var dep_ordered = cljs.core.seq.call(null,lt.util.kahn.kahn_sort.call(null,dep_graph));var mapped = ((dep_ordered)?cljs.core.map.call(null,plugins,dep_ordered):cljs.core.vals.call(null,plugins));if(cljs.core.truth_((function (){var and__3508__auto__ = plugins;if(cljs.core.truth_(and__3508__auto__))
{return (cljs.core.not.call(null,dep_ordered)) && (cljs.core.not.call(null,new cljs.core.Keyword("lt.objs.plugins","cycle-warned","lt.objs.plugins/cycle-warned",1103523743).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$))));
} else
{return and__3508__auto__;
}
})()))
{lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("lt.objs.plugins","cycle-warned","lt.objs.plugins/cycle-warned",1103523743),true], null));
lt.objs.popup.popup_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",4087600639),"There's a cycle in your plugin dependencies.",new cljs.core.Keyword(null,"body","body",1016933652),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1014003715),"As a result, we can't come up with an optimal way to load them.\n                                                This means there may be unexpected consequences to being loaded out of order.\n                                                Here are the plugins causing the cycle: ",lt.objs.plugins.cycle_desc.call(null,lt.objs.plugins.__GT_cycles.call(null,dep_graph))], null),new cljs.core.Keyword(null,"buttons","buttons",1255256819),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"ok"], null)], null)], null));
} else
{}
return cljs.core.concat.call(null,diffs,cljs.core.mapv.call(null,lt.objs.plugins.plugin_behaviors,mapped));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","plugin-behavior-diffs","lt.objs.plugins/plugin-behavior-diffs",1511349728),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__plugin_behavior_diffs,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behaviors.diffs.plugin+","behaviors.diffs.plugin+",2303858461),null], null), null));
lt.objs.plugins.__BEH__plugin_keymap_diffs = (function __BEH__plugin_keymap_diffs(this$,diffs){return cljs.core.concat.call(null,diffs,cljs.core.filter.call(null,cljs.core.identity,cljs.core.mapv.call(null,lt.objs.settings.parse_key_file,new cljs.core.Keyword("lt.objs.plugins","keymaps","lt.objs.plugins/keymaps",4718281889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)))));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","plugin-keymap-diffs","lt.objs.plugins/plugin-keymap-diffs",4431416675),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__plugin_keymap_diffs,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keymap.diffs.plugin+","keymap.diffs.plugin+",4109982809),null], null), null));
lt.objs.plugins.__BEH__load_js = (function __BEH__load_js(this$,path){var _STAR_plugin_dir_STAR_12162 = lt.objs.plugins._STAR_plugin_dir_STAR_;var _STAR_force_reload_STAR_12163 = lt.util.load._STAR_force_reload_STAR_;try{lt.objs.plugins._STAR_plugin_dir_STAR_ = new cljs.core.Keyword("lt.objs.plugins","dir","lt.objs.plugins/dir",3366558592).cljs$core$IFn$_invoke$arity$1(lt.object._STAR_behavior_meta_STAR_);
lt.util.load._STAR_force_reload_STAR_ = new cljs.core.Keyword("lt.objs.plugins","force-reload","lt.objs.plugins/force-reload",4731263182).cljs$core$IFn$_invoke$arity$1(lt.object._STAR_behavior_meta_STAR_);
var paths = ((cljs.core.coll_QMARK_.call(null,path))?path:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [path], null));var seq__12164 = cljs.core.seq.call(null,paths);var chunk__12165 = null;var count__12166 = 0;var i__12167 = 0;while(true){
if((i__12167 < count__12166))
{var path__$1 = cljs.core._nth.call(null,chunk__12165,i__12167);var path_12170__$2 = lt.objs.plugins.adjust_path.call(null,path__$1);if(cljs.core.truth_((function (){var or__3520__auto__ = lt.util.load._STAR_force_reload_STAR_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.Keyword("lt.objs.plugins","loaded-files","lt.objs.plugins/loaded-files",2343697626).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)),path_12170__$2));
}
})()))
{try{lt.util.load.js.call(null,path_12170__$2,true);
lt.object.update_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","loaded-files","lt.objs.plugins/loaded-files",2343697626)], null),((function (seq__12164,chunk__12165,count__12166,i__12167,path_12170__$2,path__$1){
return (function (p1__12153_SHARP_){return cljs.core.conj.call(null,(function (){var or__3520__auto__ = p1__12153_SHARP_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentHashSet.EMPTY;
}
})(),path_12170__$2);
});})(seq__12164,chunk__12165,count__12166,i__12167,path_12170__$2,path__$1))
);
}catch (e12168){var e_12171 = e12168;lt.objs.console.error.call(null,[cljs.core.str("Error loading JS file: "),cljs.core.str(path_12170__$2),cljs.core.str(" : "),cljs.core.str(e_12171)].join(''),e_12171);
}} else
{}
{
var G__12172 = seq__12164;
var G__12173 = chunk__12165;
var G__12174 = count__12166;
var G__12175 = (i__12167 + 1);
seq__12164 = G__12172;
chunk__12165 = G__12173;
count__12166 = G__12174;
i__12167 = G__12175;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__12164);if(temp__4092__auto__)
{var seq__12164__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12164__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__12164__$1);{
var G__12176 = cljs.core.chunk_rest.call(null,seq__12164__$1);
var G__12177 = c__4262__auto__;
var G__12178 = cljs.core.count.call(null,c__4262__auto__);
var G__12179 = 0;
seq__12164 = G__12176;
chunk__12165 = G__12177;
count__12166 = G__12178;
i__12167 = G__12179;
continue;
}
} else
{var path__$1 = cljs.core.first.call(null,seq__12164__$1);var path_12180__$2 = lt.objs.plugins.adjust_path.call(null,path__$1);if(cljs.core.truth_((function (){var or__3520__auto__ = lt.util.load._STAR_force_reload_STAR_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.Keyword("lt.objs.plugins","loaded-files","lt.objs.plugins/loaded-files",2343697626).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)),path_12180__$2));
}
})()))
{try{lt.util.load.js.call(null,path_12180__$2,true);
lt.object.update_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","loaded-files","lt.objs.plugins/loaded-files",2343697626)], null),((function (seq__12164,chunk__12165,count__12166,i__12167,path_12180__$2,path__$1,seq__12164__$1,temp__4092__auto__){
return (function (p1__12153_SHARP_){return cljs.core.conj.call(null,(function (){var or__3520__auto__ = p1__12153_SHARP_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentHashSet.EMPTY;
}
})(),path_12180__$2);
});})(seq__12164,chunk__12165,count__12166,i__12167,path_12180__$2,path__$1,seq__12164__$1,temp__4092__auto__))
);
}catch (e12169){var e_12181 = e12169;lt.objs.console.error.call(null,[cljs.core.str("Error loading JS file: "),cljs.core.str(path_12180__$2),cljs.core.str(" : "),cljs.core.str(e_12181)].join(''),e_12181);
}} else
{}
{
var G__12182 = cljs.core.next.call(null,seq__12164__$1);
var G__12183 = null;
var G__12184 = 0;
var G__12185 = 0;
seq__12164 = G__12182;
chunk__12165 = G__12183;
count__12166 = G__12184;
i__12167 = G__12185;
continue;
}
}
} else
{return null;
}
}
break;
}
}finally {lt.util.load._STAR_force_reload_STAR_ = _STAR_force_reload_STAR_12163;
lt.objs.plugins._STAR_plugin_dir_STAR_ = _STAR_plugin_dir_STAR_12162;
}});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","load-js","lt.objs.plugins/load-js",3701155451),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__load_js,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Load javascript file(s)",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"path(s)"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant-load","object.instant-load",4025433875),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.plugins.__BEH__load_css = (function __BEH__load_css(this$,path){var paths = cljs.core.map.call(null,lt.objs.plugins.adjust_path,((cljs.core.coll_QMARK_.call(null,path))?path:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [path], null)));var seq__12191 = cljs.core.seq.call(null,paths);var chunk__12192 = null;var count__12193 = 0;var i__12194 = 0;while(true){
if((i__12194 < count__12193))
{var path__$1 = cljs.core._nth.call(null,chunk__12192,i__12194);if(cljs.core.truth_((function (){var or__3520__auto__ = lt.util.load._STAR_force_reload_STAR_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.Keyword("lt.objs.plugins","loaded-files","lt.objs.plugins/loaded-files",2343697626).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)),path__$1));
}
})()))
{lt.object.update_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","loaded-files","lt.objs.plugins/loaded-files",2343697626)], null),((function (seq__12191,chunk__12192,count__12193,i__12194,path__$1){
return (function (p1__12186_SHARP_){return cljs.core.conj.call(null,(function (){var or__3520__auto__ = p1__12186_SHARP_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentHashSet.EMPTY;
}
})(),path__$1);
});})(seq__12191,chunk__12192,count__12193,i__12194,path__$1))
);
lt.util.load.css.call(null,path__$1);
} else
{}
{
var G__12195 = seq__12191;
var G__12196 = chunk__12192;
var G__12197 = count__12193;
var G__12198 = (i__12194 + 1);
seq__12191 = G__12195;
chunk__12192 = G__12196;
count__12193 = G__12197;
i__12194 = G__12198;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__12191);if(temp__4092__auto__)
{var seq__12191__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12191__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__12191__$1);{
var G__12199 = cljs.core.chunk_rest.call(null,seq__12191__$1);
var G__12200 = c__4262__auto__;
var G__12201 = cljs.core.count.call(null,c__4262__auto__);
var G__12202 = 0;
seq__12191 = G__12199;
chunk__12192 = G__12200;
count__12193 = G__12201;
i__12194 = G__12202;
continue;
}
} else
{var path__$1 = cljs.core.first.call(null,seq__12191__$1);if(cljs.core.truth_((function (){var or__3520__auto__ = lt.util.load._STAR_force_reload_STAR_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.Keyword("lt.objs.plugins","loaded-files","lt.objs.plugins/loaded-files",2343697626).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)),path__$1));
}
})()))
{lt.object.update_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","loaded-files","lt.objs.plugins/loaded-files",2343697626)], null),((function (seq__12191,chunk__12192,count__12193,i__12194,path__$1,seq__12191__$1,temp__4092__auto__){
return (function (p1__12186_SHARP_){return cljs.core.conj.call(null,(function (){var or__3520__auto__ = p1__12186_SHARP_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentHashSet.EMPTY;
}
})(),path__$1);
});})(seq__12191,chunk__12192,count__12193,i__12194,path__$1,seq__12191__$1,temp__4092__auto__))
);
lt.util.load.css.call(null,path__$1);
} else
{}
{
var G__12203 = cljs.core.next.call(null,seq__12191__$1);
var G__12204 = null;
var G__12205 = 0;
var G__12206 = 0;
seq__12191 = G__12203;
chunk__12192 = G__12204;
count__12193 = G__12205;
i__12194 = G__12206;
continue;
}
}
} else
{return null;
}
}
break;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","load-css","lt.objs.plugins/load-css",934792943),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__load_css,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Load css file(s)",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"path(s)"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.plugins.__BEH__load_keymap = (function __BEH__load_keymap(this$,path){var path__$1 = lt.objs.plugins.adjust_path.call(null,path);if(cljs.core.truth_(new cljs.core.Keyword("lt.objs.plugins","keymaps","lt.objs.plugins/keymaps",4718281889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$))))
{return lt.object.update_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","keymaps","lt.objs.plugins/keymaps",4718281889)], null),cljs.core.conj,path__$1);
} else
{return lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("lt.objs.plugins","keymaps","lt.objs.plugins/keymaps",4718281889),cljs.core.PersistentHashSet.fromArray([path__$1], true)], null));
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","load-keymap","lt.objs.plugins/load-keymap",1368994999),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__load_keymap,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Load a keymap file",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"path"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.plugins.__BEH__check_for_plugin_file = (function __BEH__check_for_plugin_file(this$){var path = new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)));var plugin_edn = (function (){var or__3520__auto__ = lt.objs.files.walk_up_find.call(null,path,"plugin.json");if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return lt.objs.files.walk_up_find.call(null,path,"plugin.edn");
}
})();if(cljs.core.truth_(plugin_edn))
{lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("lt.objs.plugins","plugin-path","lt.objs.plugins/plugin-path",2063828362),lt.objs.files.parent.call(null,plugin_edn)], null));
return lt.object.add_tags.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"plugin.file","plugin.file",1865693897)], null));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.plugins","check-for-plugin-file","lt.objs.plugins/check-for-plugin-file",3384140800),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.plugins.__BEH__check_for_plugin_file,new cljs.core.Keyword(null,"desc","desc",1016984067),"Plugin: Determine if this is a plugin file",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"create","create",3956577390),null], null), null));
lt.object.tag_behaviors.call(null,new cljs.core.Keyword(null,"app","app",1014001043),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.plugins","init-plugins","lt.objs.plugins/init-plugins",4096325174),new cljs.core.Keyword("lt.objs.plugins","plugin-behavior-diffs","lt.objs.plugins/plugin-behavior-diffs",1511349728),new cljs.core.Keyword("lt.objs.plugins","plugin-keymap-diffs","lt.objs.plugins/plugin-keymap-diffs",4431416675)], null));
