// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.deploy');
goog.require('cljs.core');
goog.require('lt.util.cljs');
goog.require('lt.util.js');
goog.require('lt.objs.app');
goog.require('lt.objs.sidebar.command');
goog.require('lt.objs.files');
goog.require('lt.util.js');
goog.require('lt.objs.platform');
goog.require('lt.objs.popup');
goog.require('lt.objs.cache');
goog.require('lt.objs.popup');
goog.require('lt.objs.notifos');
goog.require('lt.objs.notifos');
goog.require('clojure.string');
goog.require('lt.util.cljs');
goog.require('lt.objs.platform');
goog.require('lt.objs.files');
goog.require('lt.objs.app');
goog.require('lt.objs.clients');
goog.require('lt.util.load');
goog.require('clojure.string');
goog.require('lt.object');
goog.require('lt.object');
goog.require('lt.util.load');
goog.require('lt.objs.console');
goog.require('lt.objs.console');
goog.require('lt.objs.cache');
goog.require('lt.objs.clients');
goog.require('lt.objs.sidebar.command');
goog.require('fetch.core');
goog.require('fetch.core');
lt.objs.deploy.shell = lt.util.load.node_module.call(null,"shelljs");
lt.objs.deploy.fs = require("fs");
lt.objs.deploy.zlib = require("zlib");
lt.objs.deploy.request = lt.util.load.node_module.call(null,"request");
lt.objs.deploy.tar = lt.util.load.node_module.call(null,"tar");
lt.objs.deploy.home_path = lt.objs.files.lt_home.call(null,"");
lt.objs.deploy.tar_path = (function tar_path(v){if(cljs.core.truth_(lt.objs.cache.fetch.call(null,new cljs.core.Keyword(null,"edge","edge",1017012527))))
{return [cljs.core.str("https://api.github.com/repos/LightTable/LightTable/tarball/master")].join('');
} else
{return [cljs.core.str("https://api.github.com/repos/LightTable/LightTable/tarball/"),cljs.core.str(v)].join('');
}
});
lt.objs.deploy.version_regex = /^\d+\.\d+\.\d+(-.*)?$/;
lt.objs.deploy.get_versions = (function get_versions(){var vstr = new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(lt.objs.files.open_sync.call(null,lt.objs.files.lt_home.call(null,"core/version.json")));return cljs.core.js__GT_clj.call(null,JSON.parse(vstr),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",4191781672),true);
});
lt.objs.deploy.proxy_QMARK_ = (function proxy_QMARK_(){var p = lt.objs.deploy.get_proxy.call(null,lt.objs.deploy.tar_path.call(null,"0.5.0"));if(lt.util.cljs.str_contains_QMARK_.call(null,p,"PROXY"))
{return cljs.core.second.call(null,clojure.string.split.call(null,p," "));
} else
{return null;
}
});
lt.objs.deploy.version_timeout = ((60 * 60) * 1000);
lt.objs.deploy.version = lt.objs.deploy.get_versions.call(null);
lt.objs.deploy.str__GT_version = (function str__GT_version(s){var vec__12297 = clojure.string.split.call(null,s,".");var major = cljs.core.nth.call(null,vec__12297,0,null);var minor = cljs.core.nth.call(null,vec__12297,1,null);var patch = cljs.core.nth.call(null,vec__12297,2,null);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"major","major",1117563179),parseInt(major),new cljs.core.Keyword(null,"minor","minor",1117805351),parseInt(minor),new cljs.core.Keyword(null,"patch","patch",1120342970),parseInt(patch)], null);
});
lt.objs.deploy.compare_versions = (function compare_versions(v1,v2){if(cljs.core._EQ_.call(null,v1,v2))
{return false;
} else
{return !(((new cljs.core.Keyword(null,"major","major",1117563179).cljs$core$IFn$_invoke$arity$1(v2) < new cljs.core.Keyword(null,"major","major",1117563179).cljs$core$IFn$_invoke$arity$1(v1))) || ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"major","major",1117563179).cljs$core$IFn$_invoke$arity$1(v2),new cljs.core.Keyword(null,"major","major",1117563179).cljs$core$IFn$_invoke$arity$1(v1))) && ((new cljs.core.Keyword(null,"minor","minor",1117805351).cljs$core$IFn$_invoke$arity$1(v2) < new cljs.core.Keyword(null,"minor","minor",1117805351).cljs$core$IFn$_invoke$arity$1(v1)))) || ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"major","major",1117563179).cljs$core$IFn$_invoke$arity$1(v2),new cljs.core.Keyword(null,"major","major",1117563179).cljs$core$IFn$_invoke$arity$1(v1))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"minor","minor",1117805351).cljs$core$IFn$_invoke$arity$1(v2),new cljs.core.Keyword(null,"minor","minor",1117805351).cljs$core$IFn$_invoke$arity$1(v1))) && ((new cljs.core.Keyword(null,"patch","patch",1120342970).cljs$core$IFn$_invoke$arity$1(v2) < new cljs.core.Keyword(null,"patch","patch",1120342970).cljs$core$IFn$_invoke$arity$1(v1)))));
}
});
/**
* Returns true if second version is newer/greater than first version.
*/
lt.objs.deploy.is_newer_QMARK_ = (function is_newer_QMARK_(v1,v2){return lt.objs.deploy.compare_versions.call(null,lt.objs.deploy.str__GT_version.call(null,v1),lt.objs.deploy.str__GT_version.call(null,v2));
});
lt.objs.deploy.download_file = (function download_file(from,to,cb){var options = (function (){var obj12303 = {"url":from,"headers":(function (){var obj12305 = {"User-Agent":"Light Table"};return obj12305;
})()};return obj12303;
})();var out = lt.objs.deploy.fs.createWriteStream(to);var temp__4092__auto___12306 = (function (){var or__3520__auto__ = process.env.http_proxy;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return process.env.https_proxy;
}
})();if(cljs.core.truth_(temp__4092__auto___12306))
{var proxy_12307 = temp__4092__auto___12306;options.proxy = proxy_12307;
} else
{}
return lt.objs.deploy.request.get(options,cb).on("response",(function (resp){if(cljs.core._EQ_.call(null,resp.statusCode,200))
{return null;
} else
{lt.objs.notifos.done_working.call(null);
throw (new Error([cljs.core.str("Error downloading: "),cljs.core.str(from),cljs.core.str(" status code: "),cljs.core.str(resp.statusCode)].join('')));
}
})).pipe(out);
});
lt.objs.deploy.download_zip = (function download_zip(ver,cb){var n = lt.objs.notifos.working.call(null,[cljs.core.str("Downloading version "),cljs.core.str(ver),cljs.core.str(" ..")].join(''));return lt.objs.deploy.download_file.call(null,lt.objs.deploy.tar_path.call(null,ver),[cljs.core.str(lt.objs.deploy.home_path),cljs.core.str("/tmp.tar.gz")].join(''),(function (e,r,body){lt.objs.notifos.done_working.call(null);
return cb.call(null,e,r,body);
}));
});
lt.objs.deploy.untar = (function untar(from,to,cb){var t = lt.objs.deploy.fs.createReadStream(from);return t.pipe(lt.objs.deploy.zlib.createGunzip()).pipe(lt.objs.deploy.tar.Extract((function (){var obj12311 = {"path":to};return obj12311;
})())).on("end",cb);
});
lt.objs.deploy.move_tmp = (function move_tmp(){var parent_dir_12320 = cljs.core.first.call(null,lt.objs.files.full_path_ls.call(null,[cljs.core.str(lt.objs.deploy.home_path),cljs.core.str("/tmp/")].join('')));var seq__12316_12321 = cljs.core.seq.call(null,lt.objs.files.full_path_ls.call(null,[cljs.core.str(parent_dir_12320),cljs.core.str("/deploy/")].join('')));var chunk__12317_12322 = null;var count__12318_12323 = 0;var i__12319_12324 = 0;while(true){
if((i__12319_12324 < count__12318_12323))
{var file_12325 = cljs.core._nth.call(null,chunk__12317_12322,i__12319_12324);lt.objs.deploy.shell.cp("-rf",file_12325,lt.objs.deploy.home_path);
{
var G__12326 = seq__12316_12321;
var G__12327 = chunk__12317_12322;
var G__12328 = count__12318_12323;
var G__12329 = (i__12319_12324 + 1);
seq__12316_12321 = G__12326;
chunk__12317_12322 = G__12327;
count__12318_12323 = G__12328;
i__12319_12324 = G__12329;
continue;
}
} else
{var temp__4092__auto___12330 = cljs.core.seq.call(null,seq__12316_12321);if(temp__4092__auto___12330)
{var seq__12316_12331__$1 = temp__4092__auto___12330;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12316_12331__$1))
{var c__4262__auto___12332 = cljs.core.chunk_first.call(null,seq__12316_12331__$1);{
var G__12333 = cljs.core.chunk_rest.call(null,seq__12316_12331__$1);
var G__12334 = c__4262__auto___12332;
var G__12335 = cljs.core.count.call(null,c__4262__auto___12332);
var G__12336 = 0;
seq__12316_12321 = G__12333;
chunk__12317_12322 = G__12334;
count__12318_12323 = G__12335;
i__12319_12324 = G__12336;
continue;
}
} else
{var file_12337 = cljs.core.first.call(null,seq__12316_12331__$1);lt.objs.deploy.shell.cp("-rf",file_12337,lt.objs.deploy.home_path);
{
var G__12338 = cljs.core.next.call(null,seq__12316_12331__$1);
var G__12339 = null;
var G__12340 = 0;
var G__12341 = 0;
seq__12316_12321 = G__12338;
chunk__12317_12322 = G__12339;
count__12318_12323 = G__12340;
i__12319_12324 = G__12341;
continue;
}
}
} else
{}
}
break;
}
return lt.objs.deploy.shell.rm("-rf",[cljs.core.str(lt.objs.deploy.home_path),cljs.core.str("/tmp*")].join(''));
});
lt.objs.deploy.fetch_and_deploy = (function fetch_and_deploy(ver){return lt.objs.deploy.download_zip.call(null,ver,(function (){lt.objs.notifos.working.call(null,"Extracting update...");
return lt.objs.deploy.untar.call(null,[cljs.core.str(lt.objs.deploy.home_path),cljs.core.str("/tmp.tar.gz")].join(''),[cljs.core.str(lt.objs.deploy.home_path),cljs.core.str("/tmp")].join(''),(function (){lt.objs.deploy.move_tmp.call(null);
lt.objs.notifos.done_working.call(null);
lt.objs.deploy.version = cljs.core.assoc.call(null,lt.objs.deploy.version,new cljs.core.Keyword(null,"version","version",1365512266),ver);
return lt.objs.popup.popup_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",4087600639),"Light Table has been updated!",new cljs.core.Keyword(null,"body","body",1016933652),[cljs.core.str("Light Table has been updated to "),cljs.core.str(ver),cljs.core.str("! Just\n                                                         restart to get the latest and greatest.")].join(''),new cljs.core.Keyword(null,"buttons","buttons",1255256819),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"ok"], null)], null)], null));
}));
}));
});
lt.objs.deploy.tags_url = "https://api.github.com/repos/LightTable/LightTable/tags";
lt.objs.deploy.should_update_popup = (function should_update_popup(data){return lt.objs.popup.popup_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",4087600639),"There's a newer version of Light Table!",new cljs.core.Keyword(null,"body","body",1016933652),[cljs.core.str("Would you like us to download and install version "),cljs.core.str(data),cljs.core.str("?")].join(''),new cljs.core.Keyword(null,"buttons","buttons",1255256819),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"Cancel"], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Download and install",new cljs.core.Keyword(null,"action","action",3885920680),(function (){return lt.objs.deploy.fetch_and_deploy.call(null,data);
})], null)], null)], null));
});
/**
* Returns latest LT version for github api tags endpoint.
*/
lt.objs.deploy.__GT_latest_version = (function __GT_latest_version(body){var temp__4092__auto__ = (function (){try{return JSON.parse(body);
}catch (e12344){var e = e12344;return lt.objs.console.error.call(null,[cljs.core.str("Invalid JSON response from "),cljs.core.str(lt.objs.deploy.tags_url),cljs.core.str(": "),cljs.core.str(cljs.core.pr_str.call(null,body))].join(''));
}})();if(cljs.core.truth_(temp__4092__auto__))
{var parsed_body = temp__4092__auto__;return cljs.core.last.call(null,cljs.core.sort.call(null,cljs.core.keep.call(null,(function (p1__12342_SHARP_){if(cljs.core.truth_(cljs.core.re_find.call(null,lt.objs.deploy.version_regex,p1__12342_SHARP_.name)))
{return p1__12342_SHARP_.name;
} else
{return null;
}
}),parsed_body)));
} else
{return null;
}
});
/**
* @param {...*} var_args
*/
lt.objs.deploy.check_version = (function() { 
var check_version__delegate = function (p__12345){var vec__12347 = p__12345;var notify_QMARK_ = cljs.core.nth.call(null,vec__12347,0,null);return fetch.core.xhr.call(null,lt.objs.deploy.tags_url,cljs.core.PersistentArrayMap.EMPTY,(function (data){var latest_version = lt.objs.deploy.__GT_latest_version.call(null,data);if(cljs.core.truth_(cljs.core.re_find.call(null,lt.objs.deploy.version_regex,latest_version)))
{if(cljs.core.truth_((function (){var and__3508__auto__ = cljs.core.not_EQ_.call(null,latest_version,"");if(and__3508__auto__)
{var and__3508__auto____$1 = cljs.core.not_EQ_.call(null,latest_version,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(lt.objs.deploy.version));if(and__3508__auto____$1)
{var and__3508__auto____$2 = lt.objs.deploy.is_newer_QMARK_.call(null,new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(lt.objs.deploy.version),latest_version);if(and__3508__auto____$2)
{var or__3520__auto__ = notify_QMARK_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.not_EQ_.call(null,localStorage.fetchedVersion,latest_version);
}
} else
{return and__3508__auto____$2;
}
} else
{return and__3508__auto____$1;
}
} else
{return and__3508__auto__;
}
})()))
{localStorage.fetchedVersion = latest_version;
return lt.objs.deploy.should_update_popup.call(null,latest_version);
} else
{if(cljs.core.truth_(notify_QMARK_))
{return lt.objs.notifos.set_msg_BANG_.call(null,[cljs.core.str("At latest version: "),cljs.core.str(new cljs.core.Keyword(null,"version","version",1365512266).cljs$core$IFn$_invoke$arity$1(lt.objs.deploy.version))].join(''));
} else
{return null;
}
}
} else
{return null;
}
}));
};
var check_version = function (var_args){
var p__12345 = null;if (arguments.length > 0) {
  p__12345 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return check_version__delegate.call(this,p__12345);};
check_version.cljs$lang$maxFixedArity = 0;
check_version.cljs$lang$applyTo = (function (arglist__12348){
var p__12345 = cljs.core.seq(arglist__12348);
return check_version__delegate(p__12345);
});
check_version.cljs$core$IFn$_invoke$arity$variadic = check_version__delegate;
return check_version;
})()
;
/**
* Binary/electron version. The two versions are in sync since binaries updates
* only occur with electron updates.
*/
lt.objs.deploy.binary_version = (function binary_version(){return (process.versions["electron"]);
});
/**
* @param {...*} var_args
*/
lt.objs.deploy.button = (function() { 
var button__delegate = function (label,p__12349){var vec__12357 = p__12349;var cb = cljs.core.nth.call(null,vec__12357,0,null);var e__3325__auto__ = crate.core.html.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.button.right","div.button.right",629503503),label], null));var seq__12358_12364 = cljs.core.seq.call(null,cljs.core.partition.call(null,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"click","click",1108654330),(function (){if(cljs.core.truth_(cb))
{return cb.call(null);
} else
{return null;
}
})], null)));var chunk__12359_12365 = null;var count__12360_12366 = 0;var i__12361_12367 = 0;while(true){
if((i__12361_12367 < count__12360_12366))
{var vec__12362_12368 = cljs.core._nth.call(null,chunk__12359_12365,i__12361_12367);var ev__3326__auto___12369 = cljs.core.nth.call(null,vec__12362_12368,0,null);var func__3327__auto___12370 = cljs.core.nth.call(null,vec__12362_12368,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___12369,func__3327__auto___12370);
{
var G__12371 = seq__12358_12364;
var G__12372 = chunk__12359_12365;
var G__12373 = count__12360_12366;
var G__12374 = (i__12361_12367 + 1);
seq__12358_12364 = G__12371;
chunk__12359_12365 = G__12372;
count__12360_12366 = G__12373;
i__12361_12367 = G__12374;
continue;
}
} else
{var temp__4092__auto___12375 = cljs.core.seq.call(null,seq__12358_12364);if(temp__4092__auto___12375)
{var seq__12358_12376__$1 = temp__4092__auto___12375;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12358_12376__$1))
{var c__4262__auto___12377 = cljs.core.chunk_first.call(null,seq__12358_12376__$1);{
var G__12378 = cljs.core.chunk_rest.call(null,seq__12358_12376__$1);
var G__12379 = c__4262__auto___12377;
var G__12380 = cljs.core.count.call(null,c__4262__auto___12377);
var G__12381 = 0;
seq__12358_12364 = G__12378;
chunk__12359_12365 = G__12379;
count__12360_12366 = G__12380;
i__12361_12367 = G__12381;
continue;
}
} else
{var vec__12363_12382 = cljs.core.first.call(null,seq__12358_12376__$1);var ev__3326__auto___12383 = cljs.core.nth.call(null,vec__12363_12382,0,null);var func__3327__auto___12384 = cljs.core.nth.call(null,vec__12363_12382,1,null);lt.util.dom.on.call(null,e__3325__auto__,ev__3326__auto___12383,func__3327__auto___12384);
{
var G__12385 = cljs.core.next.call(null,seq__12358_12376__$1);
var G__12386 = null;
var G__12387 = 0;
var G__12388 = 0;
seq__12358_12364 = G__12385;
chunk__12359_12365 = G__12386;
count__12360_12366 = G__12387;
i__12361_12367 = G__12388;
continue;
}
}
} else
{}
}
break;
}
return e__3325__auto__;
};
var button = function (label,var_args){
var p__12349 = null;if (arguments.length > 1) {
  p__12349 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return button__delegate.call(this,label,p__12349);};
button.cljs$lang$maxFixedArity = 1;
button.cljs$lang$applyTo = (function (arglist__12389){
var label = cljs.core.first(arglist__12389);
var p__12349 = cljs.core.rest(arglist__12389);
return button__delegate(label,p__12349);
});
button.cljs$core$IFn$_invoke$arity$variadic = button__delegate;
return button;
})()
;
lt.objs.deploy.alert_binary_update = (function alert_binary_update(){return lt.objs.popup.popup_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",4087600639),"There's been a binary update!",new cljs.core.Keyword(null,"body","body",1016933652),"There's a new version of the Light Table binary. Clicking below will open the\n                                 Light Table website so you can download the updated version.",new cljs.core.Keyword(null,"buttons","buttons",1255256819),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Download latest",new cljs.core.Keyword(null,"action","action",3885920680),(function (){lt.objs.platform.open_url.call(null,"http://www.lighttable.com");
return lt.objs.popup.remain_open.call(null);
})], null)], null)], null));
});
lt.objs.deploy.__BEH__check_deploy = (function __BEH__check_deploy(this$){if(lt.objs.deploy.is_newer_QMARK_.call(null,lt.objs.deploy.binary_version.call(null),new cljs.core.Keyword(null,"electron","electron",996780372).cljs$core$IFn$_invoke$arity$1(lt.objs.deploy.version)))
{return lt.objs.deploy.alert_binary_update.call(null);
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.deploy","check-deploy","lt.objs.deploy/check-deploy",1596260355),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.deploy.__BEH__check_deploy,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"deploy","deploy",3973538905),null], null), null));
lt.objs.deploy.__BEH__check_version = (function __BEH__check_version(this$){if(lt.objs.app.first_window_QMARK_.call(null))
{localStorage.fetchedVersion = null;
} else
{}
lt.objs.deploy.check_version.call(null);
return lt.util.js.every.call(null,lt.objs.deploy.version_timeout,lt.objs.deploy.check_version);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.deploy","check-version","lt.objs.deploy/check-version",3501318508),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.deploy.__BEH__check_version,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Automatically check for updates",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"init","init",1017141378),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.object.tag_behaviors.call(null,new cljs.core.Keyword(null,"app","app",1014001043),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.deploy","check-deploy","lt.objs.deploy/check-deploy",1596260355)], null));
