/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.asciidoctor.diagram.Charsets;
import org.asciidoctor.diagram.DiagramGenerator;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.MimeType;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.ResponseData;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

class Ditaa
implements DiagramGenerator {
    public static final MimeType DEFAULT_OUTPUT_FORMAT = MimeType.PNG;

    Ditaa() {
    }

    @Override
    public ResponseData generate(Request request) throws IOException {
        MimeType format = request.headers.getValue(HTTPHeader.ACCEPT);
        if (format == null) {
            format = DEFAULT_OUTPUT_FORMAT;
        }
        if (!format.equals(MimeType.PNG)) {
            throw new IOException("Unsupported output format: " + format);
        }
        ConversionOptions conversionOptions = new ConversionOptions();
        String optionString = request.headers.getValue(HTTPHeader.OPTIONS);
        if (optionString != null) {
            String[] options = optionString.split(" ");
            for (int i = 0; i < options.length; ++i) {
                String tabSize;
                String option = options[i];
                if (option.equals("--no-antialias") || option.equals("-A")) {
                    conversionOptions.renderingOptions.setAntialias(false);
                    continue;
                }
                if (option.equals("--no-separation") || option.equals("-E")) {
                    conversionOptions.processingOptions.setPerformSeparationOfCommonEdges(false);
                    continue;
                }
                if (option.equals("--round-corners") || option.equals("-r")) {
                    conversionOptions.processingOptions.setAllCornersAreRound(true);
                    continue;
                }
                if (option.equals("--no-shadows") || option.equals("-S")) {
                    conversionOptions.renderingOptions.setDropShadows(false);
                    continue;
                }
                if (option.equals("--debug") || option.equals("-d")) {
                    conversionOptions.renderingOptions.setRenderDebugLines(true);
                    continue;
                }
                if (option.equals("--fixed-slope") || option.equals("-W")) {
                    conversionOptions.renderingOptions.setFixedSlope(true);
                    continue;
                }
                if (option.equals("--transparent") || option.equals("-T")) {
                    conversionOptions.renderingOptions.setBackgroundColor(new Color(0, 0, 0, 0));
                    continue;
                }
                if ((option.equals("--background") || option.equals("-b")) && i < options.length - 1) {
                    try {
                        Color backgroundColor = ConversionOptions.parseColor((String)options[++i]);
                        conversionOptions.renderingOptions.setBackgroundColor(backgroundColor);
                    }
                    catch (IllegalArgumentException backgroundColor) {}
                    continue;
                }
                if ((option.equals("--scale") || option.equals("-s")) && i < options.length - 1) {
                    String scale = options[++i];
                    try {
                        float scaleFactor = Float.parseFloat(scale);
                        conversionOptions.renderingOptions.setScale(scaleFactor);
                    }
                    catch (NumberFormatException scaleFactor) {}
                    continue;
                }
                if ((option.equals("--tabs") || option.equals("-t")) && i < options.length - 1) {
                    tabSize = options[++i];
                    try {
                        int tabs = Integer.parseInt(tabSize);
                        conversionOptions.processingOptions.setTabSize(tabs);
                    }
                    catch (NumberFormatException tabs) {}
                    continue;
                }
                if (!option.equals("--tabs") && !option.equals("-t") || i >= options.length - 1) continue;
                tabSize = options[++i];
                try {
                    int tabs = Integer.parseInt(tabSize);
                    conversionOptions.processingOptions.setTabSize(tabs);
                    continue;
                }
                catch (NumberFormatException tabs) {
                    // empty catch block
                }
            }
        }
        conversionOptions.processingOptions.setCharacterEncoding(Charsets.UTF8.name());
        TextGrid textGrid = new TextGrid();
        textGrid.loadFrom((InputStream)new ByteArrayInputStream(request.asString().getBytes(Charsets.UTF8)), conversionOptions.processingOptions);
        Diagram diagram = new Diagram(textGrid, conversionOptions);
        BufferedImage image = new BitmapRenderer().renderToImage(diagram, conversionOptions.renderingOptions);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream cacheStream = new MemoryCacheImageOutputStream(out);
        ImageIO.write((RenderedImage)image, "png", out);
        cacheStream.flush();
        return new ResponseData(format, out.toByteArray());
    }
}

