/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.stathissideris.ascii2image.text.TextGrid;

public class GridPattern
extends TextGrid {
    private ArrayList<Pattern> regExps = new ArrayList();
    private static final boolean DEBUG = false;

    public GridPattern(String row1, String row2, String row3) {
        super(Math.max(Math.max(row1.length(), row2.length()), row3.length()), 3);
        if (this.getHeight() != 3) {
            throw new RuntimeException("This method can only be called for GridPatternS with height 3");
        }
        this.writeStringTo(0, 0, row1);
        this.writeStringTo(0, 1, row2);
        this.writeStringTo(0, 2, row3);
        this.prepareRegExps();
    }

    public boolean isMatchedBy(TextGrid grid) {
        for (int i = 0; i < grid.getHeight(); ++i) {
            String row = grid.getRow(i).toString();
            Pattern regexp = this.regExps.get(i);
            if (regexp.matcher(row).matches()) continue;
            return false;
        }
        return true;
    }

    private void prepareRegExps() {
        this.regExps.clear();
        Iterator<StringBuilder> it = this.getRows().iterator();
        while (it.hasNext()) {
            String row = it.next().toString();
            this.regExps.add(Pattern.compile(this.makeRegExp(row)));
        }
    }

    private String makeRegExp(String pattern) {
        StringBuilder result = new StringBuilder();
        int tokensHandled = 0;
        for (int i = 0; i < pattern.length() && tokensHandled < 3; ++tokensHandled, ++i) {
            char c = pattern.charAt(i);
            if (c == '[') {
                result.append("[^|:]");
                continue;
            }
            if (c == '|') {
                result.append("[|:]");
                continue;
            }
            if (c == '-') {
                result.append("[-=]");
                continue;
            }
            if (c == '!') {
                result.append("[^-=\\/\\\\+|:]");
                continue;
            }
            if (c == 'b') {
                result.append("[-=\\/\\\\+|:]");
                continue;
            }
            if (c == '^') {
                result.append("[\\/\\\\+|:]");
                continue;
            }
            if (c == '(') {
                result.append("[-=\\/\\\\+]");
                continue;
            }
            if (c == '~') {
                result.append(".");
                continue;
            }
            if (c == '+') {
                result.append("\\+");
                continue;
            }
            if (c == '\\') {
                result.append("\\\\");
                continue;
            }
            if (c == 's') {
                result.append("[-=+|:]");
                continue;
            }
            if (c == 'S') {
                result.append("[\\/\\\\]");
                continue;
            }
            if (c == '*') {
                result.append("\\*");
                continue;
            }
            if (c == '1') {
                result.append("[\\\\]");
                continue;
            }
            if (c == '2') {
                result.append("[|:+\\/\\\\]");
                continue;
            }
            if (c == '3') {
                result.append("[\\/]");
                continue;
            }
            if (c == '4') {
                result.append("[-=+\\/\\\\]");
                continue;
            }
            if (c == '5') {
                result.append("[\\\\]");
                continue;
            }
            if (c == '6') {
                result.append("[|:+\\/\\\\]");
                continue;
            }
            if (c == '7') {
                result.append("[\\/]");
                continue;
            }
            if (c == '8') {
                result.append("[-=+\\/\\\\]");
                continue;
            }
            if (c == '%') {
                if (i + 1 > pattern.length()) {
                    throw new RuntimeException("Invalid pattern, found % at the end");
                }
                if ((c = pattern.charAt(++i)) == '1') {
                    result.append("[^\\\\]");
                    continue;
                }
                if (c == '2') {
                    result.append("[^|:+\\/\\\\]");
                    continue;
                }
                if (c == '3') {
                    result.append("[^\\/]");
                    continue;
                }
                if (c == '4') {
                    result.append("[^-=+\\/\\\\]");
                    continue;
                }
                if (c == '5') {
                    result.append("[^\\\\]");
                    continue;
                }
                if (c == '6') {
                    result.append("[^|:+\\/\\\\]");
                    continue;
                }
                if (c == '7') {
                    result.append("[^\\/]");
                    continue;
                }
                if (c != '8') continue;
                result.append("[^-=+\\/\\\\]");
                continue;
            }
            result.append(String.valueOf(c));
        }
        return result.toString();
    }
}

