/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.core.RenderingOptions;

public class ConversionOptions {
    public ProcessingOptions processingOptions = new ProcessingOptions();
    public RenderingOptions renderingOptions = new RenderingOptions();

    public void setDebug(boolean value) {
        this.processingOptions.setPrintDebugOutput(value);
        this.renderingOptions.setRenderDebugLines(value);
    }

    public ConversionOptions() {
    }

    public static Color parseColor(String hexString) {
        if (hexString.length() == 6) {
            return new Color(Integer.parseInt(hexString, 16));
        }
        if (hexString.length() == 8) {
            return new Color(Integer.parseInt(hexString.substring(0, 2), 16), Integer.parseInt(hexString.substring(2, 4), 16), Integer.parseInt(hexString.substring(4, 6), 16), Integer.parseInt(hexString.substring(6, 8), 16));
        }
        throw new IllegalArgumentException("Cannot interpret \"" + hexString + "\" as background colour. It needs to be a 6- or 8-digit hex number, depending on whether you have transparency or not (same as HTML).");
    }

    public ConversionOptions(Map<String, String> cmdLine) throws UnsupportedEncodingException {
        String encoding;
        this.processingOptions.setVerbose(cmdLine.containsKey("verbose"));
        this.renderingOptions.setDropShadows(!cmdLine.containsKey("no-shadows"));
        this.setDebug(cmdLine.containsKey("debug"));
        this.processingOptions.setOverwriteFiles(cmdLine.containsKey("overwrite"));
        if (cmdLine.containsKey("scale")) {
            Float scale = Float.valueOf(Float.parseFloat(cmdLine.get("scale")));
            this.renderingOptions.setScale(scale.floatValue());
        }
        this.processingOptions.setAllCornersAreRound(cmdLine.containsKey("round-corners"));
        this.processingOptions.setPerformSeparationOfCommonEdges(!cmdLine.containsKey("no-separation"));
        this.renderingOptions.setAntialias(!cmdLine.containsKey("no-antialias"));
        this.renderingOptions.setFixedSlope(cmdLine.containsKey("fixed-slope"));
        if (cmdLine.containsKey("background")) {
            String b = cmdLine.get("background");
            Color background = ConversionOptions.parseColor(b);
            this.renderingOptions.setBackgroundColor(background);
        }
        if (cmdLine.containsKey("transparent")) {
            this.renderingOptions.setBackgroundColor(new Color(0, 0, 0, 0));
        }
        if (cmdLine.containsKey("tabs")) {
            Integer tabSize = Integer.parseInt(cmdLine.get("tabs"));
            int tabSizeValue = tabSize;
            if (tabSizeValue < 0) {
                tabSizeValue = 0;
            }
            this.processingOptions.setTabSize(tabSizeValue);
        }
        if ((encoding = cmdLine.get("encoding")) != null) {
            new String(new byte[2], encoding);
            this.processingOptions.setCharacterEncoding(encoding);
        }
    }
}

