/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class CommandLineConverter {
    public static void main(String[] args) throws UnsupportedEncodingException {
        String test = "+--------+   +-------+    +-------+\n|        | --+ ditaa +--> |       |\n|  Text  |   +-------+    |diagram|\n|Document|   |!magic!|    |       |\n|     {d}|   |       |    |       |\n+---+----+   +-------+    +-------+\n    :                         ^\n    |       Lots of work      |\n    +-------------------------+";
        CommandLineConverter.convert(new String[]{"-e", "UTF-8"}, new ByteArrayInputStream(test.getBytes("UTF-8")), new ByteArrayOutputStream());
    }

    public static int convert(String[] args, InputStream input, OutputStream output) {
        try {
            return CommandLineConverter.doConvert(args, input, output);
        }
        catch (RuntimeException e) {
            CommandLineConverter.printException(e, output);
            return 1;
        }
    }

    private static int doConvert(String[] args, InputStream input, OutputStream output) {
        ConversionOptions options;
        HashMap<String, String> cmdLine = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-v") || arg.equals("--verbose")) {
                cmdLine.put("verbose", "true");
                continue;
            }
            if (arg.equals("-o") || arg.equals("--overwrite")) {
                cmdLine.put("overwrite", "true");
                continue;
            }
            if (arg.equals("-S") || arg.equals("--no-shadows")) {
                cmdLine.put("no-shadows", "true");
                continue;
            }
            if (arg.equals("-A") || arg.equals("--no-antialias")) {
                cmdLine.put("no-antialias", "true");
                continue;
            }
            if (arg.equals("-W") || arg.equals("--fixed-slope")) {
                cmdLine.put("fixed-slope", "true");
                continue;
            }
            if (arg.equals("-d") || arg.equals("--debug")) {
                cmdLine.put("debug", "true");
                continue;
            }
            if (arg.equals("-r") || arg.equals("--round-corners")) {
                cmdLine.put("round-corners", "true");
                continue;
            }
            if (arg.equals("-E") || arg.equals("--no-separation")) {
                cmdLine.put("no-separation", "true");
                continue;
            }
            if (arg.equals("-T") || arg.equals("--transparent")) {
                cmdLine.put("transparent", "true");
                continue;
            }
            if (arg.equals("-e") || arg.equals("--encoding")) {
                cmdLine.put("encoding", args[++i]);
                continue;
            }
            if (arg.equals("-s") || arg.equals("--scale")) {
                cmdLine.put("scale", args[++i]);
                continue;
            }
            if (arg.equals("-t") || arg.equals("--tabs")) {
                cmdLine.put("tabs", args[++i]);
                continue;
            }
            if (!arg.equals("-b") && !arg.equals("--background")) continue;
            cmdLine.put("background", args[++i]);
        }
        try {
            options = new ConversionOptions(cmdLine);
        }
        catch (UnsupportedEncodingException e2) {
            CommandLineConverter.printException(e2, output);
            return 2;
        }
        catch (IllegalArgumentException e2) {
            CommandLineConverter.printException(e2, output);
            return 2;
        }
        TextGrid grid = new TextGrid();
        if (options.processingOptions.getCustomShapes() != null) {
            grid.addToMarkupTags(options.processingOptions.getCustomShapes().keySet());
        }
        try {
            grid.loadFrom(input, options.processingOptions);
        }
        catch (UnsupportedEncodingException e1) {
            CommandLineConverter.printException(e1, output);
            return 1;
        }
        catch (IOException e1) {
            CommandLineConverter.printException(e1, output);
            return 1;
        }
        if (options.processingOptions.printDebugOutput()) {
            grid.printDebug();
        }
        Diagram diagram = new Diagram(grid, options);
        BufferedImage image = new BitmapRenderer().renderToImage(diagram, options.renderingOptions);
        try {
            MemoryCacheImageOutputStream memCache = new MemoryCacheImageOutputStream(output);
            ImageIO.write((RenderedImage)image, "png", memCache);
            memCache.flush();
        }
        catch (IOException e) {
            CommandLineConverter.printException(e, output);
            return 1;
        }
        return 0;
    }

    private static void printException(Exception e2, OutputStream output) {
        PrintStream printStream = new PrintStream(output);
        e2.printStackTrace(printStream);
        printStream.flush();
    }
}

