/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.svg.DriverCenteredCharacterSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverDotPathSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverEllipseSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverImagePng;
import net.sourceforge.plantuml.ugraphic.svg.DriverImageSvgSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverLineSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverPathSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverPolygonSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverRectangleSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverTextAsPathSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverTextSvg;

public class UGraphicSvg
extends AbstractUGraphic<SvgGraphics>
implements ClipContainer,
UGraphic2 {
    private final StringBounder stringBounder;
    private final boolean textAsPath2;
    private final String target;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicSvg(this);
    }

    private UGraphicSvg(UGraphicSvg other) {
        super(other);
        this.stringBounder = other.stringBounder;
        this.textAsPath2 = other.textAsPath2;
        this.target = other.target;
        this.register();
    }

    public UGraphicSvg(ColorMapper colorMapper, String backcolor, boolean textAsPath, double scale, String linkTarget) {
        this(colorMapper, new SvgGraphics(backcolor, scale), textAsPath, linkTarget);
    }

    public UGraphicSvg(ColorMapper colorMapper, boolean textAsPath, double scale, String linkTarget) {
        this(colorMapper, new SvgGraphics(scale), textAsPath, linkTarget);
    }

    public UGraphicSvg(ColorMapper mapper, HtmlColorGradient gr, boolean textAsPath, double scale, String linkTarget) {
        this(mapper, new SvgGraphics(scale), textAsPath, linkTarget);
        SvgGraphics svg = (SvgGraphics)this.getGraphicObject();
        svg.paintBackcolorGradient(mapper, gr);
    }

    @Override
    protected boolean manageHiddenAutomatically() {
        return false;
    }

    @Override
    protected void beforeDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(this.getParam().isHidden());
    }

    @Override
    protected void afterDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(false);
    }

    private UGraphicSvg(ColorMapper colorMapper, SvgGraphics svg, boolean textAsPath, String linkTarget) {
        super(colorMapper, svg);
        this.stringBounder = TextBlockUtils.getDummyStringBounder();
        this.textAsPath2 = textAsPath;
        this.target = linkTarget;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleSvg(this));
        if (this.textAsPath2) {
            this.registerDriver(UText.class, new DriverTextAsPathSvg(TextBlockUtils.getFontRenderContext(), this));
        } else {
            this.registerDriver(UText.class, new DriverTextSvg(this.getStringBounder(), this));
        }
        this.registerDriver(ULine.class, new DriverLineSvg(this));
        this.registerDriver(UPolygon.class, new DriverPolygonSvg(this));
        this.registerDriver(UEllipse.class, new DriverEllipseSvg(this));
        this.registerDriver(UImage.class, new DriverImagePng(this));
        this.registerDriver(UImageSvg.class, new DriverImageSvgSvg());
        this.registerDriver(UPath.class, new DriverPathSvg(this));
        this.registerDriver(DotPath.class, new DriverDotPathSvg());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterSvg());
    }

    public SvgGraphics getSvgGraphics() {
        return (SvgGraphics)this.getGraphicObject();
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public void createXml(OutputStream os) throws IOException {
        try {
            ((SvgGraphics)this.getGraphicObject()).createXml(os);
        }
        catch (TransformerException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public void startUrl(Url url) {
        ((SvgGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip(), this.target);
    }

    @Override
    public void closeAction() {
        ((SvgGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream os, String metadata, int dpi) throws IOException {
        this.createXml(os);
    }
}

