/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.ConnectedCircle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLollipopInterfaceEye1
extends AbstractEntityImage {
    private static final int SIZE = 24;
    private final TextBlock desc;
    private final Bibliotekon bibliotekon;
    private final Url url;

    public EntityImageLollipopInterfaceEye1(ILeaf entity, ISkinParam skinParam, Bibliotekon bibliotekon) {
        super(entity, skinParam);
        this.bibliotekon = bibliotekon;
        Stereotype stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.CLASS, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS, stereotype), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug = ug.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, this.getStereo())));
        ug = ug.apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBackground, this.getStereo())));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        double sizeSmall = 14.0;
        double diff = 5.0;
        UEllipse circle1 = new UEllipse(14.0, 14.0);
        if (this.getSkinParam().shadowing()) {
            // empty if block
        }
        ug.apply(new UStroke(1.5)).apply(new UTranslate(5.0, 5.0)).draw(circle1);
        ug = ug.apply(new UChangeBackColor(null));
        Point2D pos = this.bibliotekon.getShape(this.getEntity()).getPosition();
        List<Line> lines = this.bibliotekon.getAllLineConnectedTo(this.getEntity());
        UTranslate reverse = new UTranslate(pos).reverse();
        ConnectedCircle connectedCircle = new ConnectedCircle(12.0);
        for (Line line : lines) {
            Point2D pt = line.getMyPoint(this.getEntity());
            pt = reverse.getTranslated(pt);
            connectedCircle.addSecondaryConnection(pt);
        }
        connectedCircle.drawU(ug);
        if (this.url != null) {
            ug.closeAction();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

