/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityArrow
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final ULine line;
    private final Point2D contact;

    public ExtremityArrow(Point2D p1, double angle, Point2D center) {
        angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        int xAile = 9;
        int yOuverture = 4;
        this.polygon.addPoint(-9.0, -4.0);
        int xContact = 5;
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(angle + 1.5707963267948966);
        this.polygon = this.polygon.translate(p1.getX(), p1.getY());
        this.contact = new Point2D.Double(p1.getX() - 5.0 * Math.cos(angle + 1.5707963267948966), p1.getY() - 5.0 * Math.sin(angle + 1.5707963267948966));
        this.line = new ULine(center.getX() - this.contact.getX(), center.getY() - this.contact.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UChangeBackColor(ug.getParam().getColor()));
        ug.draw(this.polygon);
        if (this.line.getLength() > 2.0) {
            ug.apply(new UTranslate(this.contact.getX(), this.contact.getY())).draw(this.line);
        }
    }
}

