/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

public enum SingleStrategy {
    SQUARRE,
    HLINE,
    VLINE;


    public Collection<Link> generateLinks(List<ILeaf> standalones) {
        return this.putInSquare(standalones);
    }

    private Collection<Link> putInSquare(List<ILeaf> standalones) {
        ArrayList<Link> result = new ArrayList<Link>();
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();
        int branch = SingleStrategy.computeBranch(standalones.size());
        int headBranch = 0;
        for (int i = 1; i < standalones.size(); ++i) {
            Link link;
            IEntity ent1;
            int dist = i - headBranch;
            IEntity ent2 = standalones.get(i);
            if (dist == branch) {
                ent1 = standalones.get(headBranch);
                link = new Link(ent1, ent2, linkType, Display.NULL, 2);
                headBranch = i;
            } else {
                ent1 = standalones.get(i - 1);
                link = new Link(ent1, ent2, linkType, Display.NULL, 1);
            }
            result.add(link);
        }
        return Collections.unmodifiableCollection(result);
    }

    static int computeBranch(int size) {
        double sqrt = Math.sqrt(size);
        int r = (int)sqrt;
        if (r * r == size) {
            return r;
        }
        return r + 1;
    }
}

