/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ClusterDecoration {
    private final UStroke defaultStroke;
    private final PackageStyle style;
    private final USymbol symbol;
    private final TextBlock title;
    private final TextBlock stereo;
    private final HtmlColor stateBack;
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    public static final int marginTitleX1 = 3;
    public static final int marginTitleX2 = 3;
    public static final int marginTitleX3 = 7;
    public static final int marginTitleY0 = 0;
    public static final int marginTitleY1 = 3;
    public static final int marginTitleY2 = 3;

    public ClusterDecoration(PackageStyle style, USymbol symbol, TextBlock title, TextBlock stereo, HtmlColor stateBack, double minX, double minY, double maxX, double maxY, UStroke stroke) {
        this.symbol = symbol;
        this.style = style;
        this.stereo = stereo;
        this.title = title;
        this.stateBack = stateBack;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.defaultStroke = stroke;
    }

    public void drawU(UGraphic ug, HtmlColor borderColor, boolean shadowing) {
        if (this.symbol != null) {
            SymbolContext symbolContext = new SymbolContext(this.stateBack, borderColor).withShadow(shadowing).withStroke(this.defaultStroke);
            this.symbol.asBig(this.title, this.stereo, this.maxX - this.minX, this.maxY - this.minY, symbolContext).drawU(ug.apply(new UTranslate(this.minX, this.minY)));
            return;
        }
        if (this.style == PackageStyle.NODE) {
            this.drawWithTitleNode(ug, borderColor, shadowing);
        } else if (this.style == PackageStyle.CARD) {
            this.drawWithTitleCard(ug, borderColor, shadowing);
        } else if (this.style == PackageStyle.DATABASE) {
            this.drawWithTitleDatabase(ug, borderColor, shadowing);
        } else if (this.style == PackageStyle.CLOUD) {
            this.drawWithTitleCloud(ug, borderColor, shadowing);
        } else if (this.style == PackageStyle.FRAME) {
            this.drawWithTitleFrame(ug, borderColor, shadowing);
        } else if (this.style == PackageStyle.RECT) {
            this.drawWithTitleRect(ug, borderColor, shadowing);
        } else {
            this.drawWithTitleFolder(ug, borderColor, shadowing);
        }
    }

    private void drawWithTitleCloud(UGraphic ug, HtmlColor borderColor, boolean shadowing) {
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        double width = this.maxX - this.minX;
        double height = this.maxY - this.minY;
        ug = ug.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(borderColor));
        ug = ug.apply(this.defaultStroke);
        PackageStyle.CLOUD.drawU(ug.apply(new UTranslate(this.minX, this.minY)), new Dimension2DDouble(width, height), dimTitle, shadowing);
        ug = ug.apply(new UStroke());
        this.title.drawU(ug.apply(new UTranslate(this.minX + (width - dimTitle.getWidth()) / 2.0, this.minY + 10.0)));
    }

    private void drawWithTitleDatabase(UGraphic ug, HtmlColor borderColor, boolean shadowing) {
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        double width = this.maxX - this.minX;
        double height = this.maxY - this.minY;
        ug = ug.apply(this.defaultStroke);
        ug = ug.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(borderColor));
        PackageStyle.DATABASE.drawU(ug.apply(new UTranslate(this.minX, this.minY - 10.0)), new Dimension2DDouble(width, height + 10.0), dimTitle, shadowing);
        ug = ug.apply(new UStroke());
        this.title.drawU(ug.apply(new UTranslate(this.minX + 3.0, this.minY + 10.0)));
    }

    private void drawWithTitleFrame(UGraphic ug, HtmlColor borderColor, boolean shadowing) {
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        double width = this.maxX - this.minX;
        double height = this.maxY - this.minY;
        ug = ug.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(borderColor));
        ug = ug.apply(this.defaultStroke);
        PackageStyle.FRAME.drawU(ug.apply(new UTranslate(this.minX, this.minY)), new Dimension2DDouble(width, height), dimTitle, shadowing);
        ug = ug.apply(new UStroke());
        this.title.drawU(ug.apply(new UTranslate(this.minX + 3.0, this.minY)));
    }

    private void drawWithTitleCard(UGraphic ug, HtmlColor borderColor, boolean shadowing) {
        double width = this.maxX - this.minX;
        double height = this.maxY - this.minY;
        SymbolContext ctx = new SymbolContext(this.stateBack, borderColor).withStroke(this.defaultStroke).withShadow(shadowing);
        USymbol.CARD.asBig(this.title, TextBlockUtils.empty(0.0, 0.0), width + 10.0, height, ctx).drawU(ug.apply(new UTranslate(this.minX, this.minY)));
    }

    private void drawWithTitleNode(UGraphic ug, HtmlColor borderColor, boolean shadowing) {
        double width = this.maxX - this.minX;
        double height = this.maxY - this.minY;
        SymbolContext ctx = new SymbolContext(this.stateBack, borderColor).withStroke(this.defaultStroke).withShadow(shadowing);
        USymbol.NODE.asBig(this.title, TextBlockUtils.empty(0.0, 0.0), width + 10.0, height, ctx).drawU(ug.apply(new UTranslate(this.minX, this.minY)));
    }

    private UPolygon getSpecificFrontierForFolder(StringBounder stringBounder) {
        double width = this.maxX - this.minX;
        double height = this.maxY - this.minY;
        Dimension2D dimTitle = this.title.calculateDimension(stringBounder);
        double wtitle = dimTitle.getWidth() + 3.0 + 3.0;
        double htitle = dimTitle.getHeight() + 3.0 + 3.0;
        UPolygon shape = new UPolygon();
        shape.addPoint(0.0, 0.0);
        shape.addPoint(wtitle, 0.0);
        shape.addPoint(wtitle + 7.0, htitle);
        shape.addPoint(width, htitle);
        shape.addPoint(width, height);
        shape.addPoint(0.0, height);
        shape.addPoint(0.0, 0.0);
        return shape;
    }

    private void drawWithTitleFolder(UGraphic ug, HtmlColor borderColor, boolean shadowing) {
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        double wtitle = dimTitle.getWidth() + 3.0 + 3.0;
        double htitle = dimTitle.getHeight() + 3.0 + 3.0;
        UPolygon shape = this.getSpecificFrontierForFolder(ug.getStringBounder());
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug = ug.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(borderColor));
        ug = ug.apply(this.defaultStroke);
        ug.apply(new UTranslate(this.minX, this.minY)).draw(shape);
        ug.apply(new UTranslate(this.minX, this.minY + htitle)).draw(new ULine(wtitle + 7.0, 0.0));
        ug = ug.apply(new UStroke());
        this.title.drawU(ug.apply(new UTranslate(this.minX + 3.0, this.minY + 3.0)));
    }

    private void drawWithTitleRect(UGraphic ug, HtmlColor borderColor, boolean shadowing) {
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        double width = this.maxX - this.minX;
        double height = this.maxY - this.minY;
        URectangle shape = new URectangle(width, height);
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug = ug.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(borderColor));
        ug = ug.apply(this.defaultStroke);
        ug.apply(new UTranslate(this.minX, this.minY)).draw(shape);
        ug = ug.apply(new UStroke());
        double deltax = width - dimTitle.getWidth();
        this.title.drawU(ug.apply(new UTranslate(this.minX + deltax / 2.0, this.minY + 5.0)));
    }
}

