/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActiveLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActor;
import net.sourceforge.plantuml.skin.rose.ComponentRoseArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseBoundary;
import net.sourceforge.plantuml.skin.rose.ComponentRoseControl;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDatabase;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayText;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDivider;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEnglober;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEntity;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingHeader;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.ComponentRoseLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNewpage;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteBox;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteHexagonal;
import net.sourceforge.plantuml.skin.rose.ComponentRoseParticipant;
import net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import net.sourceforge.plantuml.skin.rose.ComponentRoseSelfArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseTitle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class Rose
implements Skin {
    private final double paddingX = 5.0;
    private final double paddingY = 5.0;

    public HtmlColor getFontColor(ISkinParam skin, FontParam fontParam) {
        return skin.getFontHtmlColor(fontParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam param, ColorParam color) {
        return this.getHtmlColor(param, color, null);
    }

    public HtmlColor getHtmlColor(ISkinParam param, ColorParam color, Stereotype stereotype) {
        HtmlColor result = param.getHtmlColor(color, stereotype, false);
        if (result == null && (result = color.getDefaultValue()) == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private FontConfiguration getUFont2(ISkinParam param, FontParam fontParam) {
        UFont font = param.getFont(fontParam, null, false);
        HtmlColor fontColor = this.getFontColor(param, fontParam);
        return new FontConfiguration(font, fontColor, param.getHyperlinkColor(), param.useUnderlineForHyperlink());
    }

    @Override
    public Component createComponent(ComponentType type, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        UFont fontGrouping = param.getFont(FontParam.SEQUENCE_GROUP, null, false);
        UFont newFontForStereotype = param.getFont(FontParam.SEQUENCE_STEREOTYPE, null, false);
        if (type.isArrow()) {
            HtmlColor sequenceArrow;
            HtmlColor htmlColor = sequenceArrow = config.getColor() == null ? this.getHtmlColor(param, ColorParam.sequenceArrow) : config.getColor();
            if (config.getArrowDirection() == ArrowDirection.SELF) {
                return new ComponentRoseSelfArrow(sequenceArrow, this.getUFont2(param, FontParam.SEQUENCE_ARROW), stringsToDisplay, config, (ISkinSimple)param, param.maxMessageSize(), !param.strictUmlStyle());
            }
            HorizontalAlignment messageHorizontalAlignment = param.getHorizontalAlignment(AlignParam.SEQUENCE_MESSAGE_ALIGN);
            HorizontalAlignment textHorizontalAlignment = param.getHorizontalAlignment(AlignParam.SEQUENCE_MESSAGETEXT_ALIGN);
            return new ComponentRoseArrow(sequenceArrow, this.getUFont2(param, FontParam.SEQUENCE_ARROW), stringsToDisplay, config, messageHorizontalAlignment, param, textHorizontalAlignment, param.maxMessageSize(), !param.strictUmlStyle());
        }
        if (type == ComponentType.PARTICIPANT_HEAD) {
            return new ComponentRoseParticipant(this.getSymbolContext(param, ColorParam.participantBorder), this.getUFont2(param, FontParam.PARTICIPANT), stringsToDisplay, param, param.getRoundCorner(), newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.PARTICIPANT_TAIL) {
            return new ComponentRoseParticipant(this.getSymbolContext(param, ColorParam.participantBorder), this.getUFont2(param, FontParam.PARTICIPANT), stringsToDisplay, param, param.getRoundCorner(), newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.PARTICIPANT_LINE) {
            HtmlColor borderColor = this.getHtmlColor(param, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(borderColor, false, Rose.getStroke(param, LineParam.sequenceLifeLineBorder, 1.0));
        }
        if (type == ComponentType.CONTINUE_LINE) {
            HtmlColor borderColor = this.getHtmlColor(param, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(borderColor, true, Rose.getStroke(param, LineParam.sequenceLifeLineBorder, 1.5));
        }
        if (type == ComponentType.ACTOR_HEAD) {
            return new ComponentRoseActor(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.ACTOR_TAIL) {
            return new ComponentRoseActor(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.BOUNDARY_HEAD) {
            return new ComponentRoseBoundary(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.BOUNDARY_TAIL) {
            return new ComponentRoseBoundary(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.CONTROL_HEAD) {
            return new ComponentRoseControl(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.CONTROL_TAIL) {
            return new ComponentRoseControl(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.ENTITY_HEAD) {
            return new ComponentRoseEntity(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.ENTITY_TAIL) {
            return new ComponentRoseEntity(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.DATABASE_HEAD) {
            return new ComponentRoseDatabase(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, true, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.DATABASE_TAIL) {
            return new ComponentRoseDatabase(this.getSymbolContext(param, ColorParam.actorBorder), this.getUFont2(param, FontParam.ACTOR), stringsToDisplay, false, param, newFontForStereotype, this.getFontColor(param, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (type == ComponentType.NOTE) {
            return new ComponentRoseNote(this.getSymbolContext(param, ColorParam.noteBorder), this.getUFont2(param, FontParam.NOTE), stringsToDisplay, 5.0, 5.0, param);
        }
        if (type == ComponentType.NOTE_HEXAGONAL) {
            return new ComponentRoseNoteHexagonal(this.getSymbolContext(param, ColorParam.noteBorder), this.getUFont2(param, FontParam.NOTE), stringsToDisplay, param);
        }
        if (type == ComponentType.NOTE_BOX) {
            return new ComponentRoseNoteBox(this.getSymbolContext(param, ColorParam.noteBorder), this.getUFont2(param, FontParam.NOTE), stringsToDisplay, param);
        }
        if (type == ComponentType.GROUPING_HEADER) {
            return new ComponentRoseGroupingHeader(param.getBackgroundColor(), this.getSymbolContext(param, ColorParam.sequenceGroupBorder), this.getUFont2(param, FontParam.SEQUENCE_GROUP_HEADER), fontGrouping, stringsToDisplay, param);
        }
        if (type == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(this.getHtmlColor(param, ColorParam.sequenceGroupBorder), this.getUFont2(param, FontParam.SEQUENCE_GROUP), stringsToDisplay.get(0), param, param.getBackgroundColor());
        }
        if (type == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(7.0);
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentRoseActiveLine(this.getSymbolContext(param, ColorParam.sequenceLifeLineBorder), true, true);
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentRoseActiveLine(this.getSymbolContext(param, ColorParam.sequenceLifeLineBorder), true, false);
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentRoseActiveLine(this.getSymbolContext(param, ColorParam.sequenceLifeLineBorder), false, true);
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentRoseActiveLine(this.getSymbolContext(param, ColorParam.sequenceLifeLineBorder), false, false);
        }
        if (type == ComponentType.DELAY_LINE) {
            return new ComponentRoseDelayLine(this.getHtmlColor(param, ColorParam.sequenceLifeLineBorder));
        }
        if (type == ComponentType.DELAY_TEXT) {
            return new ComponentRoseDelayText(this.getUFont2(param, FontParam.SEQUENCE_DELAY), stringsToDisplay, param);
        }
        if (type == ComponentType.DESTROY) {
            return new ComponentRoseDestroy(this.getHtmlColor(param, ColorParam.sequenceLifeLineBorder));
        }
        if (type == ComponentType.NEWPAGE) {
            return new ComponentRoseNewpage(this.getFontColor(param, FontParam.SEQUENCE_GROUP));
        }
        if (type == ComponentType.DIVIDER) {
            return new ComponentRoseDivider(this.getUFont2(param, FontParam.SEQUENCE_DIVIDER), this.getHtmlColor(param, ColorParam.sequenceDividerBackground), stringsToDisplay, param, this.deltaShadow(param) > 0.0, Rose.getStroke(param, LineParam.sequenceDividerBorder, 2.0));
        }
        if (type == ComponentType.REFERENCE) {
            return new ComponentRoseReference(this.getUFont2(param, FontParam.SEQUENCE_REFERENCE), this.getSymbolContext(param, ColorParam.sequenceReferenceBorder), this.getUFont2(param, FontParam.SEQUENCE_GROUP_HEADER), stringsToDisplay, param.getHorizontalAlignment(AlignParam.SEQUENCE_REFERENCE_ALIGN), param, this.getHtmlColor(param, ColorParam.sequenceReferenceBackground));
        }
        if (type == ComponentType.TITLE) {
            return new ComponentRoseTitle(this.getUFont2(param, FontParam.SEQUENCE_TITLE), stringsToDisplay, param);
        }
        if (type == ComponentType.SIGNATURE) {
            return new ComponentRoseTitle(fontGrouping.toFont2(HtmlColorUtils.BLACK, param.useUnderlineForHyperlink(), param.getHyperlinkColor()), Display.create("This skin was created ", "in April 2009."), param);
        }
        if (type == ComponentType.ENGLOBER) {
            return new ComponentRoseEnglober(this.getSymbolContext(param, ColorParam.sequenceBoxBorder), stringsToDisplay, this.getUFont2(param, FontParam.SEQUENCE_BOX), param);
        }
        return null;
    }

    private double deltaShadow(ISkinParam param) {
        return param.shadowing() ? 4.0 : 0.0;
    }

    private SymbolContext getSymbolContext(ISkinParam param, ColorParam color) {
        if (color == ColorParam.participantBorder) {
            return new SymbolContext(this.getHtmlColor(param, ColorParam.participantBackground), this.getHtmlColor(param, ColorParam.participantBorder)).withStroke(Rose.getStroke(param, LineParam.sequenceParticipantBorder, 1.5)).withDeltaShadow(this.deltaShadow(param));
        }
        if (color == ColorParam.actorBorder) {
            return new SymbolContext(this.getHtmlColor(param, ColorParam.actorBackground), this.getHtmlColor(param, ColorParam.actorBorder)).withStroke(Rose.getStroke(param, LineParam.sequenceActorBorder, 2.0)).withDeltaShadow(this.deltaShadow(param));
        }
        if (color == ColorParam.sequenceLifeLineBorder) {
            return new SymbolContext(this.getHtmlColor(param, ColorParam.sequenceLifeLineBackground), this.getHtmlColor(param, ColorParam.sequenceLifeLineBorder)).withDeltaShadow(this.deltaShadow(param));
        }
        if (color == ColorParam.noteBorder) {
            return new SymbolContext(this.getHtmlColor(param, ColorParam.noteBackground), this.getHtmlColor(param, ColorParam.noteBorder)).withStroke(Rose.getStroke(param, LineParam.noteBorder, 1.0)).withDeltaShadow(this.deltaShadow(param));
        }
        if (color == ColorParam.sequenceGroupBorder) {
            return new SymbolContext(this.getHtmlColor(param, ColorParam.sequenceGroupBackground), this.getHtmlColor(param, ColorParam.sequenceGroupBorder)).withStroke(Rose.getStroke(param, LineParam.sequenceGroupBorder, 2.0)).withDeltaShadow(this.deltaShadow(param));
        }
        if (color == ColorParam.sequenceBoxBorder) {
            return new SymbolContext(this.getHtmlColor(param, ColorParam.sequenceBoxBackground), this.getHtmlColor(param, ColorParam.sequenceBoxBorder));
        }
        if (color == ColorParam.sequenceReferenceBorder) {
            return new SymbolContext(this.getHtmlColor(param, ColorParam.sequenceReferenceHeaderBackground), this.getHtmlColor(param, ColorParam.sequenceReferenceBorder)).withStroke(Rose.getStroke(param, LineParam.sequenceReferenceBorder, 2.0)).withDeltaShadow(this.deltaShadow(param));
        }
        throw new IllegalArgumentException();
    }

    public static UStroke getStroke(ISkinParam param, LineParam lineParam, double defaultValue) {
        UStroke result = param.getThickness(lineParam, null);
        if (result == null) {
            return new UStroke(defaultValue);
        }
        return result;
    }

    @Override
    public Object getProtocolVersion() {
        return 1;
    }
}

