/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernActiveLine;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernActor;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernArrow;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernDelayLine;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernDelayText;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernDivider;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernEnglober;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernGroupingHeader;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernLine;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernNewpage;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernNote;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernParticipant;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernSelfArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import net.sourceforge.plantuml.skin.rose.ComponentRoseTitle;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;

public class BlueModern
implements Skin {
    private final UFont bigFont = new UFont("SansSerif", 1, 20);
    private final UFont participantFont = new UFont("SansSerif", 0, 17);
    private final UFont normalFont = new UFont("SansSerif", 0, 13);
    private final UFont smallFont = new UFont("SansSerif", 1, 11);
    private final HtmlColor hyperlinkColor = HtmlColorUtils.BLUE;
    private final boolean useUnderlineForHyperlink = true;
    private final HtmlColor blue1 = HtmlColorUtils.COL_527BC6;
    private final HtmlColor blue2 = HtmlColorUtils.COL_D1DBEF;
    private final HtmlColor blue3 = HtmlColorUtils.COL_D7E0F2;
    private final HtmlColor red = HtmlColorUtils.MY_RED;
    private final HtmlColor lineColor = HtmlColorUtils.COL_989898;
    private final HtmlColor borderGroupColor = HtmlColorUtils.COL_BBBBBB;

    @Override
    public Component createComponent(ComponentType type, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        if (type.isArrow()) {
            HtmlColor sequenceArrow;
            HtmlColor htmlColor = sequenceArrow = config.getColor() == null ? HtmlColorUtils.BLACK : config.getColor();
            if (config.isSelfArrow()) {
                return new ComponentBlueModernSelfArrow(sequenceArrow, this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), stringsToDisplay, config, param);
            }
            return new ComponentBlueModernArrow(sequenceArrow, true, this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), stringsToDisplay, config, param);
        }
        if (type == ComponentType.PARTICIPANT_HEAD) {
            return new ComponentBlueModernParticipant(this.blue1, this.blue2, this.participantFont.toFont2(HtmlColorUtils.WHITE, true, this.hyperlinkColor), stringsToDisplay, param);
        }
        if (type == ComponentType.PARTICIPANT_TAIL) {
            return new ComponentBlueModernParticipant(this.blue1, this.blue2, this.participantFont.toFont2(HtmlColorUtils.WHITE, true, this.hyperlinkColor), stringsToDisplay, param);
        }
        if (type == ComponentType.PARTICIPANT_LINE) {
            return new ComponentBlueModernLine(this.lineColor);
        }
        if (type == ComponentType.CONTINUE_LINE) {
            return new ComponentBlueModernLine(this.lineColor);
        }
        if (type == ComponentType.ACTOR_HEAD) {
            return new ComponentBlueModernActor(this.blue2, this.blue1, this.participantFont.toFont2(this.blue1, true, this.hyperlinkColor), stringsToDisplay, true, param);
        }
        if (type == ComponentType.ACTOR_TAIL) {
            return new ComponentBlueModernActor(this.blue2, this.blue1, this.participantFont.toFont2(this.blue1, true, this.hyperlinkColor), stringsToDisplay, false, param);
        }
        if (type == ComponentType.NOTE) {
            return new ComponentBlueModernNote(HtmlColorUtils.WHITE, HtmlColorUtils.BLACK, this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), stringsToDisplay, param);
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentBlueModernActiveLine(this.blue1, true, true);
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentBlueModernActiveLine(this.blue1, true, false);
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentBlueModernActiveLine(this.blue1, false, true);
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentBlueModernActiveLine(this.blue1, false, false);
        }
        if (type == ComponentType.DELAY_LINE) {
            return new ComponentBlueModernDelayLine(this.lineColor);
        }
        if (type == ComponentType.DELAY_TEXT) {
            return new ComponentBlueModernDelayText(param.getFont(FontParam.SEQUENCE_DELAY, null, false).toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), stringsToDisplay, param);
        }
        if (type == ComponentType.DESTROY) {
            return new ComponentRoseDestroy(this.red);
        }
        if (type == ComponentType.GROUPING_HEADER) {
            return new ComponentBlueModernGroupingHeader(this.blue1, this.blue3, this.borderGroupColor, HtmlColorUtils.BLACK, this.normalFont.toFont2(HtmlColorUtils.WHITE, true, this.hyperlinkColor), this.smallFont, stringsToDisplay, param);
        }
        if (type == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(HtmlColorUtils.BLACK, this.smallFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), stringsToDisplay.get(0), param, this.blue3);
        }
        if (type == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(7.0);
        }
        if (type == ComponentType.TITLE) {
            return new ComponentRoseTitle(this.bigFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), stringsToDisplay, param);
        }
        if (type == ComponentType.REFERENCE) {
            return new ComponentRoseReference(this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), new SymbolContext(this.blue1, this.borderGroupColor).withStroke(Rose.getStroke(param, LineParam.sequenceDividerBorder, 2.0)), this.normalFont.toFont2(HtmlColorUtils.WHITE, true, this.hyperlinkColor), stringsToDisplay, HorizontalAlignment.CENTER, param, this.blue3);
        }
        if (type == ComponentType.NEWPAGE) {
            return new ComponentBlueModernNewpage(this.blue1);
        }
        if (type == ComponentType.DIVIDER) {
            return new ComponentBlueModernDivider(this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), this.blue2, this.blue1, HtmlColorUtils.BLACK, stringsToDisplay, param);
        }
        if (type == ComponentType.SIGNATURE) {
            return new ComponentRoseTitle(this.smallFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), Display.create("This skin was created ", "in April 2009."), param);
        }
        if (type == ComponentType.ENGLOBER) {
            return new ComponentBlueModernEnglober(this.blue1, this.blue3, stringsToDisplay, param.getFont(FontParam.SEQUENCE_BOX, null, false).toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor), param);
        }
        return null;
    }

    @Override
    public Object getProtocolVersion() {
        return 1;
    }
}

