/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SkinParamBackcoloredReference;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Englober;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.HSpace;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Notes;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.Constraint;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.FrontierStack;
import net.sourceforge.plantuml.sequencediagram.graphic.FrontierStackImpl;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalDelayText;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalDivider;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElementLiveEvent;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalHSpace;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalNewpage;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalReference;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElementElse;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElementHeader;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElementTail;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.Lazy;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeDestroy;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeSegmentVariation;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.NotesBoxes;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1Message;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1MessageExo;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;

class DrawableSetInitializer {
    private ComponentType defaultLineType;
    private final DrawableSet drawableSet;
    private final boolean showTail;
    private double freeX = 0.0;
    private Frontier freeY2 = null;
    private Frontier lastFreeY2 = null;
    private final double autonewpage;
    private ConstraintSet constraintSet;
    private final InGroupablesStack inGroupableStack = new InGroupablesStack();

    public DrawableSetInitializer(Skin skin, ISkinParam skinParam, boolean showTail, double autonewpage) {
        this.drawableSet = new DrawableSet(skin, skinParam);
        this.showTail = showTail;
        this.autonewpage = autonewpage;
    }

    private boolean useContinueLineBecauseOfDelay() {
        String strategy = this.drawableSet.getSkinParam().getValue("lifelineStrategy");
        if ("nosolid".equalsIgnoreCase(strategy)) {
            return false;
        }
        if ("solid".equalsIgnoreCase(strategy)) {
            return true;
        }
        for (Event ev : this.drawableSet.getAllEvents()) {
            if (!(ev instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    private ParticipantRange getFullParticipantRange() {
        return new ParticipantRange(0, this.drawableSet.getAllParticipants().size());
    }

    private ParticipantRange getParticipantRange(Event ev) {
        return this.getFullParticipantRange();
    }

    public DrawableSet createDrawableSet(StringBounder stringBounder) {
        if (this.freeY2 != null) {
            throw new IllegalStateException();
        }
        this.defaultLineType = this.useContinueLineBecauseOfDelay() ? ComponentType.CONTINUE_LINE : ComponentType.PARTICIPANT_LINE;
        for (Participant p : this.drawableSet.getAllParticipants()) {
            this.prepareParticipant(stringBounder, p);
        }
        this.lastFreeY2 = this.freeY2 = new FrontierStackImpl(this.drawableSet.getHeadHeight(stringBounder), this.drawableSet.getAllParticipants().size());
        this.drawableSet.setTopStartingY(this.freeY2.getFreeY(this.getFullParticipantRange()));
        for (Participant p : this.drawableSet.getAllParticipants()) {
            LivingParticipantBox living = this.drawableSet.getLivingParticipantBox(p);
            for (int i = 0; i < p.getInitialLife(); ++i) {
                living.getLifeLine().addSegmentVariation(LifeSegmentVariation.LARGER, this.freeY2.getFreeY(this.getFullParticipantRange()), p.getLiveSpecificBackColor());
            }
        }
        ArrayList<ParticipantBox> col = new ArrayList<ParticipantBox>();
        for (LivingParticipantBox livingParticipantBox : this.drawableSet.getAllLivingParticipantBox()) {
            col.add(livingParticipantBox.getParticipantBox());
        }
        this.constraintSet = new ConstraintSet(col, this.freeX);
        for (Event ev : new ArrayList<Event>(this.drawableSet.getAllEvents())) {
            ParticipantRange range = this.getParticipantRange(ev);
            double diffY = this.freeY2.getFreeY(range) - this.lastFreeY2.getFreeY(range);
            if (this.autonewpage > 0.0 && diffY > 0.0 && diffY + this.getTotalHeight(0.0, stringBounder) > this.autonewpage) {
                this.prepareNewpageSpecial(stringBounder, new Newpage(null), ev, range);
            }
            if (ev instanceof MessageExo) {
                this.prepareMessageExo(stringBounder, (MessageExo)ev, range);
                continue;
            }
            if (ev instanceof Message) {
                this.prepareMessage(stringBounder, (Message)ev, range);
                continue;
            }
            if (ev instanceof Note) {
                this.prepareNote(stringBounder, (Note)ev, range);
                continue;
            }
            if (ev instanceof Notes) {
                this.prepareNotes(stringBounder, (Notes)ev, range);
                continue;
            }
            if (ev instanceof LifeEvent) {
                this.prepareLiveEvent(stringBounder, (LifeEvent)ev, range);
                continue;
            }
            if (ev instanceof GroupingLeaf) {
                this.prepareGroupingLeaf(stringBounder, (GroupingLeaf)ev, range);
                continue;
            }
            if (ev instanceof GroupingStart) {
                this.prepareGroupingStart(stringBounder, (GroupingStart)ev, range);
                continue;
            }
            if (ev instanceof Newpage) {
                this.prepareNewpage(stringBounder, (Newpage)ev, range);
                continue;
            }
            if (ev instanceof Divider) {
                this.prepareDivider(stringBounder, (Divider)ev, range);
                continue;
            }
            if (ev instanceof HSpace) {
                this.prepareHSpace(stringBounder, (HSpace)ev, range);
                continue;
            }
            if (ev instanceof Delay) {
                this.prepareDelay(stringBounder, (Delay)ev, col, range);
                continue;
            }
            if (ev instanceof Reference) {
                this.prepareReference(stringBounder, (Reference)ev, range);
                continue;
            }
            throw new IllegalStateException();
        }
        this.constraintSet.takeConstraintIntoAccount(stringBounder);
        this.takeParticipantEngloberTitleWidth3(stringBounder);
        this.prepareMissingSpace(stringBounder);
        this.drawableSet.setDimension(new Dimension2DDouble(this.freeX, this.getTotalHeight(this.freeY2.getFreeY(this.getFullParticipantRange()), stringBounder)));
        return this.drawableSet;
    }

    private void takeParticipantEngloberTitleWidth3(StringBounder stringBounder) {
        for (Englober pe : this.drawableSet.getExistingParticipantEnglober()) {
            double preferredWidth = this.drawableSet.getEngloberPreferedWidth(stringBounder, pe.getParticipantEnglober());
            ParticipantBox first = this.drawableSet.getLivingParticipantBox(pe.getFirst2TOBEPRIVATE()).getParticipantBox();
            ParticipantBox last = this.drawableSet.getLivingParticipantBox(pe.getLast2TOBEPRIVATE()).getParticipantBox();
            double x1 = this.drawableSet.getX1(pe);
            double x2 = this.drawableSet.getX2(stringBounder, pe);
            double missing = preferredWidth - (x2 - x1);
            if (!(missing > 0.0)) continue;
            this.constraintSet.pushToLeftParticipantBox(missing / 2.0, first, true);
            this.constraintSet.pushToLeftParticipantBox(missing / 2.0, last, false);
        }
    }

    private double getTotalHeight(double y, StringBounder stringBounder) {
        double signature = 0.0;
        return y + this.drawableSet.getTailHeight(stringBounder, this.showTail) + 0.0;
    }

    public double getYposition(StringBounder stringBounder, Newpage newpage) {
        if (newpage == null) {
            throw new IllegalArgumentException();
        }
        GraphicalNewpage graphicalNewpage = (GraphicalNewpage)this.drawableSet.getEvent(newpage);
        return graphicalNewpage.getStartingY();
    }

    private void prepareMissingSpace(StringBounder stringBounder) {
        this.freeX = this.constraintSet.getMaxX();
        double missingSpace1 = 0.0;
        double missingSpace2 = 0.0;
        for (GraphicalElement ev : this.drawableSet.getAllGraphicalElements()) {
            double endX;
            double delta2;
            GroupingGraphicalElementHeader gh;
            Arrow a;
            if (ev instanceof GraphicalDelayText) {
                double missing = ev.getPreferredWidth(stringBounder) - this.freeX;
                if (!(missing > 0.0)) continue;
                missingSpace1 = Math.max(missingSpace1, missing / 2.0);
                missingSpace2 = Math.max(missingSpace2, missing / 2.0);
                continue;
            }
            double startX = ev.getStartingX(stringBounder);
            double delta1 = -startX;
            if (delta1 > missingSpace1) {
                missingSpace1 = delta1;
            }
            if (ev instanceof Arrow) {
                Arrow a2 = (Arrow)ev;
                a2.setMaxX(this.freeX);
            }
            double width = ev.getPreferredWidth(stringBounder);
            if (ev instanceof Arrow && width < (a = (Arrow)ev).getActualWidth(stringBounder)) {
                width = a.getActualWidth(stringBounder);
            }
            if (ev instanceof GroupingGraphicalElementHeader && width < (gh = (GroupingGraphicalElementHeader)ev).getActualWidth(stringBounder)) {
                width = gh.getActualWidth(stringBounder);
            }
            if (!((delta2 = (endX = startX + width) - this.freeX) > missingSpace2)) continue;
            missingSpace2 = delta2;
        }
        if (missingSpace1 > 0.0) {
            this.constraintSet.pushToLeft(missingSpace1);
        }
        this.freeX = this.constraintSet.getMaxX() + missingSpace2;
    }

    private void prepareNewpage(StringBounder stringBounder, Newpage newpage, ParticipantRange range) {
        GraphicalNewpage graphicalNewpage = new GraphicalNewpage(this.freeY2.getFreeY(range), this.drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, this.drawableSet.getSkinParam(), null));
        this.lastFreeY2 = this.freeY2;
        this.freeY2 = this.freeY2.add(graphicalNewpage.getPreferredHeight(stringBounder), range);
        this.drawableSet.addEvent(newpage, graphicalNewpage);
    }

    private void prepareNewpageSpecial(StringBounder stringBounder, Newpage newpage, Event justBefore, ParticipantRange range) {
        GraphicalNewpage graphicalNewpage = new GraphicalNewpage(this.freeY2.getFreeY(range), this.drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, this.drawableSet.getSkinParam(), null));
        this.lastFreeY2 = this.freeY2;
        this.freeY2 = this.freeY2.add(graphicalNewpage.getPreferredHeight(stringBounder), range);
        this.drawableSet.addEvent(newpage, graphicalNewpage, justBefore);
    }

    private void prepareDivider(StringBounder stringBounder, Divider divider, ParticipantRange range) {
        GraphicalDivider graphicalDivider = new GraphicalDivider(this.freeY2.getFreeY(range), this.drawableSet.getSkin().createComponent(ComponentType.DIVIDER, null, this.drawableSet.getSkinParam(), divider.getText()));
        this.freeY2 = this.freeY2.add(graphicalDivider.getPreferredHeight(stringBounder), range);
        this.drawableSet.addEvent(divider, graphicalDivider);
    }

    private void prepareHSpace(StringBounder stringBounder, HSpace hspace, ParticipantRange range) {
        GraphicalHSpace graphicalHSpace = new GraphicalHSpace(this.freeY2.getFreeY(range), hspace.getPixel());
        this.freeY2 = this.freeY2.add(graphicalHSpace.getPreferredHeight(stringBounder), range);
        this.drawableSet.addEvent(hspace, graphicalHSpace);
    }

    private void prepareDelay(StringBounder stringBounder, Delay delay, List<ParticipantBox> participants, ParticipantRange range) {
        Component compText = this.drawableSet.getSkin().createComponent(ComponentType.DELAY_TEXT, null, this.drawableSet.getSkinParam(), delay.getText());
        ParticipantBox first = participants.get(0);
        ParticipantBox last = participants.get(participants.size() - 1);
        GraphicalDelayText graphicalDivider = new GraphicalDelayText(this.freeY2.getFreeY(range), compText, first, last);
        for (ParticipantBox p : participants) {
            p.addDelay(graphicalDivider);
        }
        this.freeY2 = this.freeY2.add(graphicalDivider.getPreferredHeight(stringBounder), range);
        this.drawableSet.addEvent(delay, graphicalDivider);
    }

    private void prepareGroupingStart(StringBounder stringBounder, GroupingStart m, ParticipantRange range) {
        if (m.getType() != GroupingType.START) {
            throw new IllegalStateException();
        }
        SkinParamBackcolored skinParam = new SkinParamBackcolored(this.drawableSet.getSkinParam(), m.getBackColorElement(), m.getBackColorGeneral());
        Component comp = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_SPACE, null, skinParam, Display.create(m.getComment()));
        double preferredHeight = comp.getPreferredHeight(stringBounder);
        this.freeY2 = this.freeY2.add(preferredHeight, range);
        Display strings = m.getTitle().equals("group") ? Display.create(m.getComment()) : Display.create(m.getTitle(), m.getComment());
        Component header = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_HEADER, null, skinParam, strings);
        ParticipantBox veryfirst = this.drawableSet.getVeryfirst();
        InGroupableList inGroupableList = new InGroupableList(veryfirst, m, this.freeY2.getFreeY(range));
        this.inGroupableStack.addList(inGroupableList);
        GroupingGraphicalElementHeader element = new GroupingGraphicalElementHeader(this.freeY2.getFreeY(range), header, inGroupableList, m.isParallel());
        inGroupableList.setMinWidth(((GraphicalElement)element).getPreferredWidth(stringBounder));
        this.freeY2 = this.freeY2.add(((GraphicalElement)element).getPreferredHeight(stringBounder), range);
        this.drawableSet.addEvent(m, element);
        if (m.isParallel()) {
            this.freeY2 = ((FrontierStack)this.freeY2).openBar();
        }
    }

    private void prepareGroupingLeaf(StringBounder stringBounder, final GroupingLeaf m, ParticipantRange range) {
        GroupingGraphicalElement element;
        SkinParamBackcolored skinParam = new SkinParamBackcolored(this.drawableSet.getSkinParam(), null, m.getBackColorGeneral());
        if (m.getType() == GroupingType.ELSE) {
            if (m.isParallel()) {
                this.freeY2 = ((FrontierStack)this.freeY2).restore();
            }
            Component compElse = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_ELSE, null, skinParam, Display.create(m.getComment()));
            Lazy lazy = new Lazy(){

                @Override
                public double getNow() {
                    GraphicalElement after = DrawableSetInitializer.this.drawableSet.getEvent(m.getJustAfter());
                    if (after == null) {
                        return 0.0;
                    }
                    return after.getStartingY();
                }
            };
            element = new GroupingGraphicalElementElse(this.freeY2.getFreeY(range), compElse, this.inGroupableStack.getTopGroupingStructure(), m.isParallel(), lazy);
            double preferredHeight = element.getPreferredHeight(stringBounder);
            this.freeY2 = this.freeY2.add(preferredHeight, range);
            this.inGroupableStack.addElement((GroupingGraphicalElementElse)element);
        } else if (m.getType() == GroupingType.END) {
            GroupingGraphicalElementHeader groupingHeaderStart;
            if (m.isParallel()) {
                this.freeY2 = ((FrontierStack)this.freeY2).closeBar();
            }
            if ((groupingHeaderStart = (GroupingGraphicalElementHeader)this.drawableSet.getEvent(m.getGroupingStart())) != null) {
                groupingHeaderStart.setEndY(this.freeY2.getFreeY(range));
            }
            element = new GroupingGraphicalElementTail(this.freeY2.getFreeY(range), this.inGroupableStack.getTopGroupingStructure(), m.isParallel());
            Component comp = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_SPACE, null, skinParam, Display.create(m.getComment()));
            double preferredHeight = comp.getPreferredHeight(stringBounder);
            this.freeY2 = this.freeY2.add(preferredHeight, range);
            this.inGroupableStack.pop();
        } else {
            throw new IllegalStateException();
        }
        this.drawableSet.addEvent(m, element);
    }

    private void prepareNote(StringBounder stringBounder, Note n, ParticipantRange range) {
        NoteBox noteBox = this.createNoteBox(stringBounder, n, range);
        this.inGroupableStack.addElement(noteBox);
        this.drawableSet.addEvent(n, noteBox);
        this.freeY2 = this.freeY2.add(noteBox.getPreferredHeight(stringBounder), range);
    }

    private NoteBox createNoteBox(StringBounder stringBounder, Note n, ParticipantRange range) {
        LivingParticipantBox p2;
        LivingParticipantBox p1 = this.drawableSet.getLivingParticipantBox(n.getParticipant());
        if (n.getParticipant2() == null) {
            p2 = null;
        } else {
            p2 = this.drawableSet.getLivingParticipantBox(n.getParticipant2());
            if (p1.getParticipantBox().getCenterX(stringBounder) > p2.getParticipantBox().getCenterX(stringBounder)) {
                LivingParticipantBox tmp = p1;
                p1 = p2;
                p2 = tmp;
            }
        }
        SkinParamBackcolored skinParam = n.getSkinParamBackcolored(this.drawableSet.getSkinParam());
        ComponentType type = this.getNoteComponentType(n.getStyle());
        NoteBox noteBox = new NoteBox(this.freeY2.getFreeY(range), this.drawableSet.getSkin().createComponent(type, null, skinParam, n.getStrings()), p1, p2, n.getPosition(), n.getUrl());
        return noteBox;
    }

    private void prepareNotes(StringBounder stringBounder, Notes notes, ParticipantRange range) {
        NotesBoxes notesBoxes = new NotesBoxes(this.freeY2.getFreeY(range));
        for (Note n : notes) {
            NoteBox noteBox = this.createNoteBox(stringBounder, n, range);
            ParticipantBox p1 = this.drawableSet.getLivingParticipantBox(n.getParticipant()).getParticipantBox();
            ParticipantBox p2 = n.getParticipant2() == null ? null : this.drawableSet.getLivingParticipantBox(n.getParticipant2()).getParticipantBox();
            notesBoxes.add(noteBox, p1, p2);
        }
        notesBoxes.ensureConstraints(stringBounder, this.constraintSet);
        this.inGroupableStack.addElement(notesBoxes);
        this.drawableSet.addEvent(notes, notesBoxes);
        this.freeY2 = this.freeY2.add(notesBoxes.getPreferredHeight(stringBounder), range);
    }

    private ComponentType getNoteComponentType(NoteStyle noteStyle) {
        if (noteStyle == NoteStyle.HEXAGONAL) {
            return ComponentType.NOTE_HEXAGONAL;
        }
        if (noteStyle == NoteStyle.BOX) {
            return ComponentType.NOTE_BOX;
        }
        return ComponentType.NOTE;
    }

    private void prepareLiveEvent(StringBounder stringBounder, LifeEvent lifeEvent, ParticipantRange range) {
        double pos2;
        double y = this.freeY2.getFreeY(range);
        AbstractMessage message = lifeEvent.getMessage();
        if (lifeEvent.getType() == LifeEventType.ACTIVATE) {
            double pos = 0.0;
            if (message != null) {
                int delta1 = 0;
                if (message.isCreate()) {
                    delta1 += 10;
                } else if (message.isSelfMessage()) {
                    delta1 += 8;
                }
                pos = message.getPosYstartLevel() + (double)delta1;
            }
            LifeLine line1 = this.drawableSet.getLivingParticipantBox(lifeEvent.getParticipant()).getLifeLine();
            line1.addSegmentVariation(LifeSegmentVariation.LARGER, pos, lifeEvent.getSpecificBackColor());
        } else if (lifeEvent.getType() == LifeEventType.DESTROY || lifeEvent.getType() == LifeEventType.DEACTIVATE) {
            double delta = 0.0;
            if (message != null && message.isSelfMessage()) {
                delta += 7.0;
            }
            Participant p = lifeEvent.getParticipant();
            LifeLine line = this.drawableSet.getLivingParticipantBox(p).getLifeLine();
            pos2 = y;
            if (message != null) {
                pos2 = message.getPosYendLevel() - delta;
            }
            line.addSegmentVariation(LifeSegmentVariation.SMALLER, pos2, lifeEvent.getSpecificBackColor());
        }
        if (lifeEvent.getType() == LifeEventType.DESTROY) {
            Component comp = this.drawableSet.getSkin().createComponent(ComponentType.DESTROY, null, this.drawableSet.getSkinParam(), null);
            double delta = comp.getPreferredHeight(stringBounder) / 2.0;
            LivingParticipantBox livingParticipantBox = this.drawableSet.getLivingParticipantBox(lifeEvent.getParticipant());
            pos2 = y;
            if (message == null) {
                pos2 = y;
                this.freeY2 = this.freeY2.add(comp.getPreferredHeight(stringBounder), range);
            } else {
                pos2 = message.getPosYendLevel() - delta;
            }
            LifeDestroy destroy = new LifeDestroy(pos2, livingParticipantBox.getParticipantBox(), comp);
            this.drawableSet.addEvent(lifeEvent, destroy);
        } else {
            this.drawableSet.addEvent(lifeEvent, new GraphicalElementLiveEvent(y));
        }
    }

    private void prepareMessageExo(StringBounder stringBounder, MessageExo m, ParticipantRange range) {
        Step1MessageExo step1Message = new Step1MessageExo(range, stringBounder, m, this.drawableSet, this.freeY2);
        this.freeY2 = step1Message.prepareMessage(this.constraintSet, this.inGroupableStack);
    }

    private void prepareMessage(StringBounder stringBounder, Message m, ParticipantRange range) {
        Step1Message step1Message = new Step1Message(range, stringBounder, m, this.drawableSet, this.freeY2);
        this.freeY2 = step1Message.prepareMessage(this.constraintSet, this.inGroupableStack);
    }

    private void prepareReference(StringBounder stringBounder, Reference reference, ParticipantRange range) {
        LivingParticipantBox p1 = this.drawableSet.getLivingParticipantBox(this.drawableSet.getFirst(reference.getParticipant()));
        LivingParticipantBox p2 = this.drawableSet.getLivingParticipantBox(this.drawableSet.getLast(reference.getParticipant()));
        SkinParamBackcoloredReference skinParam = new SkinParamBackcoloredReference(this.drawableSet.getSkinParam(), reference.getBackColorElement(), reference.getBackColorGeneral());
        Display strings = Display.empty();
        strings = strings.add("ref");
        strings = strings.addAll(reference.getStrings());
        Component comp = this.drawableSet.getSkin().createComponent(ComponentType.REFERENCE, null, skinParam, strings);
        GraphicalReference graphicalReference = new GraphicalReference(this.freeY2.getFreeY(range), comp, p1, p2, reference.getUrl());
        ParticipantBox pbox1 = p1.getParticipantBox();
        ParticipantBox pbox2 = p2.getParticipantBox();
        double width = graphicalReference.getPreferredWidth(stringBounder) - pbox1.getPreferredWidth(stringBounder) / 2.0 - pbox2.getPreferredWidth(stringBounder) / 2.0;
        Constraint constraint = p1 == p2 ? this.constraintSet.getConstraintAfter(pbox1) : this.constraintSet.getConstraint(pbox1, pbox2);
        constraint.ensureValue(width);
        this.inGroupableStack.addElement(graphicalReference);
        this.inGroupableStack.addElement(p1);
        if (p1 != p2) {
            this.inGroupableStack.addElement(p2);
        }
        this.freeY2 = this.freeY2.add(graphicalReference.getPreferredHeight(stringBounder), range);
        this.drawableSet.addEvent(reference, graphicalReference);
    }

    private void prepareParticipant(StringBounder stringBounder, Participant p) {
        ComponentType tailType;
        ComponentType headType;
        if (p.getType() == ParticipantType.PARTICIPANT) {
            headType = ComponentType.PARTICIPANT_HEAD;
            tailType = ComponentType.PARTICIPANT_TAIL;
        } else if (p.getType() == ParticipantType.ACTOR) {
            headType = ComponentType.ACTOR_HEAD;
            tailType = ComponentType.ACTOR_TAIL;
        } else if (p.getType() == ParticipantType.BOUNDARY) {
            headType = ComponentType.BOUNDARY_HEAD;
            tailType = ComponentType.BOUNDARY_TAIL;
        } else if (p.getType() == ParticipantType.CONTROL) {
            headType = ComponentType.CONTROL_HEAD;
            tailType = ComponentType.CONTROL_TAIL;
        } else if (p.getType() == ParticipantType.ENTITY) {
            headType = ComponentType.ENTITY_HEAD;
            tailType = ComponentType.ENTITY_TAIL;
        } else if (p.getType() == ParticipantType.DATABASE) {
            headType = ComponentType.DATABASE_HEAD;
            tailType = ComponentType.DATABASE_TAIL;
        } else {
            throw new IllegalArgumentException();
        }
        SkinParamBackcolored skinParam = p.getSkinParamBackcolored(this.drawableSet.getSkinParam());
        Display participantDisplay = p.getDisplay(skinParam.forceSequenceParticipantUnderlined());
        Component head = this.drawableSet.getSkin().createComponent(headType, null, skinParam, participantDisplay);
        Component tail = this.drawableSet.getSkin().createComponent(tailType, null, skinParam, participantDisplay);
        Component line = this.drawableSet.getSkin().createComponent(this.defaultLineType, null, this.drawableSet.getSkinParam(), participantDisplay);
        Component delayLine = this.drawableSet.getSkin().createComponent(ComponentType.DELAY_LINE, null, this.drawableSet.getSkinParam(), participantDisplay);
        ParticipantBox box = new ParticipantBox(head, line, tail, delayLine, this.freeX);
        Component comp = this.drawableSet.getSkin().createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, this.drawableSet.getSkinParam(), null);
        LifeLine lifeLine = new LifeLine(box, comp.getPreferredWidth(stringBounder), this.drawableSet.getSkinParam().shadowing());
        this.drawableSet.setLivingParticipantBox(p, new LivingParticipantBox(box, lifeLine));
        this.freeX = box.getMaxX(stringBounder);
    }

    public void addParticipant(Participant p, ParticipantEnglober participantEnglober) {
        this.drawableSet.addParticipant(p, participantEnglober);
    }

    public void addEvent(Event event) {
        this.drawableSet.addEvent(event, null);
    }
}

