/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.command.CommandArrow;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

abstract class CommandExoArrowAny
extends SingleLineCommand2<SequenceDiagram> {
    public CommandExoArrowAny(RegexConcat pattern) {
        super(pattern);
    }

    @Override
    protected final CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult arg2) {
        String error;
        ArrowConfiguration config;
        String body = arg2.getLazzy("ARROW_BODYA", 0) + arg2.getLazzy("ARROW_BODYB", 0);
        String dressing = arg2.getLazzy("ARROW_DRESSING", 0);
        Participant p = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg2.get("PARTICIPANT", 0)));
        boolean sync = dressing.length() == 2;
        boolean dotted = body.contains("--");
        Display labels = arg2.get("LABEL", 0) == null ? Display.create("") : Display.getWithNewlines(arg2.get("LABEL", 0));
        boolean bothDirection = arg2.get("ARROW_BOTHDRESSING", 0) != null;
        ArrowConfiguration arrowConfiguration = config = bothDirection ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (dotted) {
            config = config.withDotted();
        }
        if (sync) {
            config = config.withHead(ArrowHead.ASYNC);
        }
        config = config.withPart(this.getArrowPart(dressing));
        config = CommandArrow.applyStyle(arg2.getLazzy("ARROW_STYLE", 0), config);
        MessageExoType messageExoType = this.getMessageExoType(arg2);
        if (messageExoType == MessageExoType.TO_RIGHT || messageExoType == MessageExoType.TO_LEFT) {
            if (this.containsSymbolExterior(arg2, "o")) {
                config = config.withDecoration2(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(arg2, "o")) {
                config = config.withDecoration1(ArrowDecoration.CIRCLE);
            }
        } else {
            if (this.containsSymbolExterior(arg2, "o")) {
                config = config.withDecoration1(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(arg2, "o")) {
                config = config.withDecoration2(ArrowDecoration.CIRCLE);
            }
        }
        if (this.containsSymbolExterior(arg2, "x") || this.containsSymbol(arg2, "x")) {
            config = config.withHead2(ArrowHead.CROSSX);
        }
        if ((error = sequenceDiagram.addMessage(new MessageExo(p, messageExoType, labels, config, sequenceDiagram.getNextMessageNumber(), this.isShortArrow(arg2)))) != null) {
            return CommandExecutionResult.error(error);
        }
        return CommandExecutionResult.ok();
    }

    private ArrowPart getArrowPart(String dressing) {
        if (dressing.contains("/")) {
            return ArrowPart.BOTTOM_PART;
        }
        if (dressing.contains("\\")) {
            return ArrowPart.TOP_PART;
        }
        return ArrowPart.FULL;
    }

    abstract MessageExoType getMessageExoType(RegexResult var1);

    private boolean isShortArrow(RegexResult arg2) {
        String s = arg2.get("SHORT", 0);
        return s != null && s.contains("?");
    }

    private boolean containsSymbolExterior(RegexResult arg2, String symbol) {
        String s = arg2.get("SHORT", 0);
        return s != null && s.contains(symbol);
    }

    private boolean containsSymbol(RegexResult arg2, String symbol) {
        String s = arg2.get("ARROW_SUPPCIRCLE", 0);
        return s != null && s.contains(symbol);
    }
}

