/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;

public class Note
extends AbstractEvent
implements Event,
SpecificBackcolorable {
    private final Participant p;
    private final Participant p2;
    private final Display strings;
    private final NotePosition position;
    private NoteStyle style = NoteStyle.NORMAL;
    private final Url url;
    private HtmlColor specificBackcolor;

    public Note(Participant p, NotePosition position, Display strings) {
        this(p, null, position, strings);
    }

    public Note(Participant p, Participant p2, Display strings) {
        this(p, p2, NotePosition.OVER_SEVERAL, strings);
    }

    private Note(Participant p, Participant p2, NotePosition position, Display strings) {
        this.p = p;
        this.p2 = p2;
        this.position = position;
        if (strings != null && strings.size() > 0) {
            UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.STRICT);
            this.url = urlBuilder.getUrl(strings.get(0).toString());
        } else {
            this.url = null;
        }
        this.strings = this.url == null ? strings : strings.subList(1, strings.size());
    }

    public Participant getParticipant() {
        return this.p;
    }

    public Participant getParticipant2() {
        return this.p2;
    }

    public Display getStrings() {
        return this.strings;
    }

    public NotePosition getPosition() {
        return this.position;
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor color) {
        this.specificBackcolor = color;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.p == someone || this.p2 == someone;
    }

    @Override
    public Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public final NoteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(NoteStyle style) {
        this.style = style;
    }

    public SkinParamBackcolored getSkinParamBackcolored(ISkinParam skinParam) {
        return new SkinParamBackcolored(skinParam, this.getSpecificBackColor());
    }
}

