/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;

public class LifeEvent
extends AbstractEvent
implements Event {
    private final Participant p;
    private final LifeEventType type;
    private final HtmlColor backcolor;
    private AbstractMessage message;

    public LifeEvent(Participant p, LifeEventType type, HtmlColor backcolor) {
        this.p = p;
        this.type = type;
        this.backcolor = backcolor;
    }

    public String toString() {
        return "LifeEvent:" + this.p + " " + (Object)((Object)this.type);
    }

    public Participant getParticipant() {
        return this.p;
    }

    public LifeEventType getType() {
        return this.type;
    }

    public HtmlColor getSpecificBackColor() {
        return this.backcolor;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.p == someone;
    }

    public boolean isActivate() {
        return this.type == LifeEventType.ACTIVATE;
    }

    public boolean isDeactivateOrDestroy() {
        return this.type == LifeEventType.DEACTIVATE || this.type == LifeEventType.DESTROY;
    }

    @Deprecated
    public boolean isDestroy() {
        return this.type == LifeEventType.DESTROY;
    }

    public boolean isDestroy(Participant p) {
        return this.p == p && this.type == LifeEventType.DESTROY;
    }

    public void setMessage(AbstractMessage message) {
        this.message = message;
    }

    public AbstractMessage getMessage() {
        return this.message;
    }

    public void setLinkedToGroupingEnd(boolean linkedToGroupingEnd) {
    }
}

