/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;

public class Defines {
    private final Map<String, String> values = new LinkedHashMap<String, String>();
    private final Map<String, String> savedState = new LinkedHashMap<String, String>();

    public void define(String name, List<String> value) {
        this.values.put(name, this.addLineReturn(value));
    }

    private String addLineReturn(List<String> value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = value.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public boolean isDefine(String name) {
        for (String key : this.values.keySet()) {
            if (!key.equals(name) && !key.startsWith(name + "(")) continue;
            return true;
        }
        return false;
    }

    public void undefine(String name) {
        this.values.remove(name);
    }

    public List<String> applyDefines(String line) {
        for (Map.Entry<String, String> ent : this.values.entrySet()) {
            String key = ent.getKey();
            if (ent.getValue() == null) continue;
            String value = Matcher.quoteReplacement(ent.getValue());
            if (key.contains("(")) {
                StringTokenizer st = new StringTokenizer(key, "(),");
                String fctName = st.nextToken();
                String newValue = value;
                StringBuilder regex = new StringBuilder("\\b" + fctName + "\\(");
                int i = 1;
                while (st.hasMoreTokens()) {
                    if (st.hasMoreTokens()) {
                        regex.append("([^,]*?)");
                    } else {
                        regex.append("([^)]*?)");
                    }
                    String var1 = st.nextToken();
                    String var2 = "(##" + var1 + "\\b)|(\\b" + var1 + "##)|(\\b" + var1 + "\\b)";
                    newValue = newValue.replaceAll(var2, "\\$" + i);
                    ++i;
                    if (!st.hasMoreTokens()) continue;
                    regex.append(",");
                }
                regex.append("\\)");
                line = line.replaceAll(regex.toString(), newValue);
                continue;
            }
            String regex = "\\b" + key + "\\b";
            line = line.replaceAll(regex, value);
        }
        return Arrays.asList(line.split("\n"));
    }

    public void saveState() {
        if (this.savedState.size() > 0) {
            throw new IllegalStateException();
        }
        this.savedState.putAll(this.values);
    }

    public void restoreState() {
        this.values.clear();
        this.values.putAll(this.savedState);
    }
}

