/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public final class FactorySequenceNoteCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("VMERGE", "(/)?[%s]*"), new RegexLeaf("STYLE", "(note|hnote|rnote)[%s]+"), new RegexLeaf("POSITION", "(right|left|over)[%s]+"), new RegexLeaf("PARTICIPANT", "(?:of[%s]+)?([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("VMERGE", "(/)?[%s]*"), new RegexLeaf("STYLE", "(note|hnote|rnote)[%s]+"), new RegexLeaf("POSITION", "(right|left|over)[%s]+"), new RegexLeaf("PARTICIPANT", "(?:of[%s])?([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command<SequenceDiagram> createMultiLine() {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?(note|hnote|rnote)$";
            }

            @Override
            public CommandExecutionResult executeNow(SequenceDiagram system, BlocLines lines) {
                RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                return FactorySequenceNoteCommand.this.executeInternal(system, line0, lines);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram system, RegexResult arg) {
                return FactorySequenceNoteCommand.this.executeInternal(system, arg, BlocLines.getWithNewlines(arg.get("NOTE", 0)));
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram diagram, RegexResult arg, BlocLines strings) {
        Participant p = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("PARTICIPANT", 0)));
        NotePosition position = NotePosition.valueOf(StringUtils.goUpperCase(arg.get("POSITION", 0)));
        if (strings.size() > 0) {
            boolean tryMerge = arg.get("VMERGE", 0) != null;
            Note note = new Note(p, position, strings.toDisplay());
            note.setSpecificBackcolor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
            note.setStyle(NoteStyle.getNoteStyle(arg.get("STYLE", 0)));
            diagram.addNote(note, tryMerge);
        }
        return CommandExecutionResult.ok();
    }
}

