/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

public final class FactoryTipOnEntityCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;

    public FactoryTipOnEntityCommand(IRegex partialPattern) {
        this.partialPattern = partialPattern;
    }

    private RegexConcat getRegexConcatMultiLine(IRegex partialPattern) {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left)"), new RegexLeaf("[%s]+of[%s]+"), partialPattern, new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*\\{?"), new RegexLeaf("$"));
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine() {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(this.partialPattern), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^(end[%s]?note|\\})$";
            }

            @Override
            public CommandExecutionResult executeNow(AbstractEntityDiagram system, BlocLines lines) {
                RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                Url url = null;
                if (lines.size() > 0) {
                    UrlBuilder urlBuilder = new UrlBuilder(system.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                    url = urlBuilder.getUrl(lines.getFirst499().toString());
                }
                if (url != null) {
                    lines = lines.subExtract(1, 0);
                }
                return FactoryTipOnEntityCommand.this.executeInternal(line0, system, url, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult line0, AbstractEntityDiagram diagram, Url url, BlocLines lines) {
        String pos = line0.get("POSITION", 0);
        Code code = Code.of(line0.get("ENTITY", 0));
        String member = line0.get("ENTITY", 1);
        if (code == null) {
            return CommandExecutionResult.error("Nothing to note to");
        }
        IEntity cl1 = diagram.getOrCreateLeaf(code, null, null);
        Position position = Position.valueOf(StringUtils.goUpperCase(pos)).withRankdir(diagram.getSkinParam().getRankdir());
        Code codeTip = code.addSuffix("$$$" + position.name());
        IEntity tips = diagram.getLeafsget(codeTip);
        if (tips == null) {
            tips = diagram.getOrCreateLeaf(codeTip, LeafType.TIPS, null);
            LinkType type = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();
            Link link = position == Position.RIGHT ? new Link(cl1, tips, type, Display.NULL, 1) : new Link(tips, cl1, type, Display.NULL, 1);
            diagram.addLink(link);
        }
        tips.putTip(member, lines.toDisplay());
        return CommandExecutionResult.ok();
    }
}

