/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.regex.Matcher;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CommandMultilinesFooter
extends CommandMultilines<UmlDiagram> {
    public CommandMultilinesFooter() {
        super("(?i)^(?:(left|right|center)?[%s]*)footer$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?footer$";
    }

    @Override
    public CommandExecutionResult execute(UmlDiagram diagram, BlocLines lines) {
        Display strings;
        lines = lines.trim(false);
        Matcher m = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String align = m.group(1);
        if (align != null) {
            diagram.setFooterAlignment(HorizontalAlignment.valueOf(StringUtils.goUpperCase(align)));
        }
        if ((strings = (lines = lines.subExtract(1, 1)).toDisplay()).size() > 0) {
            diagram.setFooter(strings);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty footer");
    }
}

