/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileDiamond
extends AbstractFtile {
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock north;
    private final TextBlock south;
    private final TextBlock west1;
    private final TextBlock east1;

    public FtileDiamond(boolean shadowing, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane) {
        this(shadowing, backColor, borderColor, swimlane, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamond withNorth(TextBlock north) {
        return new FtileDiamond(this.shadowing(), this.backColor, this.borderColor, this.swimlane, north, this.south, this.east1, this.west1);
    }

    public FtileDiamond withWest(TextBlock west1) {
        if (west1 == null) {
            return this;
        }
        return new FtileDiamond(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, this.east1, west1);
    }

    public FtileDiamond withEast(TextBlock east1) {
        if (east1 == null) {
            return this;
        }
        return new FtileDiamond(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, east1, this.west1);
    }

    public FtileDiamond withSouth(TextBlock south) {
        return new FtileDiamond(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.north, south, this.east1, this.west1);
    }

    private FtileDiamond(boolean shadowing, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane, TextBlock north, TextBlock south, TextBlock east1, TextBlock west1) {
        super(shadowing);
        this.backColor = backColor;
        this.swimlane = swimlane;
        this.borderColor = borderColor;
        this.north = north;
        this.west1 = west1;
        this.east1 = east1;
        this.south = south;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5)).apply(new UChangeBackColor(this.backColor)).draw(Diamond.asPolygon(this.shadowing()));
        Dimension2D dimNorth = this.north.calculateDimension(ug.getStringBounder());
        this.north.drawU(ug.apply(new UTranslate(18.0, -dimNorth.getHeight() - 12.0)));
        Dimension2D dimSouth = this.south.calculateDimension(ug.getStringBounder());
        this.south.drawU(ug.apply(new UTranslate(-(dimSouth.getWidth() - 24.0) / 2.0, 24.0)));
        Dimension2D dimWeat1 = this.west1.calculateDimension(ug.getStringBounder());
        this.west1.drawU(ug.apply(new UTranslate(-dimWeat1.getWidth(), -dimWeat1.getHeight() + 12.0)));
        Dimension2D dimEast1 = this.east1.calculateDimension(ug.getStringBounder());
        this.east1.drawU(ug.apply(new UTranslate(24.0, -dimEast1.getHeight() + 12.0)));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2DDouble dim = new Dimension2DDouble(24.0, 24.0);
        return new FtileGeometry(dim, ((Dimension2D)dim).getWidth() / 2.0, 0.0, ((Dimension2D)dim).getHeight());
    }
}

