/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class FtileIfWithDiamonds
extends FtileIfNude {
    private final double SUPP_WITH = 20.0;
    protected final Ftile diamond1;
    protected final Ftile diamond2;

    public FtileIfWithDiamonds(Ftile diamond1, Ftile tile1, Ftile tile2, Ftile diamond2, Swimlane in, StringBounder stringBounder) {
        super(tile1, tile2, in);
        this.diamond1 = diamond1;
        this.diamond2 = diamond2;
    }

    public int getYdelta1a(StringBounder stringBounder) {
        if (this.getSwimlanes().size() > 1) {
            return 20;
        }
        return 10;
    }

    public int getYdelta1b(StringBounder stringBounder) {
        if (this.getSwimlanes().size() > 1) {
            return 10;
        }
        return this.hasTwoBranches(stringBounder) ? 6 : 0;
    }

    @Override
    protected double withInner(StringBounder stringBounder) {
        FtileGeometry dim1 = this.diamond1.calculateDimension(stringBounder);
        return Math.max(super.withInner(stringBounder), dim1.getWidth() + 20.0);
    }

    @Override
    protected Dimension2D calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry dim1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.diamond2.calculateDimension(stringBounder);
        Dimension2D dimNude = super.calculateDimensionInternalSlow(stringBounder);
        double width = MathUtils.max(dim1.getWidth(), dim2.getWidth(), dimNude.getWidth());
        double height = dimNude.getHeight() + dim1.getHeight() + dim2.getHeight() + (double)this.getYdelta1a(stringBounder) + (double)this.getYdelta1b(stringBounder);
        return new Dimension2DDouble(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        super.drawU(ug);
        ug.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
    }

    @Override
    protected UTranslate getTranslate1(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        return super.getTranslate1(stringBounder).compose(new UTranslate(0.0, ((Dimension2D)dimDiamond1).getHeight() + (double)this.getYdelta1a(stringBounder)));
    }

    @Override
    protected UTranslate getTranslate2(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        return super.getTranslate2(stringBounder).compose(new UTranslate(0.0, ((Dimension2D)dimDiamond1).getHeight() + (double)this.getYdelta1a(stringBounder)));
    }

    protected UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        double y1 = 0.0;
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double x1 = this.getLeft(stringBounder) - ((Dimension2D)dimDiamond1).getWidth() / 2.0;
        return new UTranslate(x1, 0.0);
    }

    protected UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double y2 = dimTotal.getHeight() - ((Dimension2D)dimDiamond2).getHeight();
        double x2 = this.getLeft(stringBounder) - ((Dimension2D)dimDiamond2).getWidth() / 2.0;
        return new UTranslate(x2, y2);
    }
}

